/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.vercheck;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import net.bnubot.core.ChatQueue;
import net.bnubot.core.PluginManager;
import net.bnubot.settings.GlobalSettings;
import net.bnubot.settings.Settings;
import net.bnubot.util.BNetUser;
import net.bnubot.util.OperatingSystem;
import net.bnubot.util.Out;
import net.bnubot.util.SHA1Sum;
import net.bnubot.util.URLDownloader;
import net.bnubot.vercheck.CurrentVersion;
import net.bnubot.vercheck.ReleaseType;
import net.bnubot.vercheck.VersionNumber;
import net.bnubot.vercheck.XMLElementDecorator;
import org.jbls.util.Constants;

public class VersionCheck {
    private static final String VERSION_CHECK_TIME = "versionCheckTime";
    protected static XMLElementDecorator elem = null;
    protected static VersionNumber vnLatest = null;

    public static boolean checkVersion(boolean force) throws Exception {
        return VersionCheck.checkVersion(force, null, false);
    }

    public static boolean checkVersion(boolean force, BNetUser bnSubject, boolean whisperBack) throws Exception {
        if (!force) {
            long lastVersionCheck = Settings.getSection(null).read(VERSION_CHECK_TIME, 0L);
            long now = System.currentTimeMillis();
            if (now - lastVersionCheck < 21600000L) {
                return false;
            }
        }
        return VersionCheck.checkVersion(false, GlobalSettings.releaseType, bnSubject, whisperBack);
    }

    private static boolean checkVersion(boolean forceDownload, ReleaseType rt, BNetUser bnSubject, boolean whisperBack) throws Exception {
        if (CurrentVersion.fromJar()) {
            String path = System.getProperty("net.bnubot.jarpath", "BNUBot.jar");
            if (!new File(path).exists()) {
                throw new FileNotFoundException(path);
            }
            return VersionCheck.checkVersion(forceDownload, rt, path, null, bnSubject, whisperBack);
        }
        return VersionCheck.checkVersion(false, rt, null, null, bnSubject, whisperBack);
    }

    protected static boolean checkVersion(boolean forceDownload, ReleaseType rt, String jarFileName, String downloadFolder) throws Exception {
        return VersionCheck.checkVersion(forceDownload, rt, jarFileName, downloadFolder, null, false);
    }

    private static boolean checkVersion(boolean forceDownload, ReleaseType rt, String jarFileName, String downloadFolder, BNetUser bnSubject, boolean whisperBack) throws Exception {
        boolean cv = VersionCheck.doCheckVersion(forceDownload, rt, jarFileName, downloadFolder, bnSubject, whisperBack);
        URLDownloader.flush();
        if (!cv) {
            if (bnSubject == null) {
                Out.debug(VersionCheck.class, "No update available.");
            } else {
                bnSubject.sendChat("No update available.", whisperBack);
            }
        }
        return cv;
    }

    private static boolean doCheckVersion(boolean forceDownload, ReleaseType rt, String jarFileName, String downloadFolder, BNetUser bnSubject, boolean whisperBack) throws Exception {
        File thisJar;
        XMLElementDecorator verLatest;
        XMLElementDecorator gamesElem;
        XMLElementDecorator downloads;
        XMLElementDecorator error;
        if (!forceDownload) {
            Settings.getSection(null).write(VERSION_CHECK_TIME, System.currentTimeMillis());
            Settings.store();
        }
        try {
            String url = "http://www.clanbnu.net/bnubot/version.php?";
            if (!forceDownload && CurrentVersion.version().getSvnRevision() != null) {
                url = String.valueOf(url) + "svn=" + CurrentVersion.version().getSvnRevision() + "&";
            }
            url = String.valueOf(url) + "release=" + rt.toString();
            url = String.valueOf(url) + "&os=" + OperatingSystem.userOS.name();
            if (Out.isDebug(VersionCheck.class)) {
                Out.debugAlways(VersionCheck.class, "Requesting latest version from " + url);
            }
            elem = XMLElementDecorator.parse(url);
        }
        catch (Exception e) {
            if (bnSubject == null) {
                Out.error(VersionCheck.class, "Failed to get latest version: " + e.getClass().getSimpleName() + ".");
            } else {
                bnSubject.sendChat("Failed to get latest version: " + e.getClass().getSimpleName() + ".", whisperBack);
            }
            return false;
        }
        if (downloadFolder != null) {
            jarFileName = String.valueOf(downloadFolder) + File.separatorChar + jarFileName;
        }
        if ((error = elem.getChild("error")) != null) {
            if (bnSubject == null) {
                Out.error(VersionCheck.class, error.getString());
            } else {
                bnSubject.sendChat(error.getString(), whisperBack);
            }
            return false;
        }
        XMLElementDecorator motd = elem.getPath("bnubot/motd");
        if (motd != null && motd.getString() != null) {
            Out.info(VersionCheck.class, motd.getString());
        }
        if ((forceDownload || CurrentVersion.fromJar()) && (downloads = elem.getPath("bnubot/downloads")) != null) {
            XMLElementDecorator[] xMLElementDecoratorArray = downloads.getChildren("file");
            int n = xMLElementDecoratorArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLElementDecorator file = xMLElementDecoratorArray[n2];
                XMLElementDecorator sha1Element = file.getChild("sha1");
                SHA1Sum sha1 = null;
                if (sha1Element != null) {
                    sha1 = new SHA1Sum(sha1Element.getString());
                }
                String from = file.getChild("from").getString();
                String to = file.getChild("to").getString();
                if (downloadFolder != null) {
                    to = String.valueOf(downloadFolder) + File.separatorChar + to;
                }
                URLDownloader.downloadURL(new URL(from), new File(to), sha1, false);
                ++n2;
            }
        }
        if ((gamesElem = elem.getPath("bnubot/games")) != null) {
            int i = 0;
            while (i < Constants.prods.length) {
                int vb;
                String game = Constants.prods[i];
                int verByte = Constants.IX86verbytes[i];
                XMLElementDecorator gameElem = gamesElem.getPath(game);
                if (gameElem != null && verByte != (vb = gameElem.getPath("verbyte").getInt().intValue())) {
                    Out.error(VersionCheck.class, "Verbyte for game " + game + " is updating from 0x" + Integer.toHexString(verByte) + " to 0x" + Integer.toHexString(vb));
                    Constants.IX86verbytes[i] = vb;
                }
                ++i;
            }
        }
        if ((verLatest = elem.getPath("bnubot/latestVersion")) == null) {
            return false;
        }
        String releaseType = verLatest.getChild("type").getString();
        if (releaseType == null) {
            throw new NullPointerException("type is null\n" + verLatest.toString());
        }
        vnLatest = new VersionNumber(Enum.valueOf(ReleaseType.class, releaseType), verLatest.getChild("major").getInt(), verLatest.getChild("minor").getInt(), verLatest.getChild("revision").getInt(), verLatest.getChild("release").getInt(), verLatest.getChild("svn").getInt(), verLatest.getChild("built").getDate());
        String url = verLatest.getChild("url").getString();
        XMLElementDecorator sha1Element = verLatest.getChild("sha1");
        SHA1Sum sha1 = null;
        if (sha1Element != null && sha1Element.getString() != null) {
            sha1 = new SHA1Sum(sha1Element.getString());
        }
        if (forceDownload) {
            if (url == null) {
                return false;
            }
            URLDownloader.downloadURL(new URL(url), new File(jarFileName), sha1, true);
            return true;
        }
        if (!vnLatest.isNewerThan(CurrentVersion.version())) {
            return false;
        }
        Out.error(VersionCheck.class, "Latest version: " + vnLatest.toString());
        if (url == null) {
            return true;
        }
        if (jarFileName != null && (thisJar = new File(jarFileName)).exists()) {
            boolean doUpdate = true;
            try {
                if (bnSubject == null && PluginManager.getEnableGui()) {
                    String msg = "BNU-Bot version " + vnLatest.toString() + " is available.\nWould you like to update?";
                    doUpdate = JOptionPane.showConfirmDialog(null, msg, "BNU-Bot update available", 0, 3) == 0;
                }
            }
            catch (Exception e) {
                Out.exception(e);
            }
            if (doUpdate) {
                String command;
                String parentFolder = thisJar.getAbsolutePath();
                parentFolder = parentFolder.substring(0, parentFolder.lastIndexOf(File.separatorChar) + 1);
                File to = new File(String.valueOf(parentFolder) + "download.jar");
                URLDownloader.downloadURL(new URL(url), to, sha1, true);
                URLDownloader.flush();
                switch (OperatingSystem.userOS) {
                    case WINDOWS: {
                        command = "BNUBot.exe";
                        break;
                    }
                    case OSX: {
                        command = "Contents/MacOS/JavaApplicationStub";
                        break;
                    }
                    default: {
                        command = "./run.sh";
                    }
                }
                VersionCheck.renameFile(thisJar, new File(String.valueOf(parentFolder) + CurrentVersion.version().toFileName()));
                VersionCheck.renameFile(to, thisJar);
                to.delete();
                try {
                    if (bnSubject == null && PluginManager.getEnableGui()) {
                        JOptionPane.showMessageDialog(null, "Update complete. BNU-Bot will now attempt to restart.");
                    }
                }
                catch (Exception e) {
                    Out.exception(e);
                }
                if (bnSubject != null) {
                    bnSubject.sendChat("Updated to " + vnLatest.toString() + "; restarting", whisperBack);
                    long target = System.currentTimeMillis() + 10000L;
                    ChatQueue cq = bnSubject.getConnection().getProfile().getChatQueue();
                    while (cq.size() > 0 && target > System.currentTimeMillis()) {
                        Thread.sleep(100L);
                        Thread.yield();
                    }
                }
                try {
                    Runtime.getRuntime().exec(command);
                }
                catch (Throwable e) {
                    Out.exception(e);
                }
                System.exit(0);
            }
            return true;
        }
        Out.error(VersionCheck.class, "Update: " + url);
        return true;
    }

    private static void renameFile(File from, File to) throws IOException {
        int c;
        if (from.renameTo(to)) {
            return;
        }
        FileInputStream is = new FileInputStream(from);
        FileOutputStream os = new FileOutputStream(to);
        byte[] b = new byte[1024];
        while ((c = is.read(b)) != -1) {
            os.write(b, 0, c);
        }
        os.close();
        is.close();
        to.setLastModified(from.lastModified());
    }
}

