/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import net.bnubot.util.Out;

public class SHA1Sum {
    private final byte[] sha1sum;
    private String display = null;

    public SHA1Sum(String hexStr) throws Exception {
        if (!hexStr.matches("[0-9a-fA-F]{40}")) {
            throw new Exception("Invalid format: " + hexStr);
        }
        this.display = hexStr.toLowerCase();
        this.sha1sum = new byte[20];
        int i = 0;
        while (i < 20) {
            int pos = i << 1;
            this.sha1sum[i] = (byte)Integer.parseInt(hexStr.substring(pos, pos + 2), 16);
            ++i;
        }
    }

    public SHA1Sum(byte[] bytes) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        digest.update(bytes, 0, bytes.length);
        this.sha1sum = digest.digest();
    }

    public SHA1Sum(File f) throws Exception {
        int read;
        MessageDigest digest = MessageDigest.getInstance("SHA1");
        FileInputStream is = new FileInputStream(f);
        byte[] buffer = new byte[8192];
        while ((read = ((InputStream)is).read(buffer)) > 0) {
            digest.update(buffer, 0, read);
        }
        this.sha1sum = digest.digest();
        if (Out.isDebug(SHA1Sum.class)) {
            Out.debugAlways(this.getClass(), String.valueOf(f.getName()) + ": " + this.toString());
        }
    }

    private static String hexChr(int b) {
        return Integer.toHexString(b & 0xF);
    }

    private static String toHex(int b) {
        return String.valueOf(SHA1Sum.hexChr((b & 0xF0) >> 4)) + SHA1Sum.hexChr(b & 0xF);
    }

    public String toString() {
        if (this.display == null) {
            this.display = "";
            byte[] byArray = this.sha1sum;
            int n = this.sha1sum.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                this.display = String.valueOf(this.display) + SHA1Sum.toHex(b);
                ++n2;
            }
        }
        return this.display;
    }

    public byte[] getSum() {
        return this.sha1sum;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SHA1Sum)) {
            return false;
        }
        byte[] obj_sha1sum = ((SHA1Sum)obj).sha1sum;
        if (this.sha1sum.length != obj_sha1sum.length) {
            return false;
        }
        int i = 0;
        while (i < this.sha1sum.length) {
            if (this.sha1sum[i] != obj_sha1sum[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

