/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.JOptionPane;
import net.bnubot.bot.gui.GuiDesktop;
import net.bnubot.core.PluginManager;
import net.bnubot.settings.Settings;
import net.bnubot.util.OutputHandler;
import net.bnubot.util.SortedProperties;
import net.bnubot.util.TimeFormatter;
import net.bnubot.util.UnloggedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Out {
    private static PrintStream outStream = System.out;
    private static final ThreadLocal<OutputHandler> outHandler = new ThreadLocal();
    private static OutputHandler outHandlerDefault = null;
    private static boolean globalDebug = Settings.getSection(null).read("debug", false);
    private static final Properties debug = new SortedProperties();
    private static final File debugFile = new File("debug.properties");

    static {
        try {
            if (debugFile.exists()) {
                debug.load(new FileInputStream(debugFile));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getRelevantStack(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String[] lines = sw.toString().trim().split("\n");
        String out = lines[0];
        boolean ellipsis = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).startsWith("at net.bnubot.") || line.startsWith("Caused by:")) {
                out = String.valueOf(out) + "\n" + line;
                ellipsis = false;
            } else if (!ellipsis) {
                ellipsis = true;
                out = String.valueOf(out) + "\n...";
            }
            ++n2;
        }
        return out;
    }

    private static OutputHandler getOutputHandler() {
        Thread t = Thread.currentThread();
        if (t instanceof OutputHandler) {
            return (OutputHandler)((Object)t);
        }
        OutputHandler oh = outHandler.get();
        if (oh != null) {
            return oh;
        }
        return outHandlerDefault;
    }

    public static void exception(Throwable e) {
        OutputHandler oh = Out.getOutputHandler();
        if (oh != null) {
            Out.error(e.getClass(), e.getMessage());
        }
        if (!(e instanceof UnloggedException)) {
            Out.logException(e);
        }
    }

    private static void logException(Throwable e) {
        if (outStream != null) {
            e.printStackTrace(outStream);
        } else {
            e.printStackTrace();
        }
    }

    public static void popupException(Throwable e, Component parent) {
        Dialog dialog = null;
        boolean isModal = false;
        if (parent != null && parent instanceof Dialog) {
            dialog = (Dialog)parent;
            isModal = dialog.isModal();
            dialog.setModal(false);
        }
        JOptionPane.showMessageDialog(parent, Out.getRelevantStack(e), e.getClass().getName(), 0);
        if (isModal) {
            dialog.setModal(true);
        }
        Out.logException(e);
    }

    public static void popupException(Throwable e) {
        Out.logException(e);
        try {
            JOptionPane.showMessageDialog(null, "A fatal error has occurred:\n\n" + Out.getRelevantStack(e), e.getClass().getSimpleName(), 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void fatalException(Throwable e) {
        Out.popupException(e);
        System.exit(1);
    }

    public static void error(Class<?> source, String text) {
        OutputHandler oh = Out.getOutputHandler();
        if (oh != null) {
            oh.dispatchRecieveError("(" + source.getSimpleName() + ") " + text);
        } else if (outStream != null) {
            outStream.println("[" + TimeFormatter.getTimestamp() + "] (" + source.getSimpleName() + ") ERROR " + text);
        }
    }

    public static void debug(Class<?> source, String text) {
        if (Out.isDebug(source)) {
            Out.debugAlways(source, text);
        }
    }

    public static void debugAlways(Class<?> source, String text) {
        OutputHandler oh = Out.getOutputHandler();
        if (oh != null) {
            oh.dispatchRecieveDebug("(" + source.getSimpleName() + ") " + text);
        } else if (outStream != null) {
            outStream.println("[" + TimeFormatter.getTimestamp() + "] (" + source.getSimpleName() + ") DEBUG " + text);
        }
    }

    public static void info(Class<?> source, String text) {
        OutputHandler oh = Out.getOutputHandler();
        if (oh != null) {
            oh.dispatchRecieveInfo("(" + source.getSimpleName() + ") " + text);
        } else if (outStream != null) {
            outStream.println("[" + TimeFormatter.getTimestamp() + "] (" + source.getSimpleName() + ") INFO " + text);
        }
    }

    public static void setOutputStream(PrintStream s) {
        outStream = s;
    }

    public static void setThreadOutputConnection(OutputHandler oh) {
        outHandler.set(oh);
    }

    public static void setDefaultOutputConnection(OutputHandler oh) {
        outHandlerDefault = oh;
    }

    public static void setDebug(boolean debug) {
        if (globalDebug == debug) {
            return;
        }
        globalDebug = debug;
        try {
            if (PluginManager.getEnableGui()) {
                GuiDesktop.updateDebugMenuChecked();
            }
            Out.debug(Out.class, "Debug logging " + (debug ? "en" : "dis") + "abled");
            Settings.getSection(null).write("debug", debug);
            Settings.store();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDebug(String clazz, boolean debug) {
        boolean current;
        if (Out.debug.containsKey(clazz) && (current = Boolean.parseBoolean(Out.debug.getProperty(clazz))) == debug) {
            return;
        }
        Out.debug.setProperty(clazz, Boolean.toString(debug));
        Out.debug(Out.class, "Debug logging {" + clazz + "} " + (debug ? "en" : "dis") + "abled");
        try {
            Out.debug.store(new FileOutputStream(debugFile), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isDebug() {
        return globalDebug;
    }

    public static boolean isDebug(Class<?> clazz) {
        return Out.isDebug(clazz.getName());
    }

    public static boolean isDebug(String clazz) {
        if (!globalDebug) {
            return false;
        }
        if (debug.containsKey(clazz)) {
            return Boolean.parseBoolean(debug.getProperty(clazz));
        }
        Out.setDebug(clazz, true);
        return true;
    }

    public static Properties getProperties() {
        return debug;
    }
}

