/*
 * Decompiled with CFR 0.152.
 */
package net.bnubot.util;

import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatingSystem {
    WINDOWS,
    OSX,
    LINUX,
    UNKNOWN;

    public static final OperatingSystem userOS;

    static {
        userOS = OperatingSystem.initOS();
    }

    private static OperatingSystem initOS() {
        String osName = System.getProperty("os.name");
        if (osName.equals("Mac OS X")) {
            return OSX;
        }
        if (osName.startsWith("Windows ")) {
            return WINDOWS;
        }
        if (osName.startsWith("Linux")) {
            return LINUX;
        }
        return UNKNOWN;
    }

    public static String osVersion() {
        Properties p = System.getProperties();
        String osName = p.getProperty("os.name");
        String osVersion = p.getProperty("os.version");
        if (osVersion != null && osVersion.length() != 0) {
            osName = String.valueOf(osName) + " " + osVersion;
        }
        switch (userOS) {
            case OSX: {
                if (osVersion.startsWith("10.0")) {
                    osName = String.valueOf(osName) + " Cheetah";
                    break;
                }
                if (osVersion.startsWith("10.1")) {
                    osName = String.valueOf(osName) + " Puma";
                    break;
                }
                if (osVersion.startsWith("10.2")) {
                    osName = String.valueOf(osName) + " Jaguar";
                    break;
                }
                if (osVersion.startsWith("10.3")) {
                    osName = String.valueOf(osName) + " Panther";
                    break;
                }
                if (osVersion.startsWith("10.4")) {
                    osName = String.valueOf(osName) + " Tiger";
                    break;
                }
                if (!osVersion.startsWith("10.5")) break;
                osName = String.valueOf(osName) + " Leopard";
                break;
            }
            case WINDOWS: {
                osName = String.valueOf(osName) + " " + p.getProperty("sun.os.patch.level");
            }
        }
        osName = String.valueOf(osName) + " (" + p.getProperty("os.arch") + ")";
        return osName;
    }

    public static String javaVersion() {
        return "Java " + System.getProperties().getProperty("java.version");
    }
}

