Attribute VB_Name = "modStatStrings"
Option Explicit

Public Function DecodeMapData(ByVal Encoded As String, ByRef Decoded As String) As Long
Dim enc()  As Byte
Dim dec()  As Byte
Dim I      As Long
Dim J      As Long
Dim D      As Byte
Dim lngLen As Long
  enc = StrConv(Encoded, vbFromUnicode)
  For I = 0 To UBound(enc)
    If (I Mod 8) Then
      ReDim Preserve dec(lngLen)
      dec(lngLen) = (enc(I) And ((RShift(D, 1 + J) Or Not 1)))
      J = J + 1
      lngLen = lngLen + 1
    Else
      J = 0
      D = enc(I)
    End If
  Next I
  Decoded = StrConv(dec, vbUnicode)
  DecodeMapData = lngLen
End Function

Private Function GamePenalty(ByVal strCase As String) As String
  Select Case strCase
    Case "2"
      GamePenalty = "Disconnect is a Loss"
    Case "4"
      GamePenalty = "One team victory only"
    Case Else
      GamePenalty = "No Rules"
  End Select
End Function

Private Function GameSpeed(ByVal strCase As String) As String
  Select Case strCase
    Case "0"
      GameSpeed = "Slowest"
    Case "1"
      GameSpeed = "Slower"
    Case "2"
      GameSpeed = "Slow"
    Case "3"
      GameSpeed = "Normal"
    Case "4"
      GameSpeed = "Fast"
    Case "5"
      GameSpeed = "Faster"
    Case "6"
      GameSpeed = "Fastest"
    Case Else
      GameSpeed = "Default"
  End Select
End Function

Private Function GameType(ByVal strCase As String) As String
  Select Case strCase
    Case "2"
      GameType = "Melee"
    Case "3"
      GameType = "Free For All"
    Case "4"
      GameType = "One on One"
    Case "5"
      GameType = "Capture the Flag"
    Case "6"
      GameType = "Greed"
    Case "7"
      GameType = "Slaughter"
    Case "8"
      GameType = "Sudden Death"
    Case "9"
      GameType = "Ladder"
    Case "A"
      GameType = "Use Map Settings"
    Case "B"
      GameType = "Team Melee"
    Case "C"
      GameType = "Team Free For All"
    Case "D"
      GameType = "Team Capture the Flag"
    Case "F"
      GameType = "Top vs Bottom"
    Case "10"
      GameType = "Iron Man Ladder"
    Case Else
      GameType = "Unknown (" & strCase & ")"
  End Select
End Function

Private Function GetCharacterName(ByVal StatString As String, ByVal start As Byte, ByRef cName As String) As Byte
  cName = Mid$(StatString, start, InStr(start, StatString, ",") - start)
  GetCharacterName = InStr(start, StatString, ",") + 1
End Function

Private Function GetServer(ByVal StatString As String, ByRef Server As String) As Byte
  Server = Mid$(StatString, 5, InStr(5, StatString, ",") - 5)
  GetServer = InStr(5, StatString, ",") + 1
End Function

Private Sub MakeArray(ByVal Text As String, ByRef nArray() As Byte)
Dim I As Long
  ReDim nArray(0) As Byte
  For I = 0 To Len(Text) - 1
    nArray(I) = CByte(Asc(Mid$(Text, I + 1, 1)))
    If I <> Len(Text) Then
      ReDim Preserve nArray(0 To UBound(nArray) + 1) As Byte
    End If
  Next I
End Sub

Private Function MapIcon(ByVal strCase As String) As String
  Select Case strCase
    Case "1"
      MapIcon = "Blizzard Approved"
    Case "2"
      MapIcon = "Ladder"
    Case "3"
      MapIcon = "GameFixx Tournament"
    Case "4"
      MapIcon = "KBK Tournament"
    Case Else
      MapIcon = "Unknown (" & strCase & ")"
  End Select
End Function

Private Function ParseD2Armor(ByVal Torso As Byte, ByVal Legs As Byte, ByVal RArm As Byte, ByVal LArm As Byte, ByVal RShoulder As Byte, ByVal LShoulder As Byte) As String
Dim sArmor As String
  sArmor = Torso & Legs & RArm & LArm & RShoulder & LShoulder
  Select Case sArmor
    Case "111111", "255255255255255255"
      ParseD2Armor = vbNullString
    Case "111122"
      ParseD2Armor = "Quilted Armor"
    Case "211122"
      ParseD2Armor = "Leather Armor"
    Case "212222"
      ParseD2Armor = "Hard Leather Armor"
    Case "122122"
      ParseD2Armor = "Studded Leather Armor"
    Case "221122"
      ParseD2Armor = "Ring Mail"
    Case "222222"
      ParseD2Armor = "Scale Mail"
    Case "311133"
      ParseD2Armor = "Breast Plate"
    Case "222233"
      ParseD2Armor = "Chain Mail"
    Case "322222"
      ParseD2Armor = "Splint Mail"
    Case "223133"
      ParseD2Armor = "Light Plate"
    Case "332233"
      ParseD2Armor = "Field Plate"
    Case "333322"
      ParseD2Armor = "Plate Mail"
    Case "233333"
      ParseD2Armor = "Gothic Plate"
    Case "333333"
      ParseD2Armor = "Full Plate Mail"
    Case "332331"
      ParseD2Armor = "Ancient Armor"
    Case Else
      ParseD2Armor = "Unknown Item (" & sArmor & ")"
  End Select
End Function

Private Function ParseD2Color(ByVal Color As Byte) As String
Dim sTint  As String
Dim sColor As String
  Color = Color Mod &HA0
  If Color And &H20 Then
    sTint = "Tinted"
    Color = Color Mod &H20
  ElseIf Color And &H40 Then
    sTint = "Lightly Tinted"
    Color = Color Mod &H20
  End If
  Select Case Color
    Case &H0, &HFF, &H1F
      sColor = vbNullString
    Case &H1
      sColor = "Gray"
    Case &H2
      sColor = "Bright Black"
    Case &H3
      sColor = "Dull Black"
    Case &H4
      sColor = "Black"
    Case &H5
      sColor = "Bright Blue"
    Case &H6
      sColor = "Dull Blue"
    Case &H7
      sColor = "Blue"
    Case &H8
      sColor = "Bright Red"
    Case &H9
      sColor = "Dull Red"
    Case &HA
      sColor = "Red"
    Case &HB
      sColor = "Bright Green"
    Case &HC
      sColor = "Dull Green"
    Case &HD
      sColor = "Green"
    Case &HE
      sColor = "Bright yellow"
    Case &HF
      sColor = "Dull Yellow"
    Case &H10
      sColor = "Yellow"
    Case &H11
      sColor = "Duller Yellow"
    Case &H12
      sColor = "Bright Purple"
    Case &H13
      sColor = "Purple"
    Case &H14
      sColor = "Gold"
    Case &H15
      sColor = "White"
    Case Else
      sColor = "Unknown Color: 0x" & BufferHex(Color, 2)
  End Select
  If LenB(sColor) > 0 Then
    If LenB(sTint) > 0 Then
      ParseD2Color = sTint & " " & sColor
    Else
      ParseD2Color = sColor
    End If
  Else
    ParseD2Color = vbNullString
  End If
End Function

Private Function ParseD2Equip(ByVal Item As Byte) As String
  Select Case Item
    Case &H0, &H1, &H2, &H3, &HFF
      ParseD2Equip = vbNullString
    Case &H4, &H39
      ParseD2Equip = "Cap"
    Case &H5, &H3A
      ParseD2Equip = "Skullcap"
    Case &H6, &H3B
      ParseD2Equip = "Helm"
    Case &H7, &H3C
      ParseD2Equip = "Full Helm"
    Case &H8, &H3D
      ParseD2Equip = "Great Helm"
    Case &H9, &H3E
      ParseD2Equip = "Crown"
    Case &HA, &H3F
      ParseD2Equip = "Mask"
    Case &H40, &H53
      ParseD2Equip = "Bone Helm"
    Case &H56
      ParseD2Equip = "Wolf Head"
    Case &H57
      ParseD2Equip = "Hawk Helm"
    Case &H58
      ParseD2Equip = "Antlers"
    Case &H59
      ParseD2Equip = "Jawbone Cap"
    Case &H5A
      ParseD2Equip = "Horned Helm"
    Case &H5B
      ParseD2Equip = "Assault Helmet"
    Case Else
      ParseD2Equip = "Unknown Equipment: 0x" & BufferHex(Item, 2)
  End Select
End Function

Private Function ParseD2Item(ByVal Item As Byte) As String
  Select Case Item
    Case &H0, &HFF
      ParseD2Item = vbNullString
    Case &H4
      ParseD2Item = "Hand Axe"
    Case &H5
      ParseD2Item = "Axe"
    Case &H6
      ParseD2Item = "Double Headed Axe"
    Case &H7
      ParseD2Item = "War Axe"
    Case &H8
      ParseD2Item = "Gaint Axe"
    Case &H9
      ParseD2Item = "Wand"
    Case &HA
      ParseD2Item = "Yew Wand"
    Case &HB
      ParseD2Item = "Grim Wand"
    Case &HC
      ParseD2Item = "Club"
    Case &HD
      ParseD2Item = "Mace"
    Case &HE
      ParseD2Item = "Warhammer"
    Case &HF
      ParseD2Item = "Flail"
    Case &H10
      ParseD2Item = "Maul"
    Case &H11
      ParseD2Item = "Short Sword"
    Case &H12
      ParseD2Item = "Scimitar"
    Case &H13
      ParseD2Item = "Falchion"
    Case &H14
      ParseD2Item = "Crystal Sword"
    Case &H15
      ParseD2Item = "Broadsword"
    Case &H16
      ParseD2Item = "Longsword"
    Case &H17
      ParseD2Item = "Claymore"
    Case &H18
      ParseD2Item = "Bastard Sword"
    Case &H19
      ParseD2Item = "Dagger"
    Case &H1A
      ParseD2Item = "Blade"
    Case &H1B
      ParseD2Item = "Short Spear"
    Case &H1C
      ParseD2Item = "Glaive"
    Case &H1D
      ParseD2Item = "Pilum"
    Case &H1E
      ParseD2Item = "Spear"
    Case &H1F
      ParseD2Item = "Trident"
    Case &H20
      ParseD2Item = "Spetum"
    Case &H21
      ParseD2Item = "Pike"
    Case &H22
      ParseD2Item = "Bardiche"
    Case &H23
      ParseD2Item = "Scythe"
    Case &H24
      ParseD2Item = "Halberd"
    Case &H25
      ParseD2Item = "Short Staff"
    Case &H26
      ParseD2Item = "Long Staff"
    Case &H27
      ParseD2Item = "Battle Staff"
    Case &H28
      ParseD2Item = "War Staff"
    Case &H29
      ParseD2Item = "Short Bow"
    Case &H2A
      ParseD2Item = "Long Bow"
    Case &H2B, &HF3, &HF4, &HFB
      ParseD2Item = "Claws"
    Case &H2C, &HF5, &HF6, &HFC
      ParseD2Item = "Scissors Katar"
    Case &H2D, &HF7, &HF8, &HFD
      ParseD2Item = "Katar"
    Case &H2E, &HF9, &HFA, &HFE
      ParseD2Item = "Hatchet Hands"
    Case &H2F
      ParseD2Item = "Hunter's Bow"
    Case &H30
      ParseD2Item = "Composite Bow"
    Case &H31, &H7A, &HF0
      ParseD2Item = "Crossbow"
    Case &H32, &H7C, &HF2
      ParseD2Item = "Heavy Crossbow"
    Case &H33
      ParseD2Item = "Eagle Orb"
    Case &H34
      ParseD2Item = "Sacred Globe"
    Case &H35
      ParseD2Item = "Clasped Orb"
    Case &H36
      ParseD2Item = "Stag Bow"
    Case &H37
      ParseD2Item = "Reflex Bow"
    Case &H4F
      ParseD2Item = "Small Shield"
    Case &H50
      ParseD2Item = "Large Shield"
    Case &H51
      ParseD2Item = "Kite Shield"
    Case &H52
      ParseD2Item = "Tower Shield"
    Case &H54
      ParseD2Item = "Bone Shield"
    Case &H55
      ParseD2Item = "Spiked Shield"
    Case &H5C
      ParseD2Item = "Targe"
    Case &H5D
      ParseD2Item = "Heraldic Shield"
    Case &H5E
      ParseD2Item = "Crown Shield"
    Case &H5F
      ParseD2Item = "Demon Head"
    Case &H60
      ParseD2Item = "Gargoyle Head"
    Case &H61
      ParseD2Item = "Zombie Head"
    Case &H75, &HEB
      ParseD2Item = "Short Battle Bow"
    Case &H76, &HEC
      ParseD2Item = "Long Battle Bow"
    Case &H77, &HED
      ParseD2Item = "Short War Bow"
    Case &H78, &HEE
      ParseD2Item = "Long War Bow"
    Case &HEF
      ParseD2Item = "Light Crossbow"
    Case &HF1
      ParseD2Item = "Repeating Crossbow"
    Case Else
      ParseD2Item = "Unknown Item: 0x" & BufferHex(Item, 2)
  End Select
End Function

Private Function ParseD2Items(P() As Byte) As String
Dim Helm    As String
Dim Armor   As String
Dim RWeapon As String
Dim LWeapon As String
Dim LShield As String
Dim LItem   As String
  Helm = ParseD2Equip(P(2))
  Armor = ParseD2Armor(P(3), P(4), P(5), P(6), P(10), P(11))
  RWeapon = ParseD2Item(P(7))
  LWeapon = ParseD2Item(P(8))
  LShield = ParseD2Item(P(9))
  LItem = ParseD2Item(P(12))
  If LenB(Helm) Then ParseD2Items = "a " & Trim$(ParseD2Color(P(14)) & " " & Helm)
  If LenB(Armor) Then ParseD2Items = ParseD2Items & ", a " & Trim$(ParseD2Color(P(15)) & " " & Armor)
  If LenB(RWeapon) Then ParseD2Items = ParseD2Items & ", a " & Trim$(ParseD2Color(P(19)) & " " & RWeapon)
  If LenB(LWeapon) Then ParseD2Items = ParseD2Items & ", and a " & Trim$(ParseD2Color(P(20)) & " " & LWeapon)
  If LenB(LShield) Then ParseD2Items = ParseD2Items & ", and a " & Trim$(ParseD2Color(P(21)) & " " & LShield)
  If LenB(LItem) Then ParseD2Items = ParseD2Items & ", and a " & LItem
  If LenB(ParseD2Items) Then
    Do While Left$(ParseD2Items, 2) = ", "
      ParseD2Items = Mid$(ParseD2Items, 3)
    Loop
  Else
    ParseD2Items = "Nothing"
  End If
End Function

Public Function ParseD2Stats(ByVal Stats As String)
Dim d2Classes(0 To 7) As String
Dim P()               As Byte
Dim Server            As String
Dim Name              As String
Dim sLen              As Byte
Dim CharClass         As Byte
Dim Female            As Boolean
Dim CharLevel         As Long
Dim Hardcore          As Boolean
Dim Dead              As Boolean
Dim Ladder            As Boolean
Dim Expansion         As Boolean
Dim D2Act             As String
Dim D2Title           As Integer
Dim D2sTitle          As String
Dim CharStats         As String
  If Len(Stats) = 4 Then
    CharStats = "Open Character"
  ElseIf Len(Stats) > 4 Then
    d2Classes(0) = "Amazon"
    d2Classes(1) = "Sorceress"
    d2Classes(2) = "Necromancer"
    d2Classes(3) = "Paladin"
    d2Classes(4) = "Barbarian"
    d2Classes(5) = "Druid"
    d2Classes(6) = "Assassin"
    d2Classes(7) = "Unknown Class"
    sLen = GetServer(Stats, Server)
    sLen = GetCharacterName(Stats, sLen, Name)
    MakeArray Mid$(Stats, sLen), P()
    If UBound(P) >= 30 Then
      CharClass = P(13) - 1
      If CharClass < 0 Or CharClass > 6 Then CharClass = 7
      Female = CharClass = 0 Or CharClass = 1 Or CharClass = 6
      CharLevel = P(25)
      Hardcore = P(26) And &H4
      Dead = P(26) And &H8
      If Not Hardcore Then Dead = False
      Expansion = P(26) And &H20
      Ladder = Not (P(30) = &HFF)
      If Left$(Stats, 4) = "PX2D" And (P(26) And &H20) Then
        Select Case P(27)
          Case &H80
            D2Act = "1 (Normal)"
            D2Title = 0
          Case &H82
            D2Act = "2 (Normal)"
            D2Title = 0
          Case &H84
            D2Act = "3 (Normal)"
            D2Title = 0
          Case &H86
            D2Act = "4/5 (Normal)"
            D2Title = 0
          Case &H88
            D2Act = "5 (Normal)"
            D2Title = 0
          Case &H8A
            D2Act = "1 (Nightmare)"
            D2Title = 1
          Case &H8C
            D2Act = "2 (Nightmare)"
            D2Title = 1
          Case &H8E
            D2Act = "3 (Nightmare)"
            D2Title = 1
          Case &H90
            D2Act = "4/5 (Nightmare)"
            D2Title = 1
          Case &H92
            D2Act = "5 (Nightmare)"
            D2Title = 1
          Case &H94
            D2Act = "1 (Hell)"
            D2Title = 2
          Case &H96
            D2Act = "2 (Hell)"
            D2Title = 2
          Case &H98
            D2Act = "3 (Hell)"
            D2Title = 2
          Case &H9A
            D2Act = "4/5 (Hell)"
            D2Title = 2
          Case &H9C
            D2Act = "5 (Hell)"
            D2Title = 2
          Case &H9E
            D2Act = vbNullString
            D2Title = 3
          Case Else
            D2Act = vbNullString
            D2Title = P(27)
        End Select
        If D2Title < 1 Then
          D2sTitle = vbNullString
        ElseIf D2Title < 4 Then
          If Hardcore Then
            Select Case D2Title
              Case 1
                D2sTitle = "Destroyer "
              Case 2
                D2sTitle = "Conquerer "
              Case 3
                D2sTitle = "Guardian "
              Case Else
                D2sTitle = "Unknown: 0x" & BufferHex(D2Title, 2) & " "
            End Select
          Else
            Select Case D2Title
              Case 1
                D2sTitle = "Slayer "
              Case 2
                D2sTitle = "Champion "
              Case 3
                If Female Then
                  D2sTitle = "Matriarch "
                Else
                  D2sTitle = "Patriarch "
                End If
              Case Else
                D2sTitle = "Unknown: 0x" & BufferHex(D2Title, 2) & " "
            End Select
          End If
        Else
          D2sTitle = "Unknown: 0x" & BufferHex(P(27), 2) & " "
        End If
      Else
        Select Case P(27)
          Case &H80
            D2Act = "1 (Normal)"
            D2Title = 0
          Case &H82
            D2Act = "2 (Normal)"
            D2Title = 0
          Case &H84
            D2Act = "3 (Normal)"
            D2Title = 0
          Case &H86
            D2Act = "4 (Normal)"
            D2Title = 0
          Case &H88
            D2Act = "1 (Nightmare)"
            D2Title = 1
          Case &H8A
            D2Act = "2 (Nightmare)"
            D2Title = 1
          Case &H8C
            D2Act = "3 (Nightmare)"
            D2Title = 1
          Case &H8E
            D2Act = "4 (Nightmare)"
            D2Title = 1
          Case &H90
            D2Act = "1 (Hell)"
            D2Title = 2
          Case &H92
            D2Act = "2 (Hell)"
            D2Title = 2
          Case &H94
            D2Act = "3 (Hell)"
            D2Title = 2
          Case &H96
            D2Act = "4 (Hell)"
            D2Title = 2
          Case &H98
            D2Act = vbNullString
            D2Title = 3
          Case Else
            D2Act = vbNullString
            D2Title = 0
        End Select
        If D2Title < 1 Then
          D2sTitle = vbNullString
        ElseIf D2Title < 4 Then
          If Female Then
            If Hardcore Then
              Select Case D2Title
                Case 1
                  D2sTitle = "Countess "
                Case 2
                  D2sTitle = "Duchess "
                Case 3
                  D2sTitle = "Queen "
                Case Else
                  D2sTitle = "Unknown: 0x" & BufferHex(D2Title, 2) & " "
              End Select
            Else
              Select Case D2Title
                Case 1
                  D2sTitle = "Count "
                Case 2
                  D2sTitle = "Duke "
                Case 3
                  D2sTitle = "King "
                Case Else
                  D2sTitle = "Unknown: 0x" & BufferHex(D2Title, 2) & " "
              End Select
            End If
          Else
            If Hardcore Then
              Select Case D2Title
                Case 1
                  D2sTitle = "Dame "
                Case 2
                  D2sTitle = "Lady "
                Case 3
                  D2sTitle = "Baroness "
                Case Else
                  D2sTitle = "Unknown: 0x" & BufferHex(D2Title, 2) & " "
              End Select
            Else
              Select Case D2Title
                Case 1
                  D2sTitle = "Duke "
                Case 2
                  D2sTitle = "Lord "
                Case 3
                  D2sTitle = "Baron "
                Case Else
                  D2sTitle = "Unknown: 0x" & BufferHex(D2Title, 2) & " "
              End Select
            End If
          End If
        Else
          D2sTitle = "Unknown: 0x" & BufferHex(P(27), 2) & " "
        End If
      End If
      CharStats = D2sTitle & Name & ", a " & _
                  IIf(Dead, "Dead ", vbNullString) & _
                  IIf(Hardcore, "Hardcore ", vbNullString) & _
                  "level " & CharLevel & " " & _
                  IIf(Expansion, "Expansion ", vbNullString) & _
                  IIf(Ladder, "Ladder ", vbNullString) & _
                  d2Classes(CharClass) & " " & _
                  IIf(LenB(D2Act) > 0, "in act " & D2Act & " ", vbNullString) & _
                  "on realm " & Server & ", wearing " & _
                  ParseD2Items(P())
    Else
      CharStats = Stats
    End If
  Else
    CharStats = Stats
  End If
  ParseD2Stats = IIf(Left$(Stats, 4) = "VD2D", "Diablo II", "Diablo II: Lord of Destruction") & ": " & CharStats
End Function

Public Function ParseMapStats(ByVal strStats As String) As String
Dim StatType As Byte
Dim StatStr() As String
  'type 0 = D1
  'type 1 = SC, W2
  'type 2 = W3
  If LenB(strStats) > 0 Then
    StatStr() = Split(strStats, vbCr)
    If UBound(StatStr) >= 2 Then
      StatType = 0
    Else
      Erase StatStr()
      If Mid$(strStats, 6, 4) = "0000" Then
        StatType = 2
      Else
        StatType = 1
      End If
    End If
    Select Case StatType
      Case 0
        ParseMapStats = "Creator: " & StatStr(1) & vbNewLine & "Difficulty: " & IIf(StatStr(0) = "0", "Normal", IIf(StatStr(0) = "1", "Nightmare", "Hell")) & vbNewLine & ParseStatString(StatStr(2))
      Case 1
        ParseMapStats = ParseGameMap(strStats)
      Case 2
        DecodeMapData Mid$(strStats, 2), strStats
        strStats = Mid$(strStats, 21)
        strStats = Left$(strStats, Len(strStats) - 2)
        ParseMapStats = "Creator: " & Mid$(strStats, InStrRev(strStats, vbNullChar) + 1) & vbNewLine & "Map: " & Left$(strStats, InStrRev(strStats, vbNullChar) - 1)
    End Select
  Else
    ParseMapStats = "No Game"
  End If
End Function

Private Function ParseGameMap(ByVal strStats As String) As String
Dim strMapSize   As String
Dim strGameType  As String
Dim strGameSpeed As String
Dim strPenalty   As String
Dim strIcon      As String
Dim strCreator   As String
Dim strMapName   As String
Dim varSplit()   As String
  varSplit = Split(strStats, ",")
    strMapSize = "Size: " & IIf(LenB(varSplit(1)), (Mid$(varSplit(1), 1, 1) * 32) & "x" & (Mid$(varSplit(1), 2, 1) * 32), "Default")
    strGameSpeed = "Speed: " & GameSpeed(varSplit(3))
    strIcon = "Icon: " & MapIcon(varSplit(4))
    strGameType = "Type: " & GameType(varSplit(5))
    strPenalty = "Rules: " & GamePenalty(varSplit(7))
    If UBound(varSplit) >= 11 Then
      If LenB(varSplit(11)) > 0 Then
        strCreator = "Creator: " & Left$(varSplit(11), InStr(1, varSplit(11), vbCr) - 1)
        strMapName = "Map: " & Mid$(varSplit(11), InStr(1, varSplit(11), vbCr) + 1)
      Else
        strCreator = "Creaator: Unknown"
        strMapName = "Map: Unknown"
      End If
    ElseIf UBound(varSplit) >= 10 Then
      If LenB(varSplit(10)) > 0 Then
        strCreator = "Creator: " & Left$(varSplit(10), InStr(1, varSplit(10), vbCr) - 1)
        strMapName = "Map: " & Mid$(varSplit(10), InStr(1, varSplit(10), vbCr) + 1)
      Else
        strCreator = "Creator: Unknown"
        strMapName = "Map: Unknown"
      End If
    ElseIf UBound(varSplit) >= 9 Then
      If LenB(varSplit(9)) > 0 Then
        strCreator = "Creator: " & Left$(varSplit(9), InStr(1, varSplit(9), vbCr) - 1)
        strMapName = "Map: " & Mid$(varSplit(9), InStr(1, varSplit(9), vbCr) + 1)
      Else
        strCreator = "Creator: Unknown"
        strMapName = "Map: Unknown"
      End If
    End If
    strMapName = Replace$(strMapName, vbCr, "")
    strMapName = Replace$(strMapName, vbLf, "")
    ParseGameMap = strCreator & vbNewLine & _
                    strMapName & vbNewLine & _
                    strMapSize & vbNewLine & _
                    strGameSpeed & vbNewLine & _
                    strIcon & vbNewLine & _
                    strGameType & vbNewLine & _
                    strPenalty
End Function

Public Function ParseStatString(ByVal StatString As String) As String
Dim Values()  As String
Dim cType     As String
Dim sStats    As String
Dim I         As Integer
  If LenB(StatString) = 0 Then Exit Function
  Select Case StrReverse$(Left$(StatString, 4))
    Case "DRTL"
      If Len(StatString) > 4 Then
        Values() = Split(Mid$(StatString, 6), " ")
        If UBound(Values) <> 8 Then
          ParseStatString = "an Illegal Diablo account: " & StatString
        Else
          Select Case Values(1)
            Case "0"
              cType = "Warrior"
            Case "1"
              cType = "Rogue"
            Case 2
              cType = "Sorcerer"
            Case Else
              cType = Values(1)
          End Select
          ParseStatString = "Diablo: Level " & Values(0) & " " & cType & " with " & _
                            Values(2) & IIf(Values(2) = "1", " dot, ", " dots,") & _
                            Values(3) & " strength, " & Values(4) & " magic, " & _
                            Values(5) & " dexterity, " & Values(6) & " vitality, and " & _
                            Values(3) & " gold"
        End If
      Else
        ParseStatString = "a Diablo Bot"
      End If
    Case "DSHR"
      If Len(StatString) > 4 Then
        Values() = Split(Mid$(StatString, 6), " ")
        If UBound(Values) <> 8 Then
          ParseStatString = "an Illegal Diablo Shareware account: " & StatString
        Else
          Select Case Values(1)
            Case "0"
              cType = "Warrior"
            Case "1"
              cType = "Rogue"
            Case 2
              cType = "Sorcerer"
            Case Else
              cType = Values(1)
          End Select
          ParseStatString = "Diablo: Level " & Values(0) & " " & cType & " with " & _
                            Values(2) & IIf(Values(2) = "1", " dot, ", " dots,") & _
                            Values(3) & " strength, " & Values(4) & " magic, " & _
                            Values(5) & " dexterity, " & Values(6) & " vitality, and " & _
                            Values(3) & " gold"
        End If
      Else
        ParseStatString = "a Diablo Shareware bot"
      End If
    Case "D2DV"
      ParseStatString = ParseD2Stats(StatString)
    Case "D2XP"
      ParseStatString = ParseD2Stats(StatString)
    Case "STAR"
      If Len(StatString) > 4 Then
        Values() = Split(Mid$(StatString, 6), " ")
        If UBound(Values) <> 8 Then
          ParseStatString = "an illegal Starcraft account " & StatString
        Else
          sStats = Values(2) & " normal game " & IIf(Values(2) = 1, "win", "wins")
          If Values(0) > 0 Then sStats = sStats & ", with a rating of " & Values(0)
          If Values(1) > 0 Then sStats = sStats & " and a rank of " & Values(1) & " on the ladder"
          ParseStatString = "Starcraft" & IIf(Values(3) = 1, " (spawn)", vbNullString) & ": " & sStats
        End If
      Else
        ParseStatString = "a Starcraft bot"
      End If
    Case "SSHR"
      ParseStatString = "Starcraft Shareware"
    Case "JSTR"
      If Len(StatString) > 4 Then
        Values() = Split(Mid$(StatString, 6), " ")
        If UBound(Values) <> 8 Then
          ParseStatString = "an illegal Japanese Starcraft account " & StatString
        Else
          sStats = Values(2) & " normal game " & IIf(Values(2) = 1, "win", "wins")
          If Values(0) > 0 Then sStats = sStats & ", with a rating of " & Values(0)
          If Values(1) > 0 Then sStats = sStats & " and a rank of " & Values(1) & " on the ladder"
          ParseStatString = "Japanese Starcraft" & IIf(Values(3) = 1, " (spawn)", vbNullString) & ": " & sStats
        End If
      Else
        ParseStatString = "a Japanese Starcraft bot"
      End If
    Case "SEXP"
      If Len(StatString) > 4 Then
        Values() = Split(Mid$(StatString, 6), " ")
        If UBound(Values) <> 8 Then
          ParseStatString = "an illegal Starcraft Brood War account " & StatString
        Else
          sStats = Values(2) & " normal game " & IIf(Values(2) = 1, "win", "wins")
          If Values(0) > 0 Then sStats = sStats & ", with a rating of " & Values(0)
          If Values(1) > 0 Then sStats = sStats & " and a rank of " & Values(1) & " on the ladder"
          ParseStatString = "Starcraft Brood War" & IIf(Values(3) = 1, " (spawn)", vbNullString) & ": " & sStats
        End If
      Else
        ParseStatString = "a Starcraft Brood War bot"
      End If
    Case "W2BN"
      If Len(StatString) > 4 Then
        Values() = Split(Mid$(StatString, 6), " ")
        If UBound(Values) <> 8 Then
          ParseStatString = "an illegal Warcraft II account " & StatString
        Else
          sStats = Values(2) & " normal game " & IIf(Values(2) = 1, "win", "wins")
          If Values(0) > 0 Then sStats = sStats & ", with a rating of " & Values(0)
          If Values(1) > 0 Then sStats = sStats & " and a rank of " & Values(1) & " on the ladder"
          If Values(6) > 0 Then sStats = sStats & ", a rating of " & Values(6)
          If Values(7) > 0 Then sStats = sStats & " and a rank of " & Values(7) & " on the IronMan ladder"
          ParseStatString = "Warcraft II" & IIf(Values(3) = 1, " (spawn)", vbNullString) & ": " & sStats
        End If
      Else
        ParseStatString = "a Warcraft II bot"
      End If
    Case "WAR3"
      If Len(StatString) > 4 Then
        If Len(StatString) > 10 Then
          StatString = StatString & " "
          Values() = Split(Mid$(StatString, 5), " ")
          For I = LBound(Values) To UBound(Values)
            Values(I) = StrReverse$(Values(I))
          Next I
          Select Case Values(1)
            Case "W3H1"
              cType = "Human Peon"
            Case "W3H2"
              cType = "Human Footman (25 wins)"
            Case "W3H3"
              cType = "Human Knight (250 wins)"
            Case "W3H4"
              cType = "Human Archmage (500 wins)"
            Case "W3H5"
              cType = "Human Medivh (1500 wins)"
            Case "W3O1"
              cType = "Orc Peon"
            Case "W3O2"
              cType = "Orc Grunt (25 wins)"
            Case "W3O3"
              cType = "Orc Tauren (250 wins)"
            Case "W3O4"
              cType = "Orc Far Seer (500 wins)"
            Case "W3O5"
              cType = "Orc Thrall (1500 wins)"
            Case "W3N1"
              cType = "Night Elf Peon"
            Case "W3N2"
              cType = "Night Elf Archer (25 wins)"
            Case "W3N3"
              cType = "Night Elf Druid of the Claw (250 wins)"
            Case "W3N4"
              cType = "Night Elf Priestess of the Moon (500 wins)"
            Case "W3N5"
              cType = "Night Elf Furion Stormrage (1500 wins)"
            Case "W3U1"
              cType = "Undead Peon"
            Case "W3U2"
              cType = "Undead Ghoul (25 wins)"
            Case "W3U3"
              cType = "Undead Abomination (250 wins)"
            Case "W3U4"
              cType = "Undead Lich (500 wins)"
            Case "W3U5"
              cType = "Undead Tichondrius (1500 wins)"
            Case "W3R1"
              cType = "Random Peon"
            Case "W3R2"
              cType = "Random Green Dragon Whelp (25 wins)"
            Case "W3R3"
              cType = "Random Blue Dragon (250 wins)"
            Case "W3R4"
              cType = "Random Red Dragon (500 wins)"
            Case "W3R5"
              cType = "Random Deathwing (1500 wins)"
            Case Else
              cType = "Unknown [" & Values(1) & "]"
          End Select
          ParseStatString = "Warcraft III: Level " & StrReverse$(Values(2)) & _
                            ", with " & cType & " as icon" & _
                            IIf(LenB(Values(3)) > 0, ", and in clan " & Values(3), vbNullString)
        Else
          ParseStatString = "an illegal Warcraft III account " & StatString
        End If
      Else
        ParseStatString = "a Warcraft III bot"
      End If
    Case "W3XP"
      If Len(StatString) > 4 Then
        If Len(StatString) > 10 Then
          StatString = StatString & " "
          Values() = Split(Mid$(StatString, 5), " ")
          For I = LBound(Values) To UBound(Values)
            Values(I) = StrReverse$(Values(I))
          Next I
          Select Case Values(1)
            Case "W3H1"
              cType = "Human Peon"
            Case "W3H2"
              cType = "Human Rifleman (25 wins)"
            Case "W3H3"
              cType = "Human Sorceress (150 wins)"
            Case "W3H4"
              cType = "Human Spellbreaker (350 wins)"
            Case "W3H5"
              cType = "Human Blood Mage (750 wins)"
            Case "W3H6"
              cType = "Human Jaina (1500 wins)"
            Case "W3O1"
              cType = "Orc Peon"
            Case "W3O2"
              cType = "Orc Troll Headhunter (25 wins)"
            Case "W3O3"
              cType = "Orc Shaman (150 wins)"
            Case "W3O4"
              cType = "Orc Spirit Walker (350 wins)"
            Case "W3O5"
              cType = "Orc Shadow Hunter (750 wins)"
            Case "W3O6"
              cType = "Orc Rexxar (1500 wins)"
            Case "W3N1"
              cType = "Night Elf Peon"
            Case "W3N2"
              cType = "Night Elf Huntress (25 wins)"
            Case "W3N3"
              cType = "Night Elf Druid of the Talon (150 wins)"
            Case "W3N4"
              cType = "Night Elf Dryad (350 wins)"
            Case "W3N5"
              cType = "Night Elf Keeper of the Grove (750 wins)"
            Case "W3N6"
              cType = "Night Elf Maiev (1500 wins)"
            Case "W3U1"
              cType = "Undead Peon"
            Case "W3U2"
              cType = "Undead Crypt Fiend (25 wins)"
            Case "W3U3"
              cType = "Undead Banshee (150 wins)"
            Case "W3U4"
              cType = "Undead Destroyer (350 wins)"
            Case "W3U5"
              cType = "Undead Crypt Lord (750 wins)"
            Case "W3U6"
              cType = "Undead Sylvanas (1500 wins)"
            Case "W3R1"
              cType = "Random Peon"
            Case "W3R2"
              cType = "Random Myrmidon (25 wins)"
            Case "W3R3"
              cType = "Random Siren (150 wins)"
            Case "W3R4"
              cType = "Random Dragon Turtle (350 wins)"
            Case "W3R5"
              cType = "Random Sea Witch (750 wins)"
            Case "W3R6"
              cType = "Random Illidan (1500 wins)"
            Case "W3D1"
              cType = "Tournament Peon"
            Case "W3D2"
              cType = "Tournament Felguard (10 wins)"
            Case "W3D3"
              cType = "Tournament Infernal (75 wins)"
            Case "W3D4"
              cType = "Tournament Doomguard (150 wins)"
            Case "W3D5"
              cType = "Tournament Pit Lord (250 wins)"
            Case "W3D6"
              cType = "Tournament Archimonde (500 wins)"
            Case "WCGP"
              cType = "WCG Player"
            Case "WCGS"
              cType = "WCG Staff"
            Case Else
              cType = "Unknown [" & Values(1) & "]"
          End Select
          
          
          ParseStatString = "Warcraft III: The Frozen Throne: Level " & StrReverse$(Values(2)) & _
                            ", with " & cType & " as icon" & _
                            IIf(LenB(Values(3)) > 0, ", and in clan " & Values(3), vbNullString)
        Else
          ParseStatString = "an illegal Warcraft III: The Frozen Throne account " & StatString
        End If
      Else
        ParseStatString = "a Warcraft III: The Frozen Throne bot"
      End If
    Case "CHAT"
      If Len(StatString) > 4 Then
        ParseStatString = "an illegal Chat account: " & StatString
      Else
        ParseStatString = "a Chat bot"
      End If
    Case Else
      ParseStatString = "an unknown " & StrReverse$(Left$(StatString, 4)) & " client: " & StatString
  End Select
  For I = 0 To 31
    ParseStatString = Replace$(ParseStatString, Chr$(I), vbNullString)
  Next I
End Function

Private Function RShift(ByVal lNum As Long, ByVal lShift As Long) As Long
  RShift = lNum \ 2 ^ lShift
End Function
