Attribute VB_Name = "modFunctions"
Option Explicit
Public Declare Sub RtlMoveMemory Lib "kernel32" (Destination As Any, Source As Any, ByVal Length As Long)
Public Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private Declare Function GetTickCount Lib "kernel32" () As Long
Private Declare Function QueryPerformanceCounter Lib "kernel32" (lpPerformanceCount As Currency) As Long
Private Declare Function QueryPerformanceFrequency Lib "kernel32" (lpFrequency As Currency) As Long
Public Declare Function VBPcapInit Lib "VBPCAP.DLL" () As Long
Public Declare Function VBPcapTerminate Lib "VBPCAP.DLL" () As Long
Public Declare Function vpBegin Lib "VBPCAP.DLL" (ByVal timeout As Long) As Long
Public Declare Function vpEnd Lib "VBPCAP.DLL" () As Long
Public Declare Function vpGetAdapterInfo Lib "VBPCAP.DLL" (ByVal ID As Integer, ad As AdINFO) As Long
Public Declare Function vpSetCurrentAdapter Lib "VBPCAP.DLL" (ByVal ID As Integer) As Long
Public Declare Function vpGetCurrentAdapter Lib "VBPCAP.DLL" () As Long
Public Declare Function vpGetErrorDescription Lib "VBPCAP.DLL" () As String
Public Declare Function SetCaptureParams Lib "VBPCAP.DLL" (ByVal ID As Long, data As Variant) As Long
Public Declare Function vpCapture Lib "VBPCAP.DLL" (ByRef buffer() As Byte, hed As PacketHeader) As Long
Public Declare Function vpSetParam Lib "VBPCAP.DLL" (ByVal param As VBPCAPPARAMS, Value As Variant) As Long

Public Enum VBPCAPPARAMS
  PRM_SNAPLEN = 0
  PRM_MODE = 1
  PRM_FILENAME = 2
  PRM_KERNELBUFFSIZE = 6
  PRM_DUMPTYPE = 8
  PRM_SETFILTER = 9
  PRM_OPENMODE = 10
End Enum

Type AdINFO
  Name        As String * 255
  Description As String * 255
  Loopback    As Long
End Type

Type PacketHeader
  caplen  As Long
  len     As Long
  h       As Long
  m       As Long
  s       As Long
  us      As Long
End Type

Public Enum TCPFLAGS
  CWR = &H80
  ECE = &H40
  URG = &H20
  ACK = &H10
  PSH = &H8
  RST = &H4
  SYN = &H2
  FIN = &H1
End Enum

Public SIDCount  As Long
Public MCPCount  As Long
Public BNLSCount As Long
Public UDPCount  As Long
Public W3GSCount As Long
Public D2GSCount As Long
Public BNCount   As Long

Public Function ErrorHandler(ByVal sObject As String, ByVal sRoutine As String)
Dim lErrNo As Long
Dim sErrDs As String
Dim sErrSr As String
Dim lErrLn As Long
  lErrLn = Erl
  lErrNo = Err.Number
  sErrDs = Err.Description
  sErrSr = Err.Source
  Select Case MsgBox("Error #" & lErrNo & " in " & sObject & vbNewLine & sErrDs & " in " & sRoutine & " (" & lErrLn & ")", vbExclamation + vbAbortRetryIgnore, "BNalyzer Error")
    Case vbAbort
      End
    Case vbRetry
      ErrorHandler = True
    Case vbIgnore
      ErrorHandler = False
  End Select
End Function

Public Function StH(ByVal StrToHex As String, Optional ByVal Spacer As Boolean = False) As String
Dim strTemp   As String
Dim strReturn As String
Dim I         As Long
  On Error GoTo Erred
  For I = 1 To Len(StrToHex)
    strTemp = Hex$(Asc(Mid$(StrToHex, I, 1)))
    If Len(strTemp) = 1 Then strTemp = "0" & strTemp
    strReturn = strReturn & strTemp & IIf(Spacer, " ", vbNullString)
  Next I
  If Len(strReturn) > 0 And Spacer Then
    StH = Left$(strReturn, Len(strReturn) - 1)
  Else
    StH = strReturn
  End If
Exit Function
Erred:
  If ErrorHandler("modFunctions", "Function StH") Then Resume Next
End Function

Public Function HtS(ByVal HexToStr As String) As String
Dim strTemp   As String
Dim strReturn As String
Dim I         As Long
  On Error GoTo Erred
  For I = 1 To Len(HexToStr) Step 2
    strTemp = Chr$(Val("&H" & Mid$(HexToStr, I, 2)))
    strReturn = strReturn & strTemp
  Next I
  HtS = strReturn
Exit Function
Erred:
  If ErrorHandler("modFunctions", "Function HtS") Then Resume Next
End Function

Public Function TrimNull(ByVal sText As String) As String
  On Error GoTo Erred
  If InStr(sText, vbNullChar) > 0 Then
    TrimNull = Split(sText, vbNullChar)(0)
  Else
    TrimNull = sText
  End If
Exit Function
Erred:
  If ErrorHandler("modFunctions", "Function TrimNull") Then Resume Next
End Function

Public Function CheckPorts(ByVal InPort As Long, ByVal OutPort As Long, ByVal Protocol As String) As Boolean
Dim lPort As Long
  On Error GoTo Erred
  Select Case Protocol
    Case "SID"
      lPort = GetSetting(App.CompanyName, App.ProductName, "Port", 6112)
    Case "MCP"
      lPort = GetSetting(App.CompanyName, App.ProductName, "MCPPort", 6112)
    Case "BNLS"
      lPort = GetSetting(App.CompanyName, App.ProductName, "BNLSPort", 9367)
    Case "UDP"
      lPort = GetSetting(App.CompanyName, App.ProductName, "UDPPort", 6112)
    Case "D2GS"
      lPort = GetSetting(App.CompanyName, App.ProductName, "D2GSPort", 6112)
    Case "W3GS"
      lPort = GetSetting(App.CompanyName, App.ProductName, "W3GSPort", 6112)
    Case "BN"
      lPort = GetSetting(App.CompanyName, App.ProductName, "BNPort", 21844)
    Case Else
      CheckPorts = False
      Exit Function
  End Select
  CheckPorts = (lPort = InPort) Or (lPort = OutPort)
Exit Function
Erred:
  If ErrorHandler("modFunctions", "Function CheckPorts") Then Resume Next
End Function

Public Function ConvertTime(ByVal dMS As Double) As String
Dim dSeconds As Double
Dim dDays    As Double
Dim dHours   As Double
Dim dMins    As Double
Dim sSeconds As String
Dim sDays    As String
Dim sHours   As String
Dim sMins    As String
  dSeconds = BigDiv(dMS, 1000)
  dDays = BigDiv(dSeconds, 86400)
  dSeconds = BigMod(dSeconds, 86400)
  dHours = BigDiv(dSeconds, 3600)
  dSeconds = BigMod(dSeconds, 3600)
  dMins = BigDiv(dSeconds, 60)
  dSeconds = BigMod(dSeconds, 60)
  sDays = "d"
  sHours = "h"
  sMins = "m"
  sSeconds = "s"
  If dDays > 0 Then ConvertTime = dDays & sDays
  If dHours > 0 Then
    If LenB(ConvertTime) > 0 Then
      ConvertTime = ConvertTime & " " & dHours & sHours
    Else
      ConvertTime = dHours & sHours
    End If
  End If
  If dMins > 0 Then
    If LenB(ConvertTime) > 0 Then
      ConvertTime = ConvertTime & " " & dMins & sMins
    Else
      ConvertTime = dMins & sMins
    End If
  End If
  If dSeconds > 0 Then
    If LenB(ConvertTime) > 0 Then
      ConvertTime = ConvertTime & " " & dSeconds & sSeconds
    Else
      ConvertTime = dSeconds & sSeconds
    End If
  End If
End Function

Private Function BigDiv(ByVal dblNumber As Double, ByVal Divisor As Double) As Double
  BigDiv = Fix(dblNumber / Divisor)
End Function

Private Function BigMod(ByVal dblNumber As Double, ByVal Modulator As Double) As Double
  BigMod = dblNumber - (Modulator * Fix(dblNumber / Modulator))
End Function

Public Function GetTickDouble() As Double
Dim Cou As Currency
Dim Fre As Currency
  On Error GoTo Erred
  If QueryPerformanceCounter(Cou) And QueryPerformanceFrequency(Fre) Then
    GetTickDouble = Int(Cou / Fre * 1000)
  Else
    GetTickDouble = LongToUnsigned(GetTickCount)
  End If
Exit Function
Erred:
  GetTickDouble = 0
End Function

Public Function LongToUnsigned(Value As Long) As Double
  If Value < 0 Then
    LongToUnsigned = Value + 4294967296#
  Else
    LongToUnsigned = Value
  End If
End Function
