Attribute VB_Name = "modBNCSParser"
Option Explicit
Private Type FILETIME
  dwLowDateTime   As Long
  dwHighDateTime  As Long
End Type
Private Type SYSTEMTIME
  wYear           As Integer
  wMonth          As Integer
  wDayOfWeek      As Integer
  wDay            As Integer
  wHour           As Integer
  wMinute         As Integer
  wSecond         As Integer
  wMilliseconds   As Integer
End Type

Private Declare Function FileTimeToLocalFileTime Lib "kernel32" (lpFileTime As FILETIME, lpLocalFileTime As FILETIME) As Long
Private Declare Function FileTimeToSystemTime Lib "kernel32" (lpFileTime As FILETIME, lpSystemTime As SYSTEMTIME) As Long
Private Declare Function uncompress Lib "zlib.dll" (ByRef dest As Any, ByRef destLen As Long, ByRef src As Any, ByRef srcLen As Long) As Long

Private Const SID_NULL                         As Byte = &H0
Private Const SID_STOPADV                      As Byte = &H2
Private Const SID_SERVERLIST                   As Byte = &H4
Private Const SID_CLIENTID                     As Byte = &H5
Private Const SID_STARTVERSIONING              As Byte = &H6
Private Const SID_REPORTVERSION                As Byte = &H7
Private Const SID_STARTADVEX                   As Byte = &H8
Private Const SID_GETADVLISTEX                 As Byte = &H9
Private Const SID_ENTERCHAT                    As Byte = &HA
Private Const SID_GETCHANNELLIST               As Byte = &HB
Private Const SID_JOINCHANNEL                  As Byte = &HC
Private Const SID_CHATCOMMAND                  As Byte = &HE
Private Const SID_CHATEVENT                    As Byte = &HF
Private Const SID_LEAVECHAT                    As Byte = &H10
Private Const SID_LOCALEINFO                   As Byte = &H12
Private Const SID_FLOODDETECTED                As Byte = &H13
Private Const SID_UDPPINGRESPONSE              As Byte = &H14
Private Const SID_CHECKAD                      As Byte = &H15
Private Const SID_CLICKAD                      As Byte = &H16
Private Const SID_REGISTRY                     As Byte = &H18
Private Const SID_MESSAGEBOX                   As Byte = &H19
Private Const SID_STARTADVEX2                  As Byte = &H1A
Private Const SID_GAMEDATAADDRESS              As Byte = &H1B
Private Const SID_STARTADVEX3                  As Byte = &H1C
Private Const SID_LOGONCHALLENGEEX             As Byte = &H1D
Private Const SID_CLIENTID2                    As Byte = &H1E
Private Const SID_LEAVEGAME                    As Byte = &H1F
Private Const SID_DISPLAYAD                    As Byte = &H21
Private Const SID_NOTIFYJOIN                   As Byte = &H22
Private Const SID_PING                         As Byte = &H25
Private Const SID_READUSERDATA                 As Byte = &H26
Private Const SID_WRITEUSERDATA                As Byte = &H27
Private Const SID_LOGONCHALLENGE               As Byte = &H28
Private Const SID_LOGONRESPONSE                As Byte = &H29
Private Const SID_CREATEACCOUNT                As Byte = &H2A
Private Const SID_SYSTEMINFO                   As Byte = &H2B
Private Const SID_GAMERESULT                   As Byte = &H2C
Private Const SID_GETICONDATA                  As Byte = &H2D
Private Const SID_GETLADDERDATA                As Byte = &H2E
Private Const SID_FINDLADDERUSER               As Byte = &H2F
Private Const SID_CDKEY                        As Byte = &H30
Private Const SID_CHANGEPASSWORD               As Byte = &H31
Private Const SID_CHECKDATAFILE                As Byte = &H32
Private Const SID_GETFILETIME                  As Byte = &H33
Private Const SID_QUERYREALMS                  As Byte = &H34
Private Const SID_PROFILE                      As Byte = &H35
Private Const SID_CDKEY2                       As Byte = &H36
Private Const SID_LOGONRESPONSE2               As Byte = &H3A
Private Const SID_CHECKDATAFILE2               As Byte = &H3C
Private Const SID_CREATEACCOUNT2               As Byte = &H3D
Private Const SID_LOGONREALMEX                 As Byte = &H3E
Private Const SID_STARTVERSIONING2             As Byte = &H3F
Private Const SID_QUERYREALMS2                 As Byte = &H40
Private Const SID_QUERYADURL                   As Byte = &H41
Private Const SID_WARCRAFTGENERAL              As Byte = &H44
Private Const SID_NETGAMEPORT                  As Byte = &H45
Private Const SID_NEWS_INFO                    As Byte = &H46
Private Const SID_OPTIONALWORK                 As Byte = &H4A
Private Const SID_EXTRAWORK                    As Byte = &H4B
Private Const SID_REQUIREDWORK                 As Byte = &H4C
Private Const SID_TOURNAMENT                   As Byte = &H4E
Private Const SID_AUTH_INFO                    As Byte = &H50
Private Const SID_AUTH_CHECK                   As Byte = &H51
Private Const SID_AUTH_ACCOUNTCREATE           As Byte = &H52
Private Const SID_AUTH_ACCOUNTLOGON            As Byte = &H53
Private Const SID_AUTH_ACCOUNTLOGONPROOF       As Byte = &H54
Private Const SID_AUTH_ACCOUNTCHANGE           As Byte = &H55
Private Const SID_AUTH_ACCOUNTCHANGEPROOF      As Byte = &H56
Private Const SID_AUTH_ACCOUNTUPGRADE          As Byte = &H57
Private Const SID_AUTH_ACCOUNTUPGRADEPROOF     As Byte = &H58
Private Const SID_SETEMAIL                     As Byte = &H59
Private Const SID_RESETPASSWORD                As Byte = &H5A
Private Const SID_CHANGEEMAIL                  As Byte = &H5B
Private Const SID_SWITCHPRODUCT                As Byte = &H5C
Private Const SID_WARDEN                       As Byte = &H5E
Private Const SID_GAMEPLAYERSEARCH             As Byte = &H60
Private Const SID_FRIENDSLIST                  As Byte = &H65
Private Const SID_FRIENDSUPDATE                As Byte = &H66
Private Const SID_FRIENDSADD                   As Byte = &H67
Private Const SID_FRIENDSREMOVE                As Byte = &H68
Private Const SID_FRIENDSPOSITION              As Byte = &H69
Private Const SID_CLANFINDCANDIDATES           As Byte = &H70
Private Const SID_CLANINVITEMULTIPLE           As Byte = &H71
Private Const SID_CLANCREATIONINVITATION       As Byte = &H72
Private Const SID_CLANDISBAND                  As Byte = &H73
Private Const SID_CLANMAKECHIEFTAIN            As Byte = &H74
Private Const SID_CLANINFO                     As Byte = &H75
Private Const SID_CLANQUITNOTIFY               As Byte = &H76
Private Const SID_CLANINVITATION               As Byte = &H77
Private Const SID_CLANREMOVEMEMBER             As Byte = &H78
Private Const SID_CLANINVITATIONRESPONSE       As Byte = &H79
Private Const SID_CLANRANKCHANGE               As Byte = &H7A
Private Const SID_CLANSETMOTD                  As Byte = &H7B
Private Const SID_CLANMOTD                     As Byte = &H7C
Private Const SID_CLANMEMBERLIST               As Byte = &H7D
Private Const SID_CLANMEMBERREMOVED            As Byte = &H7E
Private Const SID_CLANMEMBERSTATUSCHANGE       As Byte = &H7F
Private Const SID_CLANMEMBERRANKCHANGE         As Byte = &H81
Private Const SID_CLANMEMBERINFORMATION        As Byte = &H82

Private Const MCP_STARTUP                      As Byte = &H1
Private Const MCP_CHARCREATE                   As Byte = &H2
Private Const MCP_CREATEGAME                   As Byte = &H3
Private Const MCP_JOINGAME                     As Byte = &H4
Private Const MCP_GAMELIST                     As Byte = &H5
Private Const MCP_GAMEINFO                     As Byte = &H6
Private Const MCP_CHARLOGON                    As Byte = &H7
Private Const MCP_CHARDELETE                   As Byte = &HA
Private Const MCP_REQUESTLADDERDATA            As Byte = &H11
Private Const MCP_MOTD                         As Byte = &H12
Private Const MCP_CANCELGAMECREATE             As Byte = &H13
Private Const MCP_CREATEQUEUE                  As Byte = &H14
Private Const MCP_CHARLIST                     As Byte = &H17
Private Const MCP_CHARUPGRADE                  As Byte = &H18
Private Const MCP_CHARLIST2                    As Byte = &H19

Private Const BNLS_NULL                        As Byte = &H0
Private Const BNLS_CDKEY                       As Byte = &H1
Private Const BNLS_LOGONCHALLENGE              As Byte = &H2
Private Const BNLS_LOGONPROOF                  As Byte = &H3
Private Const BNLS_CREATEACCOUNT               As Byte = &H4
Private Const BNLS_CHANGECHALLENGE             As Byte = &H5
Private Const BNLS_CHANGEPROOF                 As Byte = &H6
Private Const BNLS_UPGRADECHALLENGE            As Byte = &H7
Private Const BNLS_UPGRADEPROOF                As Byte = &H8
Private Const BNLS_VERSIONCHECK                As Byte = &H9
Private Const BNLS_CONFIRMLOGON                As Byte = &HA
Private Const BNLS_HASHDATA                    As Byte = &HB
Private Const BNLS_CDKEY_EX                    As Byte = &HC
Private Const BNLS_CHOOSENLSREVISION           As Byte = &HD
Private Const BNLS_AUTHORIZE                   As Byte = &HE
Private Const BNLS_AUTHORIZEPROOF              As Byte = &HF
Private Const BNLS_REQUESTVERSIONBYTE          As Byte = &H10
Private Const BNLS_VERIFYSERVER                As Byte = &H11
Private Const BNLS_RESERVESERVERSLOTS          As Byte = &H12
Private Const BNLS_SERVERLOGONCHALLENGE        As Byte = &H13
Private Const BNLS_SERVERLOGONPROOF            As Byte = &H14
Private Const BNLS_RESERVED0                   As Byte = &H15
Private Const BNLS_RESERVED1                   As Byte = &H16
Private Const BNLS_RESERVED2                   As Byte = &H17
Private Const BNLS_VERSIONCHECKEX              As Byte = &H18
Private Const BNLS_RESERVED3                   As Byte = &H19
Private Const BNLS_VERSIONCHECKEX2             As Byte = &H1A

Public strBuffer      As String
Private SIDPacket     As New clsPacket
Private MCPPacket     As New clsPacket
Private BNLSPacket    As New clsPacket
Private UDPPacket     As New clsPacket
Private D2GSPacket    As New clsPacket
Private W3GSPacket    As New clsPacket
Private BNPacket      As New clsPacket
Private nList         As Nodes
Private nRoot         As Node
Private SIDIPs        As New clsIPList
Private MCPIPs        As New clsIPList
Private BNLSIPs       As New clsIPList
Private D2GSIPs       As New clsIPList
Private W3GSIPs       As New clsIPList
Private BNIPs         As New clsIPList

Public Function BufferHex(ByVal iVal As Long, Optional ByVal Places As Long = 8)
Dim sVal As String
  On Error GoTo Erred
  sVal = Hex$(iVal)
  If Places > Len(sVal) Then
    BufferHex = String$(Places - Len(sVal), "0") & sVal
  Else
    BufferHex = sVal
  End If
Exit Function
Erred:
  If ErrorHandler("modBNCSParser", "Function BufferHex") Then Resume Next
End Function

Private Function Decompress(ByVal sCompressed As String, ByVal lCompLen As Long, ByVal lUncompLen As Long) As String
Dim bIn()   As Byte
Dim bOut()  As Byte
Dim sOut    As String
  ReDim bIn(lCompLen - 1)
  RtlMoveMemory bIn(0), ByVal sCompressed, lCompLen
  ReDim bOut(lUncompLen - 1)
  If uncompress(bOut(0), lUncompLen, bIn(0), lCompLen) = 0 Then
    sOut = String$(lUncompLen, 0)
    RtlMoveMemory ByVal sOut, bOut(0), lUncompLen
    Decompress = sOut
  Else
    Decompress = "Failed to decompress"
  End If
End Function

Private Function GetBNLSProduct(ByVal lID As Long)
  Select Case lID
    Case 1
      GetBNLSProduct = "STAR"
    Case 2
      GetBNLSProduct = "SEXP"
    Case 3
      GetBNLSProduct = "W2BN"
    Case 4
      GetBNLSProduct = "D2DV"
    Case 5
      GetBNLSProduct = "D2XP"
    Case 6
      GetBNLSProduct = "JSTR"
    Case 7
      GetBNLSProduct = "WAR3"
    Case 8
      GetBNLSProduct = "W3XP"
    Case 9
      GetBNLSProduct = "DRTL"
    Case &HA
      GetBNLSProduct = "DSHR"
    Case &HB
      GetBNLSProduct = "SSHR"
    Case Else
      GetBNLSProduct = "Unknown"
  End Select
End Function

Private Function GetFTTime(ByVal ftLow As Long, ByVal ftHigh As Long) As String
Dim FT      As FILETIME
Dim LocalFT As FILETIME
Dim SysTime As SYSTEMTIME
  On Error GoTo Erred
  FT.dwLowDateTime = ftLow
  FT.dwHighDateTime = ftHigh
  FileTimeToLocalFileTime FT, LocalFT
  FileTimeToSystemTime LocalFT, SysTime
  GetFTTime = SysTime.wMonth & "/" & Format$(SysTime.wDay, "00") & "/" & SysTime.wYear & " " & SysTime.wHour & ":" & Format$(SysTime.wMinute, "00")
Exit Function
Erred:
  If ErrorHandler("modBNCSParser", "Function GetFTTime") Then Resume Next
End Function

Private Sub HandlePacketBNLSRecv(ByVal PacketID As Byte)
  On Error GoTo Erred
  Set nList = frmMain.tvPackets.Nodes
  Set nRoot = nList.Add
  nRoot.Text = "RECV " & IDBNLS(PacketID) & " (0x" & BufferHex(PacketID, 2) & ")"
  Select Case PacketID
    Case BNLS_CDKEY
      Recv_BNLS_CDKEY
    Case BNLS_LOGONCHALLENGE
      Recv_BNLS_LOGONCHALLENGE
    Case BNLS_LOGONPROOF
      Recv_BNLS_LOGONPROOF
    Case BNLS_CREATEACCOUNT
      Recv_BNLS_CREATEACCOUNT
    Case BNLS_CHANGECHALLENGE
      Recv_BNLS_CHANGECHALLENGE
    Case BNLS_CHANGEPROOF
      Recv_BNLS_CHANGEPROOF
    Case BNLS_UPGRADECHALLENGE
      Recv_BNLS_UPGRADECHALLENGE
    Case BNLS_UPGRADEPROOF
      Recv_BNLS_UPGRADEPROOF
    Case BNLS_VERSIONCHECK
      Recv_BNLS_VERSIONCHECK
    Case BNLS_CONFIRMLOGON
      Recv_BNLS_CONFIRMLOGON
    Case BNLS_HASHDATA
      Recv_BNLS_HASHDATA
    Case BNLS_CDKEY_EX
      Recv_BNLS_CDKEY_EX
    Case BNLS_CHOOSENLSREVISION
      Recv_BNLS_CHOOSENLSREVISION
    Case BNLS_AUTHORIZE
      Recv_BNLS_AUTHORIZE
    Case BNLS_AUTHORIZEPROOF
      Recv_BNLS_AUTHORIZEPROOF
    Case BNLS_REQUESTVERSIONBYTE
      Recv_BNLS_REQUESTVERSIONBYTE
    Case BNLS_VERIFYSERVER
      Recv_BNLS_VERIFYSERVER
    Case BNLS_RESERVESERVERSLOTS
      Recv_BNLS_RESERVESERVERSLOTS
    Case BNLS_SERVERLOGONCHALLENGE
      Recv_BNLS_SERVERLOGONCHALLENGE
    Case BNLS_SERVERLOGONPROOF
      Recv_BNLS_SERVERLOGONPROOF
    Case BNLS_VERSIONCHECKEX
      Recv_BNLS_VERSIONCHECKEX
    Case BNLS_VERSIONCHECKEX2
      Recv_BNLS_VERSIONCHECKEX2
    Case Else
      nList.Add nRoot, tvwChild, , "Unknown: " & StH(BNLSPacket.GetNull, True)
  End Select
Exit Sub
Erred:
  If ErrorHandler("modBNCSParser", "Sub HandlePacketBNLSRecv") Then Resume Next
End Sub

Private Sub HandlePacketBNLSSend(ByVal PacketID As Byte)
  On Error GoTo Erred
  Set nList = frmMain.tvPackets.Nodes
  Set nRoot = nList.Add
  nRoot.Text = "SEND " & IDBNLS(PacketID) & " (0x" & BufferHex(PacketID, 2) & ")"
  Select Case PacketID
    Case BNLS_NULL
      Send_BNLS_NULL
    Case BNLS_CDKEY
      Send_BNLS_CDKEY
    Case BNLS_LOGONCHALLENGE
      Send_BNLS_LOGONCHALLENGE
    Case BNLS_LOGONPROOF
      Send_BNLS_LOGONPROOF
    Case BNLS_CREATEACCOUNT
      Send_BNLS_CREATEACCOUNT
    Case BNLS_CHANGECHALLENGE
      Send_BNLS_CHANGECHALLENGE
    Case BNLS_CHANGEPROOF
      Send_BNLS_CHANGEPROOF
    Case BNLS_UPGRADECHALLENGE
      Send_BNLS_UPGRADECHALLENGE
    Case BNLS_UPGRADEPROOF
      Send_BNLS_UPGRADEPROOF
    Case BNLS_VERSIONCHECK
      Send_BNLS_VERSIONCHECK
    Case BNLS_CONFIRMLOGON
      Send_BNLS_CONFIRMLOGON
    Case BNLS_HASHDATA
      Send_BNLS_HASHDATA
    Case BNLS_CDKEY_EX
      Send_BNLS_CDKEY_EX
    Case BNLS_CHOOSENLSREVISION
      Send_BNLS_CHOOSENLSREVISION
    Case BNLS_AUTHORIZE
      Send_BNLS_AUTHORIZE
    Case BNLS_AUTHORIZEPROOF
      Send_BNLS_AUTHORIZEPROOF
    Case BNLS_REQUESTVERSIONBYTE
      Send_BNLS_REQUESTVERSIONBYTE
    Case BNLS_VERIFYSERVER
      Send_BNLS_VERIFYSERVER
    Case BNLS_RESERVESERVERSLOTS
      Send_BNLS_RESERVESERVERSLOTS
    Case BNLS_SERVERLOGONCHALLENGE
      Send_BNLS_SERVERLOGONCHALLENGE
    Case BNLS_SERVERLOGONPROOF
      Send_BNLS_SERVERLOGONPROOF
    Case BNLS_VERSIONCHECKEX
      Send_BNLS_VERSIONCHECKEX
    Case BNLS_VERSIONCHECKEX2
      Send_BNLS_VERSIONCHECKEX2
    Case Else
      nList.Add nRoot, tvwChild, , "Unknown: " & StH(BNLSPacket.GetNull, True)
  End Select
Exit Sub
Erred:
  If ErrorHandler("modBNCSParser", "Sub HandlePacketBNLSSend") Then Resume Next
End Sub

Private Sub HandlePacketMCPRecv(ByVal PacketID As Byte)
  On Error GoTo Erred
  Set nList = frmMain.tvPackets.Nodes
  Set nRoot = nList.Add
  nRoot.Text = "RECV " & IDMCP(PacketID) & " (0x" & BufferHex(PacketID, 2) & ")"
  Select Case PacketID
    Case MCP_STARTUP
      Recv_MCP_STARTUP
    Case MCP_CHARCREATE
      Recv_MCP_CHARCREATE
    Case MCP_CREATEGAME
      Recv_MCP_CREATEGAME
    Case MCP_JOINGAME
      Recv_MCP_JOINGAME
    Case MCP_GAMELIST
      Recv_MCP_GAMELIST
    Case MCP_GAMEINFO
      Recv_MCP_GAMEINFO
    Case MCP_CHARLOGON
      Recv_MCP_CHARLOGON
    Case MCP_CHARDELETE
      Recv_MCP_CHARDELETE
    Case MCP_REQUESTLADDERDATA
      Recv_MCP_REQUESTLADDERDATA
    Case MCP_MOTD
      Recv_MCP_MOTD
    Case MCP_CREATEQUEUE
      Recv_MCP_CREATEQUEUE
    Case MCP_CHARLIST
      Recv_MCP_CHARLIST
    Case MCP_CHARUPGRADE
      Recv_MCP_CHARUPGRADE
    Case MCP_CHARLIST2
      Recv_MCP_CHARLIST2
    Case Else
      nList.Add nRoot, tvwChild, , "Unknown: " & StH(MCPPacket.GetNull, True)
  End Select
Exit Sub
Erred:
  If ErrorHandler("modBNCSParser", "Sub HandlePacketMCPRecv") Then Resume Next
End Sub

Private Sub HandlePacketMCPSend(ByVal PacketID As Byte)
  On Error GoTo Erred
  Set nList = frmMain.tvPackets.Nodes
  Set nRoot = nList.Add
  nRoot.Text = "SEND " & IDMCP(PacketID) & " (0x" & BufferHex(PacketID, 2) & ")"
  Select Case PacketID
    Case MCP_STARTUP
      Send_MCP_STARTUP
    Case MCP_CHARCREATE
      Send_MCP_CHARCREATE
    Case MCP_CREATEGAME
      Send_MCP_CREATEGAME
    Case MCP_JOINGAME
      Send_MCP_JOINGAME
    Case MCP_GAMELIST
      Send_MCP_GAMELIST
    Case MCP_GAMEINFO
      Send_MCP_GAMEINFO
    Case MCP_CHARLOGON
      Send_MCP_CHARLOGON
    Case MCP_CHARDELETE
      Send_MCP_CHARDELETE
    Case MCP_REQUESTLADDERDATA
      Send_MCP_REQUESTLADDERDATA
    Case MCP_MOTD
      Send_MCP_MOTD
    Case MCP_CANCELGAMECREATE
      Send_MCP_CANCELGAMECREATE
    Case MCP_CHARLIST
      Send_MCP_CHARLIST
    Case MCP_CHARUPGRADE
      Send_MCP_CHARUPGRADE
    Case MCP_CHARLIST2
      Send_MCP_CHARLIST2
    Case Else
      nList.Add nRoot, tvwChild, , "Unknown: " & StH(MCPPacket.GetNull, True)
  End Select
Exit Sub
Erred:
  If ErrorHandler("modBNCSParser", "Sub HandlePacketMCPSend") Then Resume Next
End Sub

Private Sub HandlePacketSIDRecv(ByVal PacketID As Byte)
  On Error GoTo Erred
  Set nList = frmMain.tvPackets.Nodes
  Set nRoot = nList.Add
  nRoot.Text = "RECV " & IDSID(PacketID) & " (0x" & BufferHex(PacketID, 2) & ")"
  Select Case PacketID
    Case SID_NULL
      Recv_SID_NULL
    Case SID_SERVERLIST
      Recv_SID_SERVERLIST
    Case SID_CLIENTID
      Recv_SID_CLIENTID
    Case SID_STARTVERSIONING
      Recv_SID_STARTVERSIONING
    Case SID_REPORTVERSION
      Recv_SID_REPORTVERSION
    Case SID_STARTADVEX
      Recv_SID_STARTADVEX
    Case SID_GETADVLISTEX
      Recv_SID_GETADVLISTEX
    Case SID_ENTERCHAT
      Recv_SID_ENTERCHAT
    Case SID_GETCHANNELLIST
      Recv_SID_GETCHANNELLIST
    Case SID_CHATEVENT
      Recv_SID_CHATEVENT
    Case SID_FLOODDETECTED
      Recv_SID_FLOODDETECTED
    Case SID_CHECKAD
      Recv_SID_CHECKAD
    Case SID_REGISTRY
      Recv_SID_REGISTRY
    Case SID_MESSAGEBOX
      Recv_SID_MESSAGEBOX
    Case SID_STARTADVEX3
      Recv_SID_STARTADVEX3
    Case SID_LOGONCHALLENGEEX
      Recv_SID_LOGONCHALLENGEEX
    Case SID_PING
      Recv_SID_PING
    Case SID_READUSERDATA
      Recv_SID_READUSERDATA
    Case SID_LOGONCHALLENGE
      Recv_SID_LOGONCHALLENGE
    Case SID_LOGONRESPONSE
      Recv_SID_LOGONRESPONSE
    Case SID_CREATEACCOUNT
      Recv_SID_CREATEACCOUNT
    Case SID_GETICONDATA
      Recv_SID_GETICONDATA
    Case SID_GETLADDERDATA
      Recv_SID_GETLADDERDATA
    Case SID_FINDLADDERUSER
      Recv_SID_FINDLADDERUSER
    Case SID_CDKEY
      Recv_SID_CDKEY
    Case SID_CHANGEPASSWORD
      Recv_SID_CHANGEPASSWORD
    Case SID_CHECKDATAFILE
      Recv_SID_CHECKDATAFILE
    Case SID_GETFILETIME
      Recv_SID_GETFILETIME
    Case SID_QUERYREALMS
      Recv_SID_QUERYREALMS
    Case SID_PROFILE
      Recv_SID_PROFILE
    Case SID_CDKEY2
      Recv_SID_CDKEY2
    Case SID_LOGONRESPONSE2
      Recv_SID_LOGONRESPONSE2
    Case SID_CHECKDATAFILE2
      Recv_SID_CHECKDATAFILE2
    Case SID_CREATEACCOUNT2
      Recv_SID_CREATEACCOUNT2
    Case SID_LOGONREALMEX
      Recv_SID_LOGONREALMEX
    Case SID_STARTVERSIONING2
      Recv_SID_STARTVERSIONING2
    Case SID_QUERYREALMS2
      Recv_SID_QUERYREALMS2
    Case SID_QUERYADURL
      Recv_SID_QUERYADURL
    Case SID_WARCRAFTGENERAL
      Recv_SID_WARCRAFTGENERAL
    Case SID_NEWS_INFO
      Recv_SID_NEWS_INFO
    Case SID_OPTIONALWORK
      Recv_SID_OPTIONALWORK
    Case SID_REQUIREDWORK
      Recv_SID_REQUIREDWORK
    Case SID_TOURNAMENT
      Recv_SID_TOURNAMENT
    Case SID_AUTH_INFO
      Recv_SID_AUTH_INFO
    Case SID_AUTH_CHECK
      Recv_SID_AUTH_CHECK
    Case SID_AUTH_ACCOUNTCREATE
      Recv_SID_AUTH_ACCOUNTCREATE
    Case SID_AUTH_ACCOUNTLOGON
      Recv_SID_AUTH_ACCOUNTLOGON
    Case SID_AUTH_ACCOUNTLOGONPROOF
      Recv_SID_AUTH_ACCOUNTLOGONPROOF
    Case SID_AUTH_ACCOUNTCHANGE
      Recv_SID_AUTH_ACCOUNTCHANGE
    Case SID_AUTH_ACCOUNTCHANGEPROOF
      Recv_SID_AUTH_ACCOUNTCHANGEPROOF
    Case SID_AUTH_ACCOUNTUPGRADE
      Recv_SID_AUTH_ACCOUNTUPGRADE
    Case SID_AUTH_ACCOUNTUPGRADEPROOF
      Recv_SID_AUTH_ACCOUNTUPGRADEPROOF
    Case SID_SETEMAIL
      Recv_SID_SETEMAIL
    Case SID_WARDEN
      Recv_SID_WARDEN
    Case SID_GAMEPLAYERSEARCH
      Recv_SID_GAMEPLAYERSEARCH
    Case SID_FRIENDSLIST
      Recv_SID_FRIENDSLIST
    Case SID_FRIENDSUPDATE
      Recv_SID_FRIENDSUPDATE
    Case SID_FRIENDSADD
      Recv_SID_FRIENDSADD
    Case SID_FRIENDSREMOVE
      Recv_SID_FRIENDSREMOVE
    Case SID_FRIENDSPOSITION
      Recv_SID_FRIENDSPOSITION
    Case SID_CLANFINDCANDIDATES
      Recv_SID_CLANFINDCANDIDATES
    Case SID_CLANINVITEMULTIPLE
      Recv_SID_CLANINVITEMULTIPLE
    Case SID_CLANCREATIONINVITATION
      Recv_SID_CLANCREATIONINVITATION
    Case SID_CLANDISBAND
      Recv_SID_CLANDISBAND
    Case SID_CLANMAKECHIEFTAIN
      Recv_SID_CLANMAKECHIEFTAIN
    Case SID_CLANINFO
      Recv_SID_CLANINFO
    Case SID_CLANQUITNOTIFY
      Recv_SID_CLANQUITNOTIFY
    Case SID_CLANINVITATION
      Recv_SID_CLANINVITATION
    Case SID_CLANREMOVEMEMBER
      Recv_SID_CLANREMOVEMEMBER
    Case SID_CLANINVITATIONRESPONSE
      Recv_SID_CLANINVITATIONRESPONSE
    Case SID_CLANRANKCHANGE
      Recv_SID_CLANRANKCHANGE
    Case SID_CLANMOTD
      Recv_SID_CLANMOTD
    Case SID_CLANMEMBERLIST
      Recv_SID_CLANMEMBERLIST
    Case SID_CLANMEMBERREMOVED
      Recv_SID_CLANMEMBERREMOVED
    Case SID_CLANMEMBERSTATUSCHANGE
      Recv_SID_CLANMEMBERSTATUSCHANGE
    Case SID_CLANMEMBERRANKCHANGE
      Recv_SID_CLANMEMBERRANKCHANGE
    Case SID_CLANMEMBERINFORMATION
      Recv_SID_CLANMEMBERINFORMATION
    Case Else
      nList.Add nRoot, tvwChild, , "Unknown: " & StH(SIDPacket.GetNull, True)
  End Select
Exit Sub
Erred:
  If ErrorHandler("modBNCSParser", "Sub HandlePacketSIDRecv") Then Resume Next
End Sub

Private Sub HandlePacketSIDSend(ByVal PacketID As Byte)
  On Error GoTo Erred
  Set nList = frmMain.tvPackets.Nodes
  Set nRoot = nList.Add
  nRoot.Text = "SEND " & IDSID(PacketID) & " (0x" & BufferHex(PacketID, 2) & ")"
  Select Case PacketID
    Case SID_NULL
      Send_SID_NULL
    Case SID_STOPADV
      Send_SID_STOPADV
    Case SID_CLIENTID
      Send_SID_CLIENTID
    Case SID_STARTVERSIONING
      Send_SID_STARTVERSIONING
    Case SID_REPORTVERSION
      Send_SID_REPORTVERSION
    Case SID_STARTADVEX
      Send_SID_SID_STARTADVEX
    Case SID_GETADVLISTEX
      Send_SID_GETADVLISTEX
    Case SID_ENTERCHAT
      Send_SID_ENTERCHAT
    Case SID_GETCHANNELLIST
      Send_SID_GETCHANNELLIST
    Case SID_JOINCHANNEL
      Send_SID_JOINCHANNEL
    Case SID_CHATCOMMAND
      Send_SID_CHATCOMMAND
    Case SID_LEAVECHAT
      Send_SID_LEAVECHAT
    Case SID_LOCALEINFO
      Send_SID_LOCALEINFO
    Case SID_UDPPINGRESPONSE
      Send_SID_UDPPINGRESPONSE
    Case SID_CHECKAD
      Send_SID_CHECKAD
    Case SID_CLICKAD
      Send_SID_CLICKAD
    Case SID_REGISTRY
      Send_SID_REGISTRY
    Case SID_STARTADVEX2
      Send_SID_STARTADVEX2
    Case SID_GAMEDATAADDRESS
      Send_SID_GAMEDATAADDRESS
    Case SID_STARTADVEX3
      Send_SID_STARTADVEX3
    Case SID_CLIENTID2
      Send_SID_CLIENTID2
    Case SID_LEAVEGAME
      Send_SID_LEAVEGAME
    Case SID_DISPLAYAD
      Send_SID_DISPLAYAD
    Case SID_NOTIFYJOIN
      Send_SID_NOTIFYJOIN
    Case SID_PING
      Send_SID_PING
    Case SID_READUSERDATA
      Send_SID_READUSERDATA
    Case SID_WRITEUSERDATA
      Send_SID_WRITEUSERDATA
    Case SID_LOGONRESPONSE
      Send_SID_LOGONRESPONSE
    Case SID_CREATEACCOUNT
      Send_SID_CREATEACCOUNT
    Case SID_SYSTEMINFO
      Send_SID_SYSTEMINFO
    Case SID_GAMERESULT
      Send_SID_GAMERESULT
    Case SID_GETICONDATA
      Send_SID_GETICONDATA
    Case SID_GETLADDERDATA
      Send_SID_GETLADDERDATA
    Case SID_FINDLADDERUSER
      Send_SID_FINDLADDERUSER
    Case SID_CDKEY
      Send_SID_CDKEY
    Case SID_CHANGEPASSWORD
      Send_SID_CHANGEPASSWORD
    Case SID_CHECKDATAFILE
      Send_SID_CHECKDATAFILE
    Case SID_GETFILETIME
      Send_SID_GETFILETIME
    Case SID_QUERYREALMS
      Send_SID_QUERYREALMS
    Case SID_PROFILE
      Send_SID_PROFILE
    Case SID_CDKEY2
      Send_SID_CDKEY2
    Case SID_LOGONRESPONSE2
      Send_SID_LOGONRESPONSE2
    Case SID_CHECKDATAFILE2
      Send_SID_CHECKDATAFILE2
    Case SID_CREATEACCOUNT2
      Send_SID_CREATEACCOUNT2
    Case SID_LOGONREALMEX
      Send_SID_LOGONREALMEX
    Case SID_QUERYREALMS2
      Send_SID_QUERYREALMS2
    Case SID_QUERYADURL
      Send_SID_QUERYADURL
    Case SID_WARCRAFTGENERAL
      Send_SID_WARCRAFTGENERAL
    Case SID_NETGAMEPORT
      Send_SID_NETGAMEPORT
    Case SID_NEWS_INFO
      Send_SID_NEWS_INFO
    Case SID_EXTRAWORK
      Send_SID_EXTRAWORK
    Case SID_AUTH_INFO
      Send_SID_AUTH_INFO
    Case SID_AUTH_CHECK
      Send_SID_AUTH_CHECK
    Case SID_AUTH_ACCOUNTCREATE
      Send_SID_AUTH_ACCOUNTCREATE
    Case SID_AUTH_ACCOUNTLOGON
      Send_SID_AUTH_ACCOUNTLOGON
    Case SID_AUTH_ACCOUNTLOGONPROOF
      Send_SID_AUTH_ACCOUNTLOGONPROOF
    Case SID_AUTH_ACCOUNTCHANGE
      Send_SID_AUTH_ACCOUNTCHANGE
    Case SID_AUTH_ACCOUNTCHANGEPROOF
      Send_SID_AUTH_ACCOUNTCHANGEPROOF
    Case SID_AUTH_ACCOUNTUPGRADE
      Send_SID_AUTH_ACCOUNTUPGRADE
    Case SID_AUTH_ACCOUNTUPGRADEPROOF
      Send_SID_AUTH_ACCOUNTUPGRADEPROOF
    Case SID_SETEMAIL
      Send_SID_SETEMAIL
    Case SID_RESETPASSWORD
      Send_SID_RESETPASSWORD
    Case SID_CHANGEEMAIL
      Send_SID_CHANGEEMAIL
    Case SID_SWITCHPRODUCT
      Send_SID_SWITCHPRODUCT
    Case SID_WARDEN
      Send_SID_WARDEN
    Case SID_GAMEPLAYERSEARCH
      Send_SID_GAMEPLAYERSEARCH
    Case SID_FRIENDSLIST
      Send_SID_FRIENDSLIST
    Case SID_FRIENDSUPDATE
      Send_SID_FRIENDSUPDATE
    Case SID_CLANFINDCANDIDATES
      Send_SID_CLANFINDCANDIDATES
    Case SID_CLANINVITEMULTIPLE
      Send_SID_CLANINVITEMULTIPLE
    Case SID_CLANCREATIONINVITATION
      Send_SID_CLANCREATIONINVITATION
    Case SID_CLANDISBAND
      Send_SID_CLANDISBAND
    Case SID_CLANMAKECHIEFTAIN
      Send_SID_CLANMAKECHIEFTAIN
    Case SID_CLANINVITATION
      Send_SID_CLANINVITATION
    Case SID_CLANREMOVEMEMBER
      Send_SID_CLANREMOVEMEMBER
    Case SID_CLANINVITATIONRESPONSE
      Send_SID_CLANINVITATIONRESPONSE
    Case SID_CLANRANKCHANGE
      Send_SID_CLANRANKCHANGE
    Case SID_CLANSETMOTD
      Send_SID_CLANSETMOTD
    Case SID_CLANMOTD
      Send_SID_CLANMOTD
    Case SID_CLANMEMBERLIST
      Send_SID_CLANMEMBERLIST
    Case SID_CLANMEMBERINFORMATION
      Send_SID_CLANMEMBERINFORMATION
    Case Else
      nList.Add nRoot, tvwChild, , "Unknown: " & StH(SIDPacket.GetNull, True)
  End Select
Exit Sub
Erred:
  If ErrorHandler("modBNCSParser", "Sub HandlePacketSIDSend") Then Resume Next
End Sub

Private Function HexToIP(ByVal sHex As String, Optional ByVal bReverse As Boolean = False) As String
Dim I As Integer
  For I = 1 To Len(sHex) - 1 Step 2
    If bReverse Then
      HexToIP = Val("&H" & Mid$(sHex, I, 2)) & "." & HexToIP
    Else
      HexToIP = HexToIP & "." & Val("&H" & Mid$(sHex, I, 2))
    End If
  Next I
  HexToIP = Left$(HexToIP, Len(HexToIP) - 1)
End Function

Private Function HexToPort(ByVal sHex As String, Optional ByVal bReverse As Boolean = False) As Long
Dim sHTP As String
Dim I    As Integer
  If bReverse Then
    For I = 1 To Len(sHex) - 1 Step 2
      sHTP = Mid$(sHex, I, 2) & sHTP
    Next I
  Else
    sHTP = sHex
  End If
  HexToPort = Val("&H" & sHTP)
End Function

Private Function IDBNLS(ByVal PacketID As Byte) As String
  On Error GoTo Erred
  Select Case PacketID
    Case BNLS_NULL
      IDBNLS = "BNLS_NULL"
    Case BNLS_CDKEY
      IDBNLS = "BNLS_CDKEY"
    Case BNLS_LOGONCHALLENGE
      IDBNLS = "BNLS_LOGONCHALLENGE"
    Case BNLS_LOGONPROOF
      IDBNLS = "BNLS_LOGONPROOF"
    Case BNLS_CREATEACCOUNT
      IDBNLS = "BNLS_CREATEACCOUNT"
    Case BNLS_CHANGECHALLENGE
      IDBNLS = "BNLS_CHANGECHALLENGE"
    Case BNLS_CHANGEPROOF
      IDBNLS = "BNLS_CHANGEPROOF"
    Case BNLS_UPGRADECHALLENGE
      IDBNLS = "BNLS_UPGRADECHALLENGE"
    Case BNLS_UPGRADEPROOF
      IDBNLS = "BNLS_UPGRADEPROOF"
    Case BNLS_VERSIONCHECK
      IDBNLS = "BNLS_VERSIONCHECK"
    Case BNLS_CONFIRMLOGON
      IDBNLS = "BNLS_CONFIRMLOGON"
    Case BNLS_HASHDATA
      IDBNLS = "BNLS_HASHDATA"
    Case BNLS_CDKEY_EX
      IDBNLS = "BNLS_CDKEY_EX"
    Case BNLS_CHOOSENLSREVISION
      IDBNLS = "BNLS_CHOOSENLSREVISION"
    Case BNLS_AUTHORIZE
      IDBNLS = "BNLS_AUTHORIZE"
    Case BNLS_AUTHORIZEPROOF
      IDBNLS = "BNLS_AUTHORIZEPROOF"
    Case BNLS_REQUESTVERSIONBYTE
      IDBNLS = "BNLS_REQUESTVERSIONBYTE"
    Case BNLS_VERIFYSERVER
      IDBNLS = "BNLS_VERIFYSERVER"
    Case BNLS_RESERVESERVERSLOTS
      IDBNLS = "BNLS_RESERVESERVERSLOTS"
    Case BNLS_SERVERLOGONCHALLENGE
      IDBNLS = "BNLS_SERVERLOGONCHALLENGE"
    Case BNLS_SERVERLOGONPROOF
      IDBNLS = "BNLS_SERVERLOGONPROOF"
    Case BNLS_RESERVED0
      IDBNLS = "BNLS_RESERVED0"
    Case BNLS_RESERVED1
      IDBNLS = "BNLS_RESERVED1"
    Case BNLS_RESERVED2
      IDBNLS = "BNLS_RESERVED2"
    Case BNLS_VERSIONCHECKEX
      IDBNLS = "BNLS_VERSIONCHECKEX"
    Case BNLS_RESERVED3
      IDBNLS = "BNLS_RESERVED3"
    Case BNLS_VERSIONCHECKEX2
      IDBNLS = "BNLS_VERSIONCHECKEX2"
    Case Else
      IDBNLS = "BNLS_UNKNOWN"
  End Select
Exit Function
Erred:
  If ErrorHandler("modBNCSParser", "Function IDBNLS") Then Resume Next
End Function

Private Function IDMCP(ByVal PacketID As Byte) As String
  On Error GoTo Erred
  Select Case PacketID
    Case MCP_STARTUP
      IDMCP = "MCP_STARTUP"
    Case MCP_STARTUP
      IDMCP = "MCP_CHARCREATE"
    Case MCP_CREATEGAME
      IDMCP = "MCP_CREATEGAME"
    Case MCP_JOINGAME
      IDMCP = "MCP_JOINGAME"
    Case MCP_GAMELIST
      IDMCP = "MCP_GAMELIST"
    Case MCP_GAMEINFO
      IDMCP = "MCP_GAMEINFO"
    Case MCP_CHARLOGON
      IDMCP = "MCP_CHARLOGON"
    Case MCP_CHARDELETE
      IDMCP = "MCP_CHARDELETE"
    Case MCP_REQUESTLADDERDATA
      IDMCP = "MCP_REQUESTLADDERDATA"
    Case MCP_MOTD
      IDMCP = "MCP_MOTD"
    Case MCP_CANCELGAMECREATE
      IDMCP = "MCP_CANCELGAMECREATE"
    Case MCP_CREATEQUEUE
      IDMCP = "MCP_CREATEQUEUE"
    Case MCP_CHARLIST
      IDMCP = "MCP_CHARLIST"
    Case MCP_CHARUPGRADE
      IDMCP = "MCP_CHARUPGRADE"
    Case MCP_CHARLIST2
      IDMCP = "MCP_CHARLIST2"
    Case Else
      IDMCP = "MCP_UNKNOWN"
  End Select
Exit Function
Erred:
  If ErrorHandler("modBNCSParser", "Function IDMCP") Then Resume Next
End Function

Private Function IDSID(ByVal PacketID As Byte) As String
  On Error GoTo Erred
  Select Case PacketID
    Case SID_NULL
      IDSID = "SID_NULL"
    Case SID_STOPADV
      IDSID = "SID_STOPADV"
    Case SID_SERVERLIST
      IDSID = "SID_SERVERLIST"
    Case SID_CLIENTID
      IDSID = "SID_CLIENTID"
    Case SID_STARTVERSIONING
      IDSID = "SID_STARTVERSIONING"
    Case SID_REPORTVERSION
      IDSID = "SID_REPORTVERSION"
    Case SID_STARTADVEX
      IDSID = "SID_STARTADVEX"
    Case SID_GETADVLISTEX
      IDSID = "SID_GETADVLISTEX"
    Case SID_ENTERCHAT
      IDSID = "SID_ENTERCHAT"
    Case SID_GETCHANNELLIST
      IDSID = "SID_GETCHANNELLIST"
    Case SID_JOINCHANNEL
      IDSID = "SID_JOINCHANNEL"
    Case SID_CHATCOMMAND
      IDSID = "SID_CHATCOMMAND"
    Case SID_CHATEVENT
      IDSID = "SID_CHATEVENT"
    Case SID_LEAVECHAT
      IDSID = "SID_LEAVECHAT"
    Case SID_LOCALEINFO
      IDSID = "SID_LOCALEINFO"
    Case SID_FLOODDETECTED
      IDSID = "SID_FLOODDETECTED"
    Case SID_UDPPINGRESPONSE
      IDSID = "SID_UDPPINGRESPONSE"
    Case SID_CHECKAD
      IDSID = "SID_CHECKAD"
    Case SID_CLICKAD
      IDSID = "SID_CLICKAD"
    Case SID_REGISTRY
      IDSID = "SID_REGISTRY"
    Case SID_MESSAGEBOX
      IDSID = "SID_MESSAGEBOX"
    Case SID_STARTADVEX2
      IDSID = "SID_STARTADVEX2"
    Case SID_GAMEDATAADDRESS
      IDSID = "SID_GAMEDATAADDRESS"
    Case SID_STARTADVEX3
      IDSID = "SID_STARTADVEX3"
    Case SID_LOGONCHALLENGEEX
      IDSID = "SID_LOGONCHALLENGEEX"
    Case SID_CLIENTID2
      IDSID = "SID_CLIENTID2"
    Case SID_LEAVEGAME
      IDSID = "SID_LEAVEGAME"
    Case SID_DISPLAYAD
      IDSID = "SID_DISPLAYAD"
    Case SID_NOTIFYJOIN
      IDSID = "SID_NOTIFYJOIN"
    Case SID_PING
      IDSID = "SID_PING"
    Case SID_READUSERDATA
      IDSID = "SID_READUSERDATA"
    Case SID_WRITEUSERDATA
      IDSID = "SID_WRITEUSERDATA"
    Case SID_LOGONCHALLENGE
      IDSID = "SID_LOGONCHALLENGE"
    Case SID_LOGONRESPONSE
      IDSID = "SID_LOGONRESPONSE"
    Case SID_CREATEACCOUNT
      IDSID = "SID_CREATEACCOUNT"
    Case SID_SYSTEMINFO
      IDSID = "SID_SYSTEMINFO"
    Case SID_GAMERESULT
      IDSID = "SID_GAMERESULT"
    Case SID_GETICONDATA
      IDSID = "SID_GETICONDATA"
    Case SID_GETLADDERDATA
      IDSID = "SID_GETLADDERDATA"
    Case SID_FINDLADDERUSER
      IDSID = "SID_FINDLADDERUSER"
    Case SID_CDKEY
      IDSID = "SID_CDKEY"
    Case SID_CHANGEPASSWORD
      IDSID = "SID_CHANGEPASSWORD"
    Case SID_CHECKDATAFILE
      IDSID = "SID_CHECKDATAFILE"
    Case SID_GETFILETIME
      IDSID = "SID_GETFILETIME"
    Case SID_QUERYREALMS
      IDSID = "SID_QUERYREALMS"
    Case SID_PROFILE
      IDSID = "SID_PROFILE"
    Case SID_CDKEY2
      IDSID = "SID_CDKEY2"
    Case SID_LOGONRESPONSE2
      IDSID = "SID_LOGONRESPONSE2"
    Case SID_CHECKDATAFILE2
      IDSID = "SID_CHECKDATAFILE2"
    Case SID_CREATEACCOUNT2
      IDSID = "SID_CREATEACCOUNT2"
    Case SID_LOGONREALMEX
      IDSID = "SID_LOGONREALMEX"
    Case SID_STARTVERSIONING2
      IDSID = "SID_STARTVERSIONING2"
    Case SID_QUERYREALMS2
      IDSID = "SID_QUERYREALMS2"
    Case SID_QUERYADURL
      IDSID = "SID_QUERYADURL"
    Case SID_WARCRAFTGENERAL
      IDSID = "SID_WARCRAFTGENERAL"
    Case SID_NETGAMEPORT
      IDSID = "SID_NETGAMEPORT"
    Case SID_NEWS_INFO
      IDSID = "SID_NEWS_INFO"
    Case SID_OPTIONALWORK
      IDSID = "SID_OPTIONALWORK"
    Case SID_EXTRAWORK
      IDSID = "SID_EXTRAWORK"
    Case SID_REQUIREDWORK
      IDSID = "SID_REQUIREDWORK"
    Case SID_TOURNAMENT
      IDSID = "SID_TOURNAMENT"
    Case SID_AUTH_INFO
      IDSID = "SID_AUTH_INFO"
    Case SID_AUTH_CHECK
      IDSID = "SID_AUTH_CHECK"
    Case SID_AUTH_ACCOUNTCREATE
      IDSID = "SID_AUTH_ACCOUNTCREATE"
    Case SID_AUTH_ACCOUNTLOGON
      IDSID = "SID_AUTH_ACCOUNTLOGON"
    Case SID_AUTH_ACCOUNTLOGONPROOF
      IDSID = "SID_AUTH_ACCOUNTLOGONPROOF"
    Case SID_AUTH_ACCOUNTCHANGE
      IDSID = "SID_AUTH_ACCOUNTCHANGE"
    Case SID_AUTH_ACCOUNTCHANGEPROOF
      IDSID = "SID_AUTH_ACCOUNTCHANGEPROOF"
    Case SID_AUTH_ACCOUNTUPGRADE
      IDSID = "SID_AUTH_ACCOUNTUPGRADE"
    Case SID_AUTH_ACCOUNTUPGRADEPROOF
      IDSID = "SID_AUTH_ACCOUNTUPGRADEPROOF"
    Case SID_SETEMAIL
      IDSID = "SID_SETEMAIL"
    Case SID_RESETPASSWORD
      IDSID = "SID_RESETPASSWORD"
    Case SID_CHANGEEMAIL
      IDSID = "SID_CHANGEEMAIL"
    Case SID_SWITCHPRODUCT
      IDSID = "SID_SWITCHPRODUCT"
    Case SID_WARDEN
      IDSID = "SID_WARDEN"
    Case SID_GAMEPLAYERSEARCH
      IDSID = "SID_GAMEPLAYERSEARCH"
    Case SID_FRIENDSLIST
      IDSID = "SID_FRIENDSLIST"
    Case SID_FRIENDSUPDATE
      IDSID = "SID_FRIENDSUPDATE"
    Case SID_FRIENDSADD
      IDSID = "SID_FRIENDSADD"
    Case SID_FRIENDSREMOVE
      IDSID = "SID_FRIENDSREMOVE"
    Case SID_FRIENDSPOSITION
      IDSID = "SID_FRIENDSPOSITION"
    Case SID_CLANFINDCANDIDATES
      IDSID = "SID_CLANFINDCANDIDATES"
    Case SID_CLANINVITEMULTIPLE
      IDSID = "SID_CLANINVITEMULTIPLE"
    Case SID_CLANCREATIONINVITATION
      IDSID = "SID_CLANCREATIONINVITATION"
    Case SID_CLANDISBAND
      IDSID = "SID_CLANDISBAND"
    Case SID_CLANMAKECHIEFTAIN
      IDSID = "SID_CLANMAKECHIEFTAIN"
    Case SID_CLANINFO
      IDSID = "SID_CLANINFO"
    Case SID_CLANQUITNOTIFY
      IDSID = "SID_CLANQUITNOTIFY"
    Case SID_CLANINVITATION
      IDSID = "SID_CLANINVITATION"
    Case SID_CLANREMOVEMEMBER
      IDSID = "SID_CLANREMOVEMEMBER"
    Case SID_CLANINVITATIONRESPONSE
      IDSID = "SID_CLANINVITATIONRESPONSE"
    Case SID_CLANRANKCHANGE
      IDSID = "SID_CLANRANKCHANGE"
    Case SID_CLANSETMOTD
      IDSID = "SID_CLANSETMOTD"
    Case SID_CLANMOTD
      IDSID = "SID_CLANMOTD"
    Case SID_CLANMEMBERLIST
      IDSID = "SID_CLANMEMBERLIST"
    Case SID_CLANMEMBERREMOVED
      IDSID = "SID_CLANMEMBERREMOVED"
    Case SID_CLANMEMBERSTATUSCHANGE
      IDSID = "SID_CLANMEMBERSTATUSCHANGE"
    Case SID_CLANMEMBERRANKCHANGE
      IDSID = "SID_CLANMEMBERRANKCHANGE"
    Case SID_CLANMEMBERINFORMATION
      IDSID = "SID_CLANMEMBERINFORMATION"
    Case Else
      IDSID = "SID_UNKNOWN"
  End Select
Exit Function
Erred:
  If ErrorHandler("modBNCSParser", "Function IDSID") Then Resume Next
End Function

Public Sub ParsePacket(ByVal strTmp As String, ByVal Outbound As Boolean, ByVal InIP As String, ByVal InPort As Long, ByVal OutIP As String, ByVal OutPort As Long)
Dim bytPacketID   As Byte
Dim bFit          As Boolean
  If Len(strTmp) = 0 Then Exit Sub
  Debug.Print StH(strTmp)
  strBuffer = strBuffer & strTmp
  
  'SID
  If CheckPorts(InPort, OutPort, "SID") Then
    If Asc(strTmp) = 1 Then
      If Len(strTmp) > 1 Then
        If Asc(Mid$(strTmp, 2, 1)) = &HFF Then
          SIDIPs.AddIP IIf(Outbound, OutIP, InIP)
        End If
      Else
        SIDIPs.AddIP IIf(Outbound, OutIP, InIP)
      End If
    End If
  End If
  'BNLS
  If CheckPorts(InPort, OutPort, "BNLS") Then
    BNLSIPs.AddIP IIf(Outbound, OutIP, InIP)
  End If
  
  
  Do While Len(strBuffer) > 2
    bFit = False
    'SID Check
    If SIDIPs.CheckIP(IIf(Outbound, OutIP, InIP)) Then
      bytPacketID = TrySID
      If Not bytPacketID = &HFF Then
        If Outbound Then
          HandlePacketSIDSend bytPacketID
        Else
          HandlePacketSIDRecv bytPacketID
        End If
        SIDCount = SIDCount + 1
        bFit = True
      End If
    End If
    'MCP Check
    If MCPIPs.CheckIP(IIf(Outbound, OutIP, InIP)) Then
      bytPacketID = TryMCP
      If Not bytPacketID = &HFF Then
        If Outbound Then
          HandlePacketMCPSend bytPacketID
        Else
          HandlePacketMCPRecv bytPacketID
        End If
        MCPCount = MCPCount + 1
        bFit = True
      End If
    End If
    'BNLS Check
    If BNLSIPs.CheckIP(IIf(Outbound, OutIP, InIP)) Then
      bytPacketID = TryBNLS
      If Not bytPacketID = &HFF Then
        If Outbound Then
          HandlePacketBNLSSend bytPacketID
        Else
          HandlePacketBNLSRecv bytPacketID
        End If
        BNLSCount = BNLSCount + 1
        bFit = True
      End If
    End If
    'UDP Check
    If CheckPorts(InPort, OutPort, "UDP") Then
      bytPacketID = TryUDP
      If Not bytPacketID = &HFF Then
        If Outbound Then
          'HandlePacketUDPSend bytPacketID
        Else
          'HandlePacketUDPRecv bytPacketID
        End If
        UDPCount = UDPCount + 1
        bFit = True
      End If
    End If
    'D2GS Check
    If D2GSIPs.CheckIP(IIf(Outbound, OutIP, InIP)) Then
      bytPacketID = TryD2GS
      If Not bytPacketID = &HFF Then
        If Outbound Then
          'HandlePacketd2GSSend bytPacketID
        Else
          'HandlePacketd2GSRecv bytPacketID
        End If
        D2GSCount = D2GSCount + 1
        bFit = True
      End If
    End If
    'W3GS Check
    If W3GSIPs.CheckIP(IIf(Outbound, OutIP, InIP)) Then
      bytPacketID = TryW3GS
      If Not bytPacketID = &HFF Then
        If Outbound Then
          'HandlePacketW3GSSend bytPacketID
        Else
          'HandlePacketW3GSRecv bytPacketID
        End If
        W3GSCount = W3GSCount + 1
        bFit = True
      End If
    End If
    'BN Check
    If BNIPs.CheckIP(IIf(Outbound, OutIP, InIP)) Then
      bytPacketID = TryBN
      If Not bytPacketID = &HFF Then
        If Outbound Then
          'HandlePacketBNSend bytPacketID
        Else
          'HandlePacketBNRecv bytPacketID
        End If
        BNCount = BNCount + 1
        bFit = True
      End If
    End If
    If Not bFit Then strBuffer = Mid$(strBuffer, 2)
  Loop
End Sub

Private Sub Recv_BNLS_AUTHORIZE()
  nList.Add nRoot, tvwChild, , "Server Code: 0x" & BufferHex(BNLSPacket.GetDWORD)
End Sub

Private Sub Recv_BNLS_AUTHORIZEPROOF()
  nList.Add nRoot, tvwChild, , "Status Code: 0x" & IIf(BNLSPacket.GetDWORD = 0, "Authorized", "Unauthorized")
End Sub

Private Sub Recv_BNLS_CDKEY()
  nList.Add nRoot, tvwChild, , "Result: " & IIf(BNLSPacket.GetDWORD = 0, "False", "True")
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Length: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Product: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Public Value: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Hash: " & StH(BNLSPacket.GetString(20), True)
End Sub

Private Sub Recv_BNLS_CDKEY_EX()
Dim lTmp As Long
Dim I    As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Requested Keys: " & BNLSPacket.GetByte
  lTmp = BNLSPacket.GetByte
  nList.Add nRoot, tvwChild, , "Successful Keys: " & lTmp
  nList.Add nRoot, tvwChild, , "Bit Mask: 0x" & BufferHex(BNLSPacket.GetDWORD)
  For I = 1 To lTmp
    nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Key Length: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Key Product: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Key Public Value: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Key Hash: " & StH(BNLSPacket.GetString(20), True)
  Next I
End Sub

Private Sub Recv_BNLS_CHANGECHALLENGE()
  nList.Add nRoot, tvwChild, , "Client Key: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Recv_BNLS_CHANGEPROOF()
  nList.Add nRoot, tvwChild, , "Old Password Proof: " & StH(BNLSPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "New Salt: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "New Verifier: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Recv_BNLS_CHOOSENLSREVISION()
  nList.Add nRoot, tvwChild, , "Result: " & IIf(BNLSPacket.GetDWORD = 0, "False", "True")
End Sub

Private Sub Recv_BNLS_CONFIRMLOGON()
  nList.Add nRoot, tvwChild, , "Result: " & IIf(BNLSPacket.GetDWORD = 0, "False", "True")
End Sub

Private Sub Recv_BNLS_CREATEACCOUNT()
  nList.Add nRoot, tvwChild, , "Salt: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Verifier: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Recv_BNLS_HASHDATA()
  nList.Add nRoot, tvwChild, , "Hash: " & StH(BNLSPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
End Sub

Private Sub Recv_BNLS_LOGONCHALLENGE()
  nList.Add nRoot, tvwChild, , "Client Key: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Recv_BNLS_LOGONPROOF()
  nList.Add nRoot, tvwChild, , "Client Password Proof: " & StH(BNLSPacket.GetString(20), True)
End Sub

Private Sub Recv_BNLS_REQUESTVERSIONBYTE()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Product ID: " & GetBNLSProduct(lTmp) & " (0x" & BufferHex(lTmp) & ")"
  nList.Add nRoot, tvwChild, , "Version Byte: 0x" & BufferHex(BNLSPacket.GetDWORD)
End Sub

Private Sub Recv_BNLS_RESERVESERVERSLOTS()
  nList.Add nRoot, tvwChild, , "Reserved Slots: " & BNLSPacket.GetDWORD
End Sub

Private Sub Recv_BNLS_SERVERLOGONCHALLENGE()
  nList.Add nRoot, tvwChild, , "Slot Index: " & BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Salt: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Server Key: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Recv_BNLS_SERVERLOGONPROOF()
  nList.Add nRoot, tvwChild, , "Slot Index: " & BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Result: " & IIf(BNLSPacket.GetDWORD = 0, "False", "True")
  nList.Add nRoot, tvwChild, , "Client Password Proof: " & StH(BNLSPacket.GetString(4), True)
End Sub

Private Sub Recv_BNLS_UPGRADECHALLENGE()
  nList.Add nRoot, tvwChild, , "Result: " & IIf(BNLSPacket.GetDWORD = 0, "False", "True")
End Sub

Private Sub Recv_BNLS_UPGRADEPROOF()
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Old Password Hash: " & StH(BNLSPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "New Password Salt: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "New Password Verifier: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Recv_BNLS_VERIFYSERVER()
  nList.Add nRoot, tvwChild, , "Result: " & IIf(BNLSPacket.GetDWORD = 0, "False", "True")
End Sub

Private Sub Recv_BNLS_VERSIONCHECK()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Result: " & IIf(lTmp = 0, "False", "True")
  If lTmp <> 0 Then
    nList.Add nRoot, tvwChild, , "EXE Version: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "EXE Hash: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "EXE Information:: 0x" & BNLSPacket.GetNTString
  End If
End Sub

Private Sub Recv_BNLS_VERSIONCHECKEX()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Result: " & IIf(lTmp = 0, "False", "True")
  If lTmp = 0 Then
    nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
  Else
    nList.Add nRoot, tvwChild, , "EXE Version: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "EXE Hash: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "EXE Information: 0x" & BNLSPacket.GetNTString
    nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Version Byte: 0x" & BufferHex(BNLSPacket.GetDWORD)
  End If
End Sub

Private Sub Recv_BNLS_VERSIONCHECKEX2()
Dim lTmp  As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Result: " & IIf(lTmp = 0, "False", "True")
  If lTmp = 0 Then
    nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
  Else
    nList.Add nRoot, tvwChild, , "EXE Version: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "EXE Hash: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "EXE Information: 0x" & BNLSPacket.GetNTString
    nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Version Byte: 0x" & BufferHex(BNLSPacket.GetDWORD)
  End If
End Sub

Private Sub Recv_MCP_CHARCREATE()
Dim lTmp As Long
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
    Case &H14
      nList.Add nRoot, tvwChild, , "Result: Character exists or maximum characters created (0x" & BufferHex(lTmp) & ")"
    Case &H15
      nList.Add nRoot, tvwChild, , "Result: Invalid Name (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_MCP_CHARDELETE()
Dim lTmp As Long
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
    Case &H46
      nList.Add nRoot, tvwChild, , "Result: Character Doesn't Exist (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_MCP_CHARLIST()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Integer
  nList.Add nRoot, tvwChild, , "Characters Requested: " & MCPPacket.GetWORD
  nList.Add nRoot, tvwChild, , "Characters on Account: " & MCPPacket.GetDWORD
  lTmp = MCPPacket.GetWORD
  Set nItem = nList.Add(nRoot, tvwChild)
   nItem.Text = "Characters (" & lTmp & ")"
   For I = 1 To lTmp
    nList.Add nItem, tvwChild, , "Character #" & I & ": " & MCPPacket.GetNTString & " (" & MCPPacket.GetNTString & ")"
   Next I
End Sub

Private Sub Recv_MCP_CHARLIST2()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim sTemp As String
Dim nItem As Node
Dim nItm2 As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Characters Requested: " & MCPPacket.GetWORD
  nList.Add nRoot, tvwChild, , "Characters on Account: " & MCPPacket.GetDWORD
  lTmp = MCPPacket.GetWORD
  Set nItem = nList.Add(nRoot, tvwChild)
   nItem.Text = "Characters (" & lTmp & ")"
   For I = 1 To lTmp
    Set nItm2 = nList.Add(nItem, tvwChild)
     nItm2.Text = "Character #" & I
      lTmp2 = MCPPacket.GetDWORD
      sTemp = DateAdd("s", lTmp2, DateSerial(1970, 1, 1))
      If DateDiff("s", Now, sTemp) > 0 Then
        sTemp = (DateDiff("s", Now, sTemp) \ 60 \ 60 \ 24)
      Else
        sTemp = 0
      End If
      nList.Add nItm2, tvwChild, , "Expiration Date: " & sTemp & " days"
      nList.Add nItm2, tvwChild, , "Character Statstring: " & ParseStatString("VD2DUSWest," & MCPPacket.GetNTString & "," & MCPPacket.GetNTString)
   Next I
End Sub

Private Sub Recv_MCP_CHARLOGON()
Dim lTmp As Long
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
    Case &H46
      nList.Add nRoot, tvwChild, , "Result: Character Not Found (0x" & BufferHex(lTmp) & ")"
    Case &H7A
      nList.Add nRoot, tvwChild, , "Result: Logon Failed (0x" & BufferHex(lTmp) & ")"
    Case &H7B
      nList.Add nRoot, tvwChild, , "Result: Character Expired (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_MCP_CHARUPGRADE()
Dim lTmp As Long
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
    Case &H46
      nList.Add nRoot, tvwChild, , "Result: Character Not Found (0x" & BufferHex(lTmp) & ")"
    Case &H7A
      nList.Add nRoot, tvwChild, , "Result: Upgrade Failed (0x" & BufferHex(lTmp) & ")"
    Case &H7B
      nList.Add nRoot, tvwChild, , "Result: Character Is Expired (0x" & BufferHex(lTmp) & ")"
    Case &H7C
      nList.Add nRoot, tvwChild, , "Result: Character Already Expansion (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_MCP_CREATEGAME()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Game Token: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
    Case &H1E
      nList.Add nRoot, tvwChild, , "Result: Invalid Game Name (0x" & BufferHex(lTmp) & ")"
    Case &H1F
      nList.Add nRoot, tvwChild, , "Result: Game Already Exists (0x" & BufferHex(lTmp) & ")"
    Case &H20
      nList.Add nRoot, tvwChild, , "Result: Game Servers Down (0x" & BufferHex(lTmp) & ")"
    Case &H6E
      nList.Add nRoot, tvwChild, , "Result: Dead Hardcore Character Can Not Create Games (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_MCP_CREATEQUEUE()
  nList.Add nRoot, tvwChild, , "Position: 0x" & BufferHex(MCPPacket.GetDWORD)
End Sub

Private Sub Recv_MCP_GAMEINFO()
Dim lTmp As Long
Dim I    As Long
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case &H300004
      nList.Add nRoot, tvwChild, , "Status: Game is Available to Join (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Game Uptime: " & MCPPacket.GetDWORD & " seconds"
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Maximum Players Allowed: " & MCPPacket.GetByte
  nList.Add nRoot, tvwChild, , "Characters in Game: " & MCPPacket.GetByte
  For I = 1 To 16
    lTmp = MCPPacket.GetByte
    Select Case lTmp
      Case 0
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: Amazon (0x" & BufferHex(lTmp, 2) & ")"
      Case 1
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: Sorceress (0x" & BufferHex(lTmp, 2) & ")"
      Case 2
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: Necromancer (0x" & BufferHex(lTmp, 2) & ")"
      Case 3
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: Paladin (0x" & BufferHex(lTmp, 2) & ")"
      Case 4
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: Barbarian (0x" & BufferHex(lTmp, 2) & ")"
      Case 5
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: Druid (0x" & BufferHex(lTmp, 2) & ")"
      Case 6
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: Assassin (0x" & BufferHex(lTmp, 2) & ")"
      Case Else
        nList.Add nRoot, tvwChild, , "Player #" & I & " Class: 0x" & BufferHex(lTmp, 2)
    End Select
  Next I
  For I = 1 To 16
    nList.Add nRoot, tvwChild, , "Player #" & I & " Level: " & MCPPacket.GetByte
  Next I
  nList.Add nRoot, tvwChild, , "Unknown: " & MCPPacket.GetByte
  For I = 1 To 16
    nList.Add nRoot, tvwChild, , "Player #" & I & " Name: " & MCPPacket.GetNTString
  Next I
End Sub

Private Sub Recv_MCP_GAMELIST()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Index: 0x" & BufferHex(MCPPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Number of Players in Game: " & MCPPacket.GetByte
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case &H300004
      nList.Add nRoot, tvwChild, , "Status: Game is Available to Join (0x" & BufferHex(lTmp) & ")"
    Case &HFFFFFFFF
      nList.Add nRoot, tvwChild, , "Status: Server is Down (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Game Name: " & MCPPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Description: " & MCPPacket.GetNTString
End Sub

Private Sub Recv_MCP_JOINGAME()
Dim lTmp As Long
Dim sTmp As String
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Game Token: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  sTmp = HexToIP(BufferHex(MCPPacket.GetDWORD))
  D2GSIPs.AddIP sTmp
  nList.Add nRoot, tvwChild, , "D2GS Server IP: " & sTmp
  nList.Add nRoot, tvwChild, , "Game Hash: 0x" & BufferHex(MCPPacket.GetDWORD)
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
    Case &H29
      nList.Add nRoot, tvwChild, , "Result: Incorrect Password (0x" & BufferHex(lTmp) & ")"
    Case &H2A
      nList.Add nRoot, tvwChild, , "Result: Game Does Not Exist (0x" & BufferHex(lTmp) & ")"
    Case &H2B
      nList.Add nRoot, tvwChild, , "Result: Game Is Full (0x" & BufferHex(lTmp) & ")"
    Case &H2B
      nList.Add nRoot, tvwChild, , "Result: Level Requirements Not Met (0x" & BufferHex(lTmp) & ")"
    Case &H6E
      nList.Add nRoot, tvwChild, , "Result: Dead Hardcore Character Can Not Join Games (0x" & BufferHex(lTmp) & ")"
    Case &H71
      nList.Add nRoot, tvwChild, , "Result: Non-Hardcore Character Can Not Join Hardcore Games (0x" & BufferHex(lTmp) & ")"
    Case &H73
      nList.Add nRoot, tvwChild, , "Result: Can Not Join Nightmare Games (0x" & BufferHex(lTmp) & ")"
    Case &H74
      nList.Add nRoot, tvwChild, , "Result: Can Not Join Hell Games (0x" & BufferHex(lTmp) & ")"
    Case &H78
      nList.Add nRoot, tvwChild, , "Result: Non-Expansion Character Can Not Join Expansion Games (0x" & BufferHex(lTmp) & ")"
    Case &H79
      nList.Add nRoot, tvwChild, , "Result: Expansion Character Can Not Join Non-Expansion Games (0x" & BufferHex(lTmp) & ")"
    Case &H7D
      nList.Add nRoot, tvwChild, , "Result: Non-Ladder Character Can Not Join Ladder Games (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_MCP_MOTD()
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetByte, 2)
  nList.Add nRoot, tvwChild, , "MOTD: " & MCPPacket.GetNTString
End Sub

Private Sub Recv_MCP_REQUESTLADDERDATA()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim nItem As Node
Dim nItm2 As Node
Dim I     As Long
  lTmp = MCPPacket.GetByte
  Select Case lTmp
    Case &H0
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H2
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H3
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H4
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Paladin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H5
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H9
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HA
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HB
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HC
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HD
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Paladin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HE
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H13
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H14
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H15
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H16
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H17
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Palanin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H18
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H19
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Druid Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1A
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Assassin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1B
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1C
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1D
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1E
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1F
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Paladin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H20
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H21
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Druid Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H22
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Assassin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Ladder Type: 0x" & BufferHex(lTmp, 2)
  End Select
  nList.Add nRoot, tvwChild, , "Total Response Size: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Current Message Size: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Total Unreceived Messages Size: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Rank of First Entry: " & MCPPacket.GetWORD
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  lTmp = MCPPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetDWORD, 4)
  Set nItem = nList.Add(nRoot, tvwChild)
   nItem.Text = "Characters (" & lTmp & ")"
   For I = 1 To lTmp
     Set nItm2 = nList.Add(nItem, tvwChild)
     nItm2.Text = "Character #" & I
      nList.Add nItm2, tvwChild, , "Experience: " & CDbl("&H" & BufferHex(MCPPacket.GetDWORD) & BufferHex(MCPPacket.GetDWORD))
      lTmp2 = MCPPacket.GetByte
      Select Case lTmp2
        Case 0, &H60, &H70
          nList.Add nItm2, tvwChild, , "Class: Amazon (0x" & BufferHex(lTmp2, 2) & ")"
        Case 1, &H61, &H71
          nList.Add nItm2, tvwChild, , "Class: Sorceress (0x" & BufferHex(lTmp2, 2) & ")"
        Case 2, &H62, &H72
          nList.Add nItm2, tvwChild, , "Class: Necromancer (0x" & BufferHex(lTmp2, 2) & ")"
        Case 3, &H63, &H73
          nList.Add nItm2, tvwChild, , "Class: Paladin (0x" & BufferHex(lTmp2, 2) & ")"
        Case 4, &H64, &H74
          nList.Add nItm2, tvwChild, , "Class: Barbarian (0x" & BufferHex(lTmp2, 2) & ")"
        Case 5, &H65, &H75
          nList.Add nItm2, tvwChild, , "Class: Druid (0x" & BufferHex(lTmp2, 2) & ")"
        Case 6, &H66, &H76
          nList.Add nItm2, tvwChild, , "Class: Assassin (0x" & BufferHex(lTmp2, 2) & ")"
        Case Else
          nList.Add nItm2, tvwChild, , "Class: 0x" & BufferHex(lTmp2, 2)
      End Select
      If (lTmp2 > &H70) Then
        nList.Add nItm2, tvwChild, , "Flags: Dead Hardcore"
      ElseIf (lTmp2 > &H60) Then
        nList.Add nItm2, tvwChild, , "Flags: Hardcore"
      Else
        nList.Add nItm2, tvwChild, , "Flags: Softcore"
      End If
      nList.Add nItm2, tvwChild, , "Title: " & MCPPacket.GetByte
      nList.Add nItm2, tvwChild, , "Level: " & MCPPacket.GetWORD
      nList.Add nItm2, tvwChild, , "Character Name: " & TrimNull(MCPPacket.GetString(16))
   Next I
End Sub

Private Sub Recv_MCP_STARTUP()
Dim lTmp As Long
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 2, &HA To &HD
      nList.Add nRoot, tvwChild, , "Result: Realm Unavailable, No Battle.net Connection Detected (0x" & BufferHex(lTmp) & ")"
    Case &H7E
      nList.Add nRoot, tvwChild, , "Result: CD Key Banned from Realm Play (0x" & BufferHex(lTmp) & ")"
    Case &H7F
      nList.Add nRoot, tvwChild, , "Result: Temporarily IP Banned (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
  End Select
End Sub

Private Sub Recv_SID_AUTH_ACCOUNTCHANGE()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Change Accepted (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Account Doesn't Exist (0x" & BufferHex(lTmp) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Status: Account Requires Upgrade (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Salt: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Server Key: " & StH(SIDPacket.GetString(32), True)
End Sub

Private Sub Recv_SID_AUTH_ACCOUNTCHANGEPROOF()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Password Changed (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Incorrect Password (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Server Old Password Proof: " & StH(SIDPacket.GetString(20), True)
End Sub

Private Sub Recv_SID_AUTH_ACCOUNTCREATE()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Account Created (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Status: Account Already Exists (0x" & BufferHex(lTmp) & ")"
    Case 7
      nList.Add nRoot, tvwChild, , "Status: Account Too Short (0x" & BufferHex(lTmp) & ")"
    Case 8
      nList.Add nRoot, tvwChild, , "Status: Illegal Character (0x" & BufferHex(lTmp) & ")"
    Case 9
      nList.Add nRoot, tvwChild, , "Status: Illegal Word (0x" & BufferHex(lTmp) & ")"
    Case &HA
      nList.Add nRoot, tvwChild, , "Status: Too Few Alphanumeric Characters (0x" & BufferHex(lTmp) & ")"
    Case &HB
      nList.Add nRoot, tvwChild, , "Status: Adjacent Punctuation (0x" & BufferHex(lTmp) & ")"
    Case &HC
      nList.Add nRoot, tvwChild, , "Status: Too Much Punctuation (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_AUTH_ACCOUNTLOGON()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Logon Accepted (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Account Doesn't Exist (0x" & BufferHex(lTmp) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Status: Account Requires Upgrade (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Salt: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Server Key: " & StH(SIDPacket.GetString(32), True)
End Sub

Private Sub Recv_SID_AUTH_ACCOUNTLOGONPROOF()
Dim lTmp  As Long
Dim nItem As Node
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Logon Successful (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Incorrect Password (0x" & BufferHex(lTmp) & ")"
    Case &HE
      nList.Add nRoot, tvwChild, , "Status: No E-Mail Address (0x" & BufferHex(lTmp) & ")"
    Case &HF
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Status: Custom Error (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Server Password Proof: " & StH(SIDPacket.GetString(20), True)
  If lTmp = &HF Then nList.Add nItem, tvwChild, , "Message: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_AUTH_ACCOUNTUPGRADE()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Accepted (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: Denied (0x" & BufferHex(lTmp) & ")"
  End Select
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Recv_SID_AUTH_ACCOUNTUPGRADEPROOF()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Changed (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Incorrect Old Passsword (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Password Proof: " & StH(SIDPacket.GetString(20), True)
End Sub

Private Sub Recv_SID_AUTH_CHECK()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Passed (0x" & BufferHex(lTmp) & ")"
    Case &H100
      nList.Add nRoot, tvwChild, , "Result: Old Game Version (0x" & BufferHex(lTmp) & ")"
    Case &H101
      nList.Add nRoot, tvwChild, , "Result: Invalid Version (0x" & BufferHex(lTmp) & ")"
    Case &H102
      nList.Add nRoot, tvwChild, , "Result: Game Version Must Be Downgraded (0x" & BufferHex(lTmp) & ")"
    Case &H200
      nList.Add nRoot, tvwChild, , "Result: Invalid CD Key (0x" & BufferHex(lTmp) & ")"
    Case &H201
      nList.Add nRoot, tvwChild, , "Result: CD Key In Use (0x" & BufferHex(lTmp) & ")"
    Case &H202
      nList.Add nRoot, tvwChild, , "Result: Banned CD Key (0x" & BufferHex(lTmp) & ")"
    Case &H203
      nList.Add nRoot, tvwChild, , "Result: Wrong Product (0x" & BufferHex(lTmp) & ")"
    Case &H210
      nList.Add nRoot, tvwChild, , "Result: Invalid Expansion Key (0x" & BufferHex(lTmp) & ")"
    Case &H211
      nList.Add nRoot, tvwChild, , "Result: Expansion Key In Use (0x" & BufferHex(lTmp) & ")"
    Case &H212
      nList.Add nRoot, tvwChild, , "Result: Banned Expansion Key (0x" & BufferHex(lTmp) & ")"
    Case &H213
      nList.Add nRoot, tvwChild, , "Result: Wrong Expansion Product (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Additional Info: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_AUTH_INFO()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Logon Type: Broken SHA (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Logon Type: NLS Version 1 (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Logon Type: NLS Version 2 (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Logon Type: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "UDP Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MPQ File Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MPQ File Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Request String: " & StH(SIDPacket.GetNTString, True)
  nList.Add nRoot, tvwChild, , "Server Signature: " & StH(SIDPacket.GetString(128), True)
End Sub

Private Sub Recv_SID_CDKEY()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 1
      nList.Add nRoot, tvwChild, , "Result: OK (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Result: Invalid Key (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Result: Bad Product (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Result: Banned (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Result: In Use (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Owner: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CDKEY2()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 1
      nList.Add nRoot, tvwChild, , "Result: OK (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Result: Invalid Key (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Result: Bad Product (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Result: Banned (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Result: In Use (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Owner: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CHANGEPASSWORD()
  nList.Add nRoot, tvwChild, , "Changed: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Recv_SID_CHATEVENT()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 1
      nList.Add nRoot, tvwChild, , "Event ID: EID_SHOWUSER (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Event ID: EID_JOIN (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Event ID: EID_LEAVE (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Event ID: EID_WHISPER (0x" & BufferHex(lTmp) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Event ID: EID_TALK (0x" & BufferHex(lTmp) & ")"
    Case 6
      nList.Add nRoot, tvwChild, , "Event ID: EID_BROADCAST (0x" & BufferHex(lTmp) & ")"
    Case 7
      nList.Add nRoot, tvwChild, , "Event ID: EID_CHANNEL (0x" & BufferHex(lTmp) & ")"
    Case 9
      nList.Add nRoot, tvwChild, , "Event ID: EID_USERFLAGS (0x" & BufferHex(lTmp) & ")"
    Case &HA
      nList.Add nRoot, tvwChild, , "Event ID: EID_WHISPERSENT (0x" & BufferHex(lTmp) & ")"
    Case &HD
      nList.Add nRoot, tvwChild, , "Event ID: EID_CHANNELFULL (0x" & BufferHex(lTmp) & ")"
    Case &HE
      nList.Add nRoot, tvwChild, , "Event ID: EID_CHANNELDOESNOTEXIST (0x" & BufferHex(lTmp) & ")"
    Case &HF
      nList.Add nRoot, tvwChild, , "Event ID: EID_CHANNELRESTRICTED (0x" & BufferHex(lTmp) & ")"
    Case &H12
      nList.Add nRoot, tvwChild, , "Event ID: EID_INFO (0x" & BufferHex(lTmp) & ")"
    Case &H13
      nList.Add nRoot, tvwChild, , "Event ID: EID_ERROR (0x" & BufferHex(lTmp) & ")"
    Case &H17
      nList.Add nRoot, tvwChild, , "Event ID: EID_EMOTE (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Event ID: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Flags: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Ping: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "IP Address: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Account Number: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Registration Authority: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Username: " & SIDPacket.GetNTString
  Select Case lTmp
    Case 1, 2, 3, 9
      nList.Add nRoot, tvwChild, , "Statstring: " & ParseStatString(SIDPacket.GetNTString)
    Case Else
      nList.Add nRoot, tvwChild, , "Text: " & SIDPacket.GetNTString
  End Select
End Sub

Private Sub Recv_SID_CHECKAD()
  nList.Add nRoot, tvwChild, , "Ad ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "File Extension: " & StrReverse$(HtS(BufferHex(SIDPacket.GetDWORD)))
  nList.Add nRoot, tvwChild, , "Local File Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "File Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Link URL: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CHECKDATAFILE()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Rejected (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Approved (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Ladder Approved (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_CHECKDATAFILE2()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Rejected (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Approved (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Ladder Approved (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_CLANCREATIONINVITATION()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  nList.Add nRoot, tvwChild, , "Clan Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Inviter: " & SIDPacket.GetNTString
  lTmp = SIDPacket.GetByte
  Set nItem = nList.Add(nRoot, tvwChild)
  nItem.Text = "Invited Users (" & lTmp & ")"
  For I = 1 To lTmp
    nList.Add nItem, tvwChild, , "Account #" & I & ": " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_CLANDISBAND()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Clan Disbanded (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Result: Clan Too Young (0x" & BufferHex(lTmp, 2) & ")"
    Case 7
      nList.Add nRoot, tvwChild, , "Result: Unauthorized (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Recv_SID_CLANFINDCANDIDATES()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Found Candidates (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Clan Tag Taken (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: CD Key is Clanned (0x" & BufferHex(lTmp, 2) & ")"
    Case 8
      nList.Add nRoot, tvwChild, , "Status: Already in a Clan (0x" & BufferHex(lTmp, 2) & ")"
    Case &HA
      nList.Add nRoot, tvwChild, , "Status: Invalid Clan Tag (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp, 2)
  End Select
  lTmp = SIDPacket.GetByte
  Set nItem = nList.Add(nRoot, tvwChild)
  nItem.Text = "Candidates (" & lTmp & ")"
  For I = 1 To lTmp
    nList.Add nItem, tvwChild, , "Account #" & I & ": " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_CLANINFO()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetByte, 2)
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Rank: Initiate (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Rank: Peon (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Rank: Grunt (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Rank: Shaman (0x" & BufferHex(lTmp, 2) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Rank: Chieftan (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Rank: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Recv_SID_CLANINVITATION()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Accepted (0x" & BufferHex(lTmp, 2) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Status: Declined (0x" & BufferHex(lTmp, 2) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Status: Invitation Failed (0x" & BufferHex(lTmp, 2) & ")"
    Case 9
      nList.Add nRoot, tvwChild, , "Status: Clan Full (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Recv_SID_CLANINVITATIONRESPONSE()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  nList.Add nRoot, tvwChild, , "Clan Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Inviter: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CLANINVITEMULTIPLE()
Dim lTmp As Long
Dim sTmp As String
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: All Users Accepted (0x" & BufferHex(lTmp, 2) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Result: Declined (0x" & BufferHex(lTmp, 2) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Result: Not Available (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(SIDPacket.GetDWORD)
  End Select
  Do
    sTmp = SIDPacket.GetNTString
    If LenB(sTmp) > 0 Then
      nList.Add nRoot, tvwChild, , "Account: " & sTmp
    Else
      Exit Do
    End If
  Loop
End Sub

Private Sub Recv_SID_CLANMAKECHIEFTAIN()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Success (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Result: Clan Too Young (0x" & BufferHex(lTmp, 2) & ")"
    Case 7
      nList.Add nRoot, tvwChild, , "Result: Unauthorized (0x" & BufferHex(lTmp, 2) & ")"
    Case 8
      nList.Add nRoot, tvwChild, , "Result: Not Allowed (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Recv_SID_CLANMEMBERINFORMATION()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Offline (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Online (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: In a Channel (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Status: In a Public Game (0x" & BufferHex(lTmp, 2) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Status: In a Private Game (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp, 2)
  End Select
  nList.Add nRoot, tvwChild, , "Clan Name: " & SIDPacket.GetNTString
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Rank: Initiate (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Rank: Peon (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Rank: Grunt (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Rank: Shaman (0x" & BufferHex(lTmp, 2) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Rank: Chieftan (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Rank: 0x" & BufferHex(lTmp, 2)
  End Select
  nList.Add nRoot, tvwChild, , "Date Joined: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
End Sub

Private Sub Recv_SID_CLANMEMBERLIST()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim nItem As Node
Dim nItm2 As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Set nItem = nList.Add(nRoot, tvwChild)
  nItem.Text = "Members (" & lTmp & ")"
  For I = 1 To lTmp
    Set nItm2 = nList.Add(nItem, tvwChild)
    nItm2.Text = "Account #" & I & ": " & SIDPacket.GetNTString
    lTmp2 = SIDPacket.GetByte
    Select Case lTmp2
      Case 0
        nList.Add nItm2, tvwChild, , "Rank: Initiate (0x" & BufferHex(lTmp2, 2) & ")"
      Case 1
        nList.Add nItm2, tvwChild, , "Rank: Peon (0x" & BufferHex(lTmp2, 2) & ")"
      Case 2
        nList.Add nItm2, tvwChild, , "Rank: Grunt (0x" & BufferHex(lTmp2, 2) & ")"
      Case 3
        nList.Add nItm2, tvwChild, , "Rank: Shaman (0x" & BufferHex(lTmp2, 2) & ")"
      Case 4
        nList.Add nItm2, tvwChild, , "Rank: Chieftan (0x" & BufferHex(lTmp2, 2) & ")"
      Case Else
        nList.Add nItm2, tvwChild, , "Rank: 0x" & BufferHex(lTmp2, 2)
    End Select
    lTmp2 = SIDPacket.GetByte
    Select Case lTmp2
      Case 0
        nList.Add nItm2, tvwChild, , "Status: Offline (0x" & BufferHex(lTmp2, 2) & ")"
      Case 1
        nList.Add nItm2, tvwChild, , "Status: Online (0x" & BufferHex(lTmp2, 2) & ")"
      Case Else
        nList.Add nItm2, tvwChild, , "Status: 0x" & BufferHex(lTmp2, 2)
    End Select
    nList.Add nItm2, tvwChild, , "Location: " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_CLANMEMBERRANKCHANGE()
Dim lTmp As Long
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Old Rank: Initiate (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Old Rank: Peon (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Old Rank: Grunt (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Old Rank: Shaman (0x" & BufferHex(lTmp, 2) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Old Rank: Chieftan (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Old Rank: 0x" & BufferHex(lTmp, 2)
  End Select
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "New Rank: Initiate (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "New Rank: Peon (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "New Rank: Grunt (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "New Rank: Shaman (0x" & BufferHex(lTmp, 2) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "New Rank: Chieftan (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "New Rank: 0x" & BufferHex(lTmp, 2)
  End Select
  nList.Add nRoot, tvwChild, , "Changed By: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CLANMEMBERREMOVED()
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CLANMEMBERSTATUSCHANGE()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Rank: Initiate (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Rank: Peon (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Rank: Grunt (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Rank: Shaman (0x" & BufferHex(lTmp, 2) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Rank: Chieftan (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Rank: 0x" & BufferHex(lTmp, 2)
  End Select
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Offline (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Online (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: In a Channel (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Status: In a Public Game (0x" & BufferHex(lTmp, 2) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Status: In a Private Game (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp, 2)
  End Select
  nList.Add nRoot, tvwChild, , "Location: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CLANMOTD()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MOTD: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_CLANQUITNOTIFY()
  nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(SIDPacket.GetByte, 2)
End Sub

Private Sub Recv_SID_CLANRANKCHANGE()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Changed Rank (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Change Failed (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Can't Change Rank Yet (0x" & BufferHex(lTmp, 2) & ")"
    Case 7
      nList.Add nRoot, tvwChild, , "Status: Not Authorized (0x" & BufferHex(lTmp, 2) & ")"
    Case 8
      nList.Add nRoot, tvwChild, , "Status: Not Allowed (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Recv_SID_CLANREMOVEMEMBER()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Removed (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Removal Failed (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Can't Be Removed Yet (0x" & BufferHex(lTmp, 2) & ")"
    Case 7
      nList.Add nRoot, tvwChild, , "Status: Not Authorized (0x" & BufferHex(lTmp, 2) & ")"
    Case 8
      nList.Add nRoot, tvwChild, , "Status: Not Allowed (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Recv_SID_CLIENTID()
  nList.Add nRoot, tvwChild, , "Registration Version: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Registration Authority: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Account Number: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Registration Token: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Recv_SID_CREATEACCOUNT()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Fail (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Success (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_CREATEACCOUNT2()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Account Created (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Contains Invalid Characters (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Status: Contains Banned Word (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Status: Alredy Exists (0x" & BufferHex(lTmp) & ")"
    Case 6
      nList.Add nRoot, tvwChild, , "Status: Not Enough Alphanumeric Characters (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Suggestion: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_ENTERCHAT()
  nList.Add nRoot, tvwChild, , "Unique Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Statstring: " & ParseStatString(SIDPacket.GetNTString)
  nList.Add nRoot, tvwChild, , "Account Name: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_FINDLADDERUSER()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  If lTmp = &HFFFFFFFF Then
    nList.Add nRoot, tvwChild, , "Rank: Unlisted (0x" & BufferHex(lTmp) & ")"
  Else
    nList.Add nRoot, tvwChild, , "Rank: 0x" & BufferHex(lTmp)
  End If
End Sub

Private Sub Recv_SID_FLOODDETECTED()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Recv_SID_FRIENDSADD()
Dim lTmp  As Long
Dim sTmp  As String
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
  lTmp = SIDPacket.GetByte
  sTmp = vbNullString
  If lTmp And &H1 Then sTmp = sTmp & " Mutual"
  If lTmp And &H2 Then sTmp = sTmp & " DND"
  If lTmp And &H4 Then sTmp = sTmp & " Away"
  nList.Add nRoot, tvwChild, , "Status: " & Trim$(sTmp) & " (0x" & BufferHex(lTmp, 2) & ")"
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Location: Offline (0x" & BufferHex(lTmp, 2) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Location: Not In Chat (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Location: In Chat (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Location: In a Public Game (0x" & BufferHex(lTmp, 2) & ")"
    Case 4, 5
      nList.Add nRoot, tvwChild, , "Location: In a Private Game (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Location: 0x" & BufferHex(lTmp, 2)
  End Select
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Location: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_FRIENDSLIST()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim sTmp  As String
Dim nItem As Node
Dim I     As Long
  lTmp = SIDPacket.GetByte
  For I = 1 To lTmp
    Set nItem = nList.Add(nRoot, tvwChild)
    nItem.Text = "Friend #" & I
    nList.Add nItem, tvwChild, , "Account: " & SIDPacket.GetNTString
    lTmp2 = SIDPacket.GetByte
    sTmp = vbNullString
    If lTmp2 And &H1 Then sTmp = sTmp & " Mutual"
    If lTmp2 And &H2 Then sTmp = sTmp & " DND"
    If lTmp2 And &H4 Then sTmp = sTmp & " Away"
    nList.Add nItem, tvwChild, , "Status: " & Trim$(sTmp) & " (0x" & BufferHex(lTmp2, 2) & ")"
    lTmp2 = SIDPacket.GetByte
    Select Case lTmp2
      Case 0
        nList.Add nItem, tvwChild, , "Location: Offline (0x" & BufferHex(lTmp2, 2) & ")"
      Case 1
        nList.Add nItem, tvwChild, , "Location: Not In Chat (0x" & BufferHex(lTmp2, 2) & ")"
      Case 2
        nList.Add nItem, tvwChild, , "Location: In Chat (0x" & BufferHex(lTmp2, 2) & ")"
      Case 3
        nList.Add nItem, tvwChild, , "Location: In a Public Game (0x" & BufferHex(lTmp2, 2) & ")"
      Case 4, 5
        nList.Add nItem, tvwChild, , "Location: In a Private Game (0x" & BufferHex(lTmp2, 2) & ")"
      Case Else
        nList.Add nItem, tvwChild, , "Location: 0x" & BufferHex(lTmp2, 2)
    End Select
    nList.Add nItem, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
    nList.Add nItem, tvwChild, , "Location: " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_FRIENDSPOSITION()
  nList.Add nRoot, tvwChild, , "Old Position: 0x" & BufferHex(SIDPacket.GetByte, 2)
  nList.Add nRoot, tvwChild, , "New Position: 0x" & BufferHex(SIDPacket.GetByte, 2)
End Sub

Private Sub Recv_SID_FRIENDSREMOVE()
  nList.Add nRoot, tvwChild, , "Friend Position: 0x" & BufferHex(SIDPacket.GetByte, 2)
End Sub

Private Sub Recv_SID_FRIENDSUPDATE()
  nList.Add nRoot, tvwChild, , "Friend Position: 0x" & BufferHex(SIDPacket.GetByte, 2)
  nList.Add nRoot, tvwChild, , "Friend Location: 0x" & BufferHex(SIDPacket.GetByte, 2)
  nList.Add nRoot, tvwChild, , "Friend Status: 0x" & BufferHex(SIDPacket.GetByte, 2)
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Location: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_GAMEPLAYERSEARCH()
Dim lTmp As Long
Dim I    As Long
  lTmp = SIDPacket.GetByte
  nList.Add nRoot, tvwChild, , "Number of Players: " & lTmp
  For I = 1 To lTmp
    nList.Add nRoot, tvwChild, , "Player #" & I & ": " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_GETADVLISTEX()
Dim nItem As Node
Dim nItm2 As Node
Dim aTm() As String
Dim lTmp  As Long
Dim I     As Long
Dim J     As Long
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Number of Games: 0x" & BufferHex(lTmp)
  If lTmp = 0 Then
    lTmp = SIDPacket.GetDWORD
    Select Case lTmp
      Case 0
        nList.Add nRoot, tvwChild, , "Status: OK (0x" & BufferHex(lTmp) & ")"
      Case 1
        nList.Add nRoot, tvwChild, , "Status: Game Doesn't Exist (0x" & BufferHex(lTmp) & ")"
      Case 2
        nList.Add nRoot, tvwChild, , "Status: Incorrect Password (0x" & BufferHex(lTmp) & ")"
      Case 3
        nList.Add nRoot, tvwChild, , "Status: Game Full (0x" & BufferHex(lTmp) & ")"
      Case 4
        nList.Add nRoot, tvwChild, , "Status: Game Already Started (0x" & BufferHex(lTmp) & ")"
      Case 6
        nList.Add nRoot, tvwChild, , "Status: Too Many Server Requests (0x" & BufferHex(lTmp) & ")"
      Case Else
        nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
    End Select
  Else
    For I = 1 To lTmp
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Game #" & I
      nList.Add nItem, tvwChild, , "Game Type: 0x" & BufferHex(SIDPacket.GetWORD, 4)
      nList.Add nItem, tvwChild, , "Parameter: 0x" & BufferHex(SIDPacket.GetWORD, 4)
      nList.Add nItem, tvwChild, , "Language: 0x" & BufferHex(SIDPacket.GetDWORD)
      Set nItm2 = nList.Add(nItem, tvwChild)
       nItm2.Text = "sockaddr_in"
       nList.Add nItm2, tvwChild, , "Address Family: 0x" & BufferHex(SIDPacket.GetWORD, 4)
       nList.Add nItm2, tvwChild, , "Port: " & HexToPort(BufferHex(SIDPacket.GetWORD, 4), True)
       'UDPIP
       nList.Add nItm2, tvwChild, , "IP: " & HexToIP(BufferHex(SIDPacket.GetDWORD), True)
       nList.Add nItm2, tvwChild, , "sin_zero: 0x" & BufferHex(SIDPacket.GetDWORD)
       nList.Add nItm2, tvwChild, , "sin_zero: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nItem, tvwChild, , "Game Status: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nItem, tvwChild, , "Elapsed Time: " & SIDPacket.GetDWORD
      nList.Add nItem, tvwChild, , "Game Name: " & SIDPacket.GetNTString
      nList.Add nItem, tvwChild, , "Game Password: " & SIDPacket.GetNTString
      Set nItm2 = nList.Add(nItem, tvwChild)
       nItm2.Text = "Game Details"
       aTm = Split(ParseMapStats(SIDPacket.GetNTString), vbNewLine)
       For J = 0 To UBound(aTm)
         nList.Add nItm2, tvwChild, , aTm(J)
       Next J
    Next I
  End If
End Sub

Private Sub Recv_SID_GETCHANNELLIST()
Dim sTmp As String
  Do
    sTmp = SIDPacket.GetNTString
    If LenB(sTmp) > 0 Then
      nList.Add nRoot, tvwChild, , "Channel: " & sTmp
    Else
      Exit Do
    End If
  Loop
End Sub

Private Sub Recv_SID_GETFILETIME()
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Last Update Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "File Name: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_GETICONDATA()
  nList.Add nRoot, tvwChild, , "File Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "File Name: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_GETLADDERDATA()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Ladder Type: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "League: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Sort Method: Highest Rating (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Sort Method: Fastest Climbers (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Sort Method: Most Wins (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Sort Method: Most Games (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Sort Method: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Starting Rank: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Listed Ranks: 0x" & BufferHex(lTmp)
  For I = 1 To lTmp
    nItem = nList.Add(nRoot, tvwChild)
    nItem.Text = "Item #" & I
    nList.Add nItem, tvwChild, , "Wins: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Losses: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Disconnects: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Rating: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Rank: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Official Wins: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Official Losses: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Official Disconnects: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Official Rating: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Unknown: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Official Rank: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Unknown: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Unknown: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Highest Rating: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Unknown: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Season: " & SIDPacket.GetDWORD
    nList.Add nItem, tvwChild, , "Last Game: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
    nList.Add nItem, tvwChild, , "Official Last Game: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
    nList.Add nItem, tvwChild, , "Account: " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_LOGONCHALLENGE()
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Recv_SID_LOGONCHALLENGEEX()
  nList.Add nRoot, tvwChild, , "UDP Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Recv_SID_LOGONREALMEX()
Dim lTmp  As Long
Dim sTmp  As String
Dim nItem As Node
  nList.Add nRoot, tvwChild, , "MCP Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case &H80000001
      nList.Add nRoot, tvwChild, , "MCP Status: Realm is Unavailable (0x" & BufferHex(lTmp) & ")"
      Exit Sub
    Case &H80000002
      nList.Add nRoot, tvwChild, , "MCP Status: Realm logon failed (0x" & BufferHex(lTmp) & ")"
      Exit Sub
    Case Else
      nList.Add nRoot, tvwChild, , "MCP Status: 0x" & BufferHex(lTmp)
  End Select
  Set nItem = nList.Add(nRoot, tvwChild)
   nItem.Text = "MCP Chunk 1"
   sTmp = HexToIP(BufferHex(SIDPacket.GetDWORD), True)
   MCPIPs.AddIP sTmp
   nList.Add nItem, tvwChild, , "Server IP: " & sTmp
   nList.Add nItem, tvwChild, , "UDP Token: 0x" & BufferHex(SIDPacket.GetDWORD)
   nList.Add nRoot, tvwChild, , "IP: " & HexToIP(BufferHex(SIDPacket.GetDWORD), True)
   nList.Add nRoot, tvwChild, , "Port: " & HexToPort(BufferHex(SIDPacket.GetDWORD, 4), True)
  Set nItem = nList.Add(nRoot, tvwChild)
   nItem.Text = "MCP Chunk 2"
   nList.Add nItem, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetWORD, 4)
   nList.Add nItem, tvwChild, , "Key Product: 0x" & BufferHex(SIDPacket.GetWORD, 4)
   nList.Add nItem, tvwChild, , "Key Public Value: 0x" & BufferHex(SIDPacket.GetDWORD)
   nList.Add nItem, tvwChild, , "Gateway ID: 0x" & BufferHex(SIDPacket.GetDWORD)
   nList.Add nItem, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
   nList.Add nItem, tvwChild, , "Platform ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
   '?
   nList.Add nItem, tvwChild, , "Server IP: " & HexToIP(BufferHex(SIDPacket.GetDWORD), True)
   nList.Add nItem, tvwChild, , "Language ID: 0x" & BufferHex(SIDPacket.GetDWORD)
   nList.Add nItem, tvwChild, , "MCP Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Username: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_LOGONRESPONSE()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Invalid Password (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Success (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_LOGONRESPONSE2()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Success (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Account Does Not Exist (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Status: Invalid Password (0x" & BufferHex(lTmp) & ")"
    Case 6
      nList.Add nRoot, tvwChild, , "Status: Account Closed (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_MESSAGEBOX()
  nList.Add nRoot, tvwChild, , "Style: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Text: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Caption: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_NEWS_INFO()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Long
  lTmp = SIDPacket.GetByte
  nList.Add nRoot, tvwChild, , "Entries: " & lTmp
  nList.Add nRoot, tvwChild, , "Last Logon: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Oldest News: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Newest News: 0x" & BufferHex(SIDPacket.GetDWORD)
  For I = 1 To lTmp
    Set nItem = nList.Add(nRoot, tvwChild)
    nItem.Text = "News Item #" & I
    nList.Add nItem, tvwChild, , "Timestamp: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nItem, tvwChild, , "News: " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_NULL()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Recv_SID_OPTIONALWORK()
  nList.Add nRoot, tvwChild, , "MPQ File Name: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_PING()
  nList.Add nRoot, tvwChild, , "Ping Value: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Recv_SID_PROFILE()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  If SIDPacket.GetByte = 0 Then
    nList.Add nRoot, tvwChild, , "Description: " & SIDPacket.GetNTString
    nList.Add nRoot, tvwChild, , "Location: " & SIDPacket.GetNTString
    nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  End If
End Sub

Private Sub Recv_SID_QUERYADURL()
  nList.Add nRoot, tvwChild, , "Ad ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Ad URL: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_QUERYREALMS()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Count: 0x" & BufferHex(lTmp)
  For I = 1 To lTmp
    Set nItem = nList.Add(nRoot, tvwChild)
    nItem.Text = "Realm #" & I
    nList.Add nItem, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nItem, tvwChild, , "Realm Title: " & SIDPacket.GetNTString
    nList.Add nItem, tvwChild, , "Realm Description: " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_QUERYREALMS2()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Count: 0x" & BufferHex(lTmp)
  For I = 1 To lTmp
    Set nItem = nList.Add(nRoot, tvwChild)
    nItem.Text = "Realm #" & I
    nList.Add nItem, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nItem, tvwChild, , "Realm Title: " & SIDPacket.GetNTString
    nList.Add nItem, tvwChild, , "Realm Description: " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_READUSERDATA()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim I     As Long
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Accounts: 0x" & BufferHex(lTmp)
  lTmp2 = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Keys: 0x" & BufferHex(lTmp2)
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  For I = 1 To lTmp * lTmp2
    nList.Add nRoot, tvwChild, , "Value #" & I & ": " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Recv_SID_REGISTRY()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "HKEY: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Path: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Key: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_REPORTVERSION()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Result: Failed version check (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Result: Old game version (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Result: Success (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Result: Reinstall Required (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Result: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Patch Path: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_REQUIREDWORK()
  nList.Add nRoot, tvwChild, , "MPQ File Name: " & SIDPacket.GetNTString
End Sub

Private Sub Recv_SID_SERVERLIST()
Dim sTmp As String
  nList.Add nRoot, tvwChild, , "Server Version: 0x" & BufferHex(SIDPacket.GetDWORD)
  Do
    sTmp = SIDPacket.GetNTString
    If LenB(sTmp) > 0 Then
      nList.Add nRoot, tvwChild, , "Server: " & sTmp
    Else
      Exit Do
    End If
  Loop
End Sub

Private Sub Recv_SID_SETEMAIL()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Recv_SID_STARTADVEX()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: Fail (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Success (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_STARTADVEX3()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Status: OK (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Status: Failed (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp)
  End Select
End Sub

Private Sub Recv_SID_STARTVERSIONING()
  nList.Add nRoot, tvwChild, , "MPQ File Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MPQ File Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Request String: " & StH(SIDPacket.GetNTString, True)
End Sub

Private Sub Recv_SID_STARTVERSIONING2()
  nList.Add nRoot, tvwChild, , "MPQ File Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MPQ File Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Request String: " & StH(SIDPacket.GetNTString, True)
End Sub

Private Sub Recv_SID_TOURNAMENT()
  nList.Add nRoot, tvwChild, , "Unknown: " & StH(SIDPacket.GetNull, True)
End Sub

Private Sub Recv_SID_WARCRAFTGENERAL()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim lTmp3 As Long
Dim lTmp4 As Long
Dim sTemp As String
Dim sTmp2 As String
Dim pTmp  As clsPacket
Dim nItem As Node
Dim nItm2 As Node
Dim nItm3 As Node
Dim I     As Long
Dim J     As Long
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case &H0
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_GAMESEARCH (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      lTmp2 = SIDPacket.GetByte
      Select Case lTmp2
        Case 0
          nList.Add nRoot, tvwChild, , "Status: Search Started (0x" & BufferHex(lTmp2, 2) & ")"
        Case 4
          nList.Add nRoot, tvwChild, , "Status: Banned CD Key (0x" & BufferHex(lTmp2, 2) & ")"
        Case Else
          nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp2, 2)
      End Select
      nList.Add nRoot, tvwChild, , "Search Time: " & SIDPacket.GetDWORD & " seconds"
      nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetByte, 2)
    Case &H2
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_MAPLIST (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Responses (" & lTmp2 & ")"
      For I = 1 To lTmp2
        Set nItm2 = nList.Add(nItem, tvwChild)
        nItm2.Text = "Response #" & I
        sTmp2 = Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
        nList.Add nItm2, tvwChild, , "Response ID: " & sTmp2
        nList.Add nItm2, tvwChild, , "Checksum: 0x" & BufferHex(SIDPacket.GetDWORD)
        lTmp3 = SIDPacket.GetWORD
        lTmp4 = SIDPacket.GetWORD
        sTemp = Decompress(SIDPacket.GetString(lTmp4), lTmp4, lTmp3)
        If sTemp = "Failed to decompress" Then
          nList.Add nItm2, tvwChild, , sTemp
        Else
          Set pTmp = New clsPacket
          pTmp.SetData sTemp
          Select Case sTmp2
            Case "URL"
              nList.Add nItm2, tvwChild, , "Ladder URL: " & pTmp.GetNTString
              nList.Add nItm2, tvwChild, , "Profile URL: " & pTmp.GetNTString
              nList.Add nItm2, tvwChild, , "Tournament URL: " & pTmp.GetNTString
              nList.Add nItm2, tvwChild, , "Clan URL: " & pTmp.GetNTString
            Case "MAP"
              lTmp3 = pTmp.GetByte
              For J = 1 To lTmp3
                nList.Add nItm2, tvwChild, , "Map #" & J & ": " & pTmp.GetNTString
              Next J
            Case "TYPE"
              nList.Add nItm2, tvwChild, , "Unknown: " & StH(pTmp.GetNull, True)
            Case "DESC"
              lTmp3 = pTmp.GetByte
              For J = 1 To lTmp3
                nList.Add nItm2, tvwChild, , "Group ID: " & pTmp.GetByte
                nList.Add nItm2, tvwChild, , "Game ID: " & pTmp.GetByte
                nList.Add nItm2, tvwChild, , "Name: " & pTmp.GetNTString
                nList.Add nItm2, tvwChild, , "Description: " & pTmp.GetNTString
              Next J
            Case "LADR"
              lTmp3 = pTmp.GetByte
              For J = 1 To lTmp3
                nList.Add nItm2, tvwChild, , "Type: " & Replace$(HtS(BufferHex(pTmp.GetDWORD)), vbNullChar, vbNullString)
                nList.Add nItm2, tvwChild, , "Name: " & pTmp.GetNTString
                nList.Add nItm2, tvwChild, , "Description: " & pTmp.GetNTString
              Next J
            Case Else
              nList.Add nItm2, tvwChild, , "Unknown: " & StH(pTmp.GetNull, True)
          End Select
          Set pTmp = Nothing
        End If
      Next I
      nList.Add nRoot, tvwChild, , "Expecting " & SIDPacket.GetByte & " more WID_MAPLIST(s)."
    Case &H3
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_CANCELSEARCH (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
    Case &H4
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_USERRECORD (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nRoot, tvwChild, , "Icon ID: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Ladder Records (" & lTmp2 & ")"
      If lTmp2 > 0 Then
        For I = 1 To lTmp2
          Set nItm2 = nList.Add(nItem, tvwChild)
          nItm2.Text = "Record #" & I
          nList.Add nItm2, tvwChild, , "Ladder Type: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
          nList.Add nItm2, tvwChild, , "Wins: " & SIDPacket.GetWORD
          nList.Add nItm2, tvwChild, , "Losses: " & SIDPacket.GetWORD
          nList.Add nItm2, tvwChild, , "Level: " & SIDPacket.GetByte
          nList.Add nItm2, tvwChild, , "Unknown: " & SIDPacket.GetByte
          nList.Add nItm2, tvwChild, , "Experience: " & SIDPacket.GetWORD
          nList.Add nItm2, tvwChild, , "Rank: " & SIDPacket.GetDWORD
        Next I
      End If
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Race Records (" & lTmp2 & ")"
      If lTmp2 > 0 Then
        For I = 1 To lTmp2
          Set nItm2 = nList.Add(nItem, tvwChild)
          nItm2.Text = "Record #" & I
          nList.Add nItm2, tvwChild, , "Wins: " & SIDPacket.GetWORD
          nList.Add nItm2, tvwChild, , "Losses: " & SIDPacket.GetWORD
        Next I
      End If
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Team Records (" & lTmp2 & ")"
      If lTmp2 > 0 Then
        For I = 1 To lTmp2
          Set nItm2 = nList.Add(nItem, tvwChild)
          nItm2.Text = "Record #" & I
          nList.Add nItm2, tvwChild, , "Ladder Type: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
          nList.Add nItm2, tvwChild, , "Wins: " & SIDPacket.GetWORD
          nList.Add nItm2, tvwChild, , "Losses: " & SIDPacket.GetWORD
          nList.Add nItm2, tvwChild, , "Level: " & SIDPacket.GetByte
          nList.Add nItm2, tvwChild, , "Unknown: " & SIDPacket.GetByte
          nList.Add nItm2, tvwChild, , "Experience: " & SIDPacket.GetWORD
          nList.Add nItm2, tvwChild, , "Rank: " & SIDPacket.GetDWORD
          nList.Add nItm2, tvwChild, , "Last Game: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
          lTmp3 = SIDPacket.GetByte
          Set nItm3 = nList.Add(nItm2, tvwChild)
          nItm3.Text = "Partners (" & lTmp3 & ")"
          For J = 1 To lTmp3
            nList.Add nItm3, tvwChild, , "Partner #" & J & ": " & SIDPacket.GetNTString
          Next J
        Next I
      End If
    Case &H7
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_TOURNAMENT (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      lTmp2 = SIDPacket.GetByte
      Select Case lTmp2
        Case 0
          nList.Add nRoot, tvwChild, , "Status: Not Available (0x" & BufferHex(lTmp2, 2) & ")"
          nList.Add nRoot, tvwChild, , "Unknown: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
        Case 1
          nList.Add nRoot, tvwChild, , "Status: Starting (0x" & BufferHex(lTmp2, 2) & ")"
          nList.Add nRoot, tvwChild, , "Signup starts: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
        Case 2
          nList.Add nRoot, tvwChild, , "Status: Ending (0x" & BufferHex(lTmp2, 2) & ")"
          nList.Add nRoot, tvwChild, , "Signup ends: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
        Case 3
          nList.Add nRoot, tvwChild, , "Status: Started (0x" & BufferHex(lTmp2, 2) & ")"
          nList.Add nRoot, tvwChild, , "Last call: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
        Case 4
          nList.Add nRoot, tvwChild, , "Status: Last Call (0x" & BufferHex(lTmp2, 2) & ")"
          nList.Add nRoot, tvwChild, , "Ending: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
        Case Else
          nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(lTmp2, 2)
          nList.Add nRoot, tvwChild, , "Unknown: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
      End Select
      nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetWORD, 4)
      nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetWORD, 4)
      nList.Add nRoot, tvwChild, , "Wins: " & SIDPacket.GetByte
      nList.Add nRoot, tvwChild, , "Losses: " & SIDPacket.GetByte
      nList.Add nRoot, tvwChild, , "Draws: " & SIDPacket.GetByte
      nList.Add nRoot, tvwChild, , "Unknown: " & SIDPacket.GetByte
      nList.Add nRoot, tvwChild, , "Unknown: " & SIDPacket.GetByte
      nList.Add nRoot, tvwChild, , "Unknown: " & SIDPacket.GetByte
      nList.Add nRoot, tvwChild, , "Unknown: " & SIDPacket.GetByte
    Case &H8
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_CLANRECORD (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Ladder Records (" & lTmp2 & ")"
      For I = 1 To lTmp2
        Set nItm2 = nList.Add(nItem, tvwChild)
        nItm2.Text = "Record #" & I
        nList.Add nItm2, tvwChild, , "Ladder Type: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
        nList.Add nItm2, tvwChild, , "Wins: " & SIDPacket.GetWORD
        nList.Add nItm2, tvwChild, , "Losses: " & SIDPacket.GetWORD
        nList.Add nItm2, tvwChild, , "Level: " & SIDPacket.GetByte
        nList.Add nItm2, tvwChild, , "Unknown: " & SIDPacket.GetByte
        nList.Add nItm2, tvwChild, , "Experience: " & SIDPacket.GetWORD
        nList.Add nItm2, tvwChild, , "Rank: " & SIDPacket.GetDWORD
      Next I
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Race Records (" & lTmp2 & ")"
      For I = 1 To lTmp2
        nItm2 = nList.Add(nItem, tvwChild)
        nItm2.Text = "Record #" & I
        nList.Add nItm2, tvwChild, , "Wins: " & SIDPacket.GetWORD
        nList.Add nItm2, tvwChild, , "Losses: " & SIDPacket.GetWORD
      Next I
    Case &H9
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_ICONLIST (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nRoot, tvwChild, , "Tiers: " & SIDPacket.GetByte
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Icons (" & lTmp2 & ")"
      For I = 1 To lTmp2
        Set nItm2 = nList.Add(nItem, tvwChild)
        nItm2.Text = "Icon #" & I
        nList.Add nItm2, tvwChild, , "Icon: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
        nList.Add nItm2, tvwChild, , "Name: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
        nList.Add nItm2, tvwChild, , "Race: 0x" & BufferHex(SIDPacket.GetByte, 2)
        nList.Add nItm2, tvwChild, , "Required Wins: " & SIDPacket.GetWORD
        nList.Add nItm2, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetByte, 2)
      Next I
    Case Else
      nList.Add nRoot, tvwChild, , "Subcommand ID: 0x" & BufferHex(lTmp, 2)
      nList.Add nRoot, tvwChild, , "Unknown Data: " & StH(SIDPacket.GetNull, True)
  End Select
End Sub

Private Sub Recv_SID_WARDEN()
  nList.Add nRoot, tvwChild, , "Encrypted Data: " & StH(SIDPacket.GetNull, True)
End Sub

Private Sub Send_BNLS_AUTHORIZE()
  nList.Add nRoot, tvwChild, , "Bot ID: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_AUTHORIZEPROOF()
  nList.Add nRoot, tvwChild, , "Checksum: 0x" & BufferHex(BNLSPacket.GetDWORD)
End Sub

Private Sub Send_BNLS_CDKEY()
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "CD Key: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_CDKEY_EX()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim sTmp  As String
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
  lTmp = BNLSPacket.GetByte
  nList.Add nRoot, tvwChild, , "Keys: " & lTmp
  lTmp2 = BNLSPacket.GetDWORD
  sTmp = vbNullString
  If lTmp2 And &H1 Then sTmp = sTmp & "SAME_SESSION_KEY "
  If lTmp2 And &H2 Then sTmp = sTmp & "GIVEN_SESSION_KEY "
  If lTmp2 And &H4 Then sTmp = sTmp & "MULTI_SERVER_SESSION_KEYS "
  If lTmp2 And &H8 Then sTmp = sTmp & "OLD_STYLE_RESPONSES "
  nList.Add nRoot, tvwChild, , "Flags: " & Trim$(sTmp)
  If lTmp2 And &H4 Then
    For I = 1 To lTmp
      nList.Add nRoot, tvwChild, , "Key #" & I & " Server Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
    Next I
  Else
    nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
  End If
  If lTmp2 And &H2 Then
    If lTmp2 And &H1 Then
      nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
    Else
      For I = 1 To lTmp
        nList.Add nRoot, tvwChild, , "Key #" & I & " Client Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
      Next I
    End If
  End If
  For I = 1 To lTmp
    nList.Add nRoot, tvwChild, , "Key #" & I & ": " & BNLSPacket.GetNTString
  Next I
End Sub

Private Sub Send_BNLS_CHANGECHALLENGE()
  nList.Add nRoot, tvwChild, , "Account: " & BNLSPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Old Password: " & BNLSPacket.GetNTString
  nList.Add nRoot, tvwChild, , "New Password: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_CHANGEPROOF()
  nList.Add nRoot, tvwChild, , "Salt: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Server Key: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Send_BNLS_CHOOSENLSREVISION()
  nList.Add nRoot, tvwChild, , "NLS Version: 0x" & BufferHex(BNLSPacket.GetDWORD)
End Sub

Private Sub Send_BNLS_CONFIRMLOGON()
  nList.Add nRoot, tvwChild, , "Server Password Proof: " & StH(BNLSPacket.GetString(20), True)
End Sub

Private Sub Send_BNLS_CREATEACCOUNT()
  nList.Add nRoot, tvwChild, , "Account: " & BNLSPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Password: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_HASHDATA()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Data Size: 0x" & BufferHex(lTmp)
  nList.Add nRoot, tvwChild, , "Flags: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Data: " & StH(BNLSPacket.GetString(lTmp), True)
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
End Sub

Private Sub Send_BNLS_LOGONCHALLENGE()
  nList.Add nRoot, tvwChild, , "Account: " & BNLSPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Password: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_LOGONPROOF()
  nList.Add nRoot, tvwChild, , "Salt: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Server Key: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Send_BNLS_NULL()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_BNLS_REQUESTVERSIONBYTE()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Product ID: " & GetBNLSProduct(lTmp) & " (0x" & BufferHex(lTmp) & ")"
End Sub

Private Sub Send_BNLS_RESERVESERVERSLOTS()
  nList.Add nRoot, tvwChild, , "Slots to Reserve: " & BNLSPacket.GetDWORD
End Sub

Private Sub Send_BNLS_SERVERLOGONCHALLENGE()
  nList.Add nRoot, tvwChild, , "Slot Index: " & BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "NLS Version: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Salt: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Verifier: " & StH(BNLSPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Client Key: " & StH(BNLSPacket.GetString(32), True)
End Sub

Private Sub Send_BNLS_SERVERLOGONPROOF()
  nList.Add nRoot, tvwChild, , "Slot Index: " & BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Server Password Proof: " & StH(BNLSPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Account: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_UPGRADECHALLENGE()
  nList.Add nRoot, tvwChild, , "Account: " & BNLSPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Old Password: " & BNLSPacket.GetNTString
  nList.Add nRoot, tvwChild, , "New Password: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_UPGRADEPROOF()
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(BNLSPacket.GetDWORD)
End Sub

Private Sub Send_BNLS_VERIFYSERVER()
  nList.Add nRoot, tvwChild, , "Server IP: " & HexToIP(BufferHex(BNLSPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Signature: " & StH(BNLSPacket.GetString(128), True)
End Sub

Private Sub Send_BNLS_VERSIONCHECK()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Product ID: " & GetBNLSProduct(lTmp) & " (0x" & BufferHex(lTmp) & ")"
  nList.Add nRoot, tvwChild, , "Version DLL: " & BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Request String: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_VERSIONCHECKEX()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Product ID: " & GetBNLSProduct(lTmp) & " (0x" & BufferHex(lTmp) & ")"
  nList.Add nRoot, tvwChild, , "Version DLL: " & BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Flags: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Request String: " & BNLSPacket.GetNTString
End Sub

Private Sub Send_BNLS_VERSIONCHECKEX2()
Dim lTmp As Long
  lTmp = BNLSPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Product ID: " & GetBNLSProduct(lTmp) & " (0x" & BufferHex(lTmp) & ")"
  nList.Add nRoot, tvwChild, , "Flags: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MPQ File Time: " & GetFTTime(BNLSPacket.GetDWORD, BNLSPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MPQ File Name: " & BNLSPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Request String: " & StH(BNLSPacket.GetNTString, True)
End Sub

Private Sub Send_MCP_CANCELGAMECREATE()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_MCP_CHARCREATE()
Dim lTmp As Long
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Class: Amazon (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Class: Sorceress (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Class: Necromancer (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Class: Paladin (0x" & BufferHex(lTmp) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Class: Barbarian (0x" & BufferHex(lTmp) & ")"
    Case 5
      nList.Add nRoot, tvwChild, , "Class: Druid (0x" & BufferHex(lTmp) & ")"
    Case 6
      nList.Add nRoot, tvwChild, , "Class: Assassin (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Class: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Flags: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Character Name: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_CHARDELETE()
  nList.Add nRoot, tvwChild, , "Unknown: " & MCPPacket.GetWORD
  nList.Add nRoot, tvwChild, , "Character Name: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_CHARLIST()
  nList.Add nRoot, tvwChild, , "Characters to List: " & MCPPacket.GetDWORD
End Sub

Private Sub Send_MCP_CHARLIST2()
  nList.Add nRoot, tvwChild, , "Characters to List: " & MCPPacket.GetDWORD
End Sub

Private Sub Send_MCP_CHARLOGON()
  nList.Add nRoot, tvwChild, , "Character Name: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_CHARUPGRADE()
  nList.Add nRoot, tvwChild, , "Character: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_CREATEGAME()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  lTmp = MCPPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Difficulty: Normal (0x" & BufferHex(lTmp) & ")"
    Case &H1000
      nList.Add nRoot, tvwChild, , "Difficulty: Nightmare (0x" & BufferHex(lTmp) & ")"
    Case &H2000
      nList.Add nRoot, tvwChild, , "Difficulty: Hell (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Difficulty: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetByte, 2)
  nList.Add nRoot, tvwChild, , "Player Difference: " & MCPPacket.GetByte
  nList.Add nRoot, tvwChild, , "Maximum Players: " & MCPPacket.GetByte
  nList.Add nRoot, tvwChild, , "Game Name: " & MCPPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Password: " & MCPPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Description: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_GAMEINFO()
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Game Name: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_GAMELIST()
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Search String: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_JOINGAME()
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(MCPPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Game Name: " & MCPPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Password: " & MCPPacket.GetNTString
End Sub

Private Sub Send_MCP_MOTD()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_MCP_REQUESTLADDERDATA()
Dim lTmp As Long
  lTmp = MCPPacket.GetByte
  Select Case lTmp
    Case &H0
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H2
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H3
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H4
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Paladin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H5
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Hardcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H9
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HA
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HB
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HC
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HD
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Paladin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &HE
      nList.Add nRoot, tvwChild, , "Ladder Type: Standard Softcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H13
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H14
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H15
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H16
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H17
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Palanin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H18
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H19
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Druid Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1A
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Hardcore Assassin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1B
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Overall Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1C
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Amazon Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1D
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Sorceress Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1E
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Necromancer Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H1F
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Paladin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H20
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Barbarian Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H21
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Druid Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case &H22
      nList.Add nRoot, tvwChild, , "Ladder Type: Expansion Softcore Assassin Ladder (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Ladder Type: 0x" & BufferHex(lTmp, 2)
  End Select
  nList.Add nRoot, tvwChild, , "Starting Position: " & MCPPacket.GetWORD
End Sub

Private Sub Send_MCP_STARTUP()
Dim nItem As Node
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(MCPPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Status: 0x" & BufferHex(MCPPacket.GetDWORD)
  Set nItem = nList.Add(nRoot, tvwChild)
   nItem.Text = "MCP Chunk 1"
   nList.Add nItem, tvwChild, , "Server IP: " & HexToIP(BufferHex(MCPPacket.GetDWORD), True)
   nList.Add nItem, tvwChild, , "UDP Token: 0x" & BufferHex(MCPPacket.GetDWORD)
  Set nItem = nList.Add(nRoot, tvwChild)
   nItem.Text = "MCP Chunk 2"
   nList.Add nItem, tvwChild, , "Unknown: 0x" & BufferHex(MCPPacket.GetWORD, 4)
   nList.Add nItem, tvwChild, , "Key Product: 0x" & BufferHex(MCPPacket.GetWORD, 4)
   nList.Add nItem, tvwChild, , "Key Public Value: 0x" & BufferHex(MCPPacket.GetDWORD)
   nList.Add nItem, tvwChild, , "Gateway ID: 0x" & BufferHex(MCPPacket.GetDWORD)
   nList.Add nItem, tvwChild, , "Product ID: " & HtS(BufferHex(MCPPacket.GetDWORD))
   nList.Add nItem, tvwChild, , "Platform ID: " & HtS(BufferHex(MCPPacket.GetDWORD))
   nList.Add nItem, tvwChild, , "Server IP: " & HexToIP(BufferHex(MCPPacket.GetDWORD), True)
   nList.Add nItem, tvwChild, , "Language ID: 0x" & BufferHex(MCPPacket.GetDWORD)
   nList.Add nItem, tvwChild, , "MCP Hash: " & StH(MCPPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Account Name: " & MCPPacket.GetNTString
End Sub

Private Sub Send_SID_AUTH_ACCOUNTCHANGE()
  nList.Add nRoot, tvwChild, , "Client Key: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_AUTH_ACCOUNTCHANGEPROOF()
  nList.Add nRoot, tvwChild, , "Old Password Proof: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "New Salt: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "New Verifier: " & StH(SIDPacket.GetString(32), True)
End Sub

Private Sub Send_SID_AUTH_ACCOUNTCREATE()
  nList.Add nRoot, tvwChild, , "Salt: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Verifier: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_AUTH_ACCOUNTLOGON()
  nList.Add nRoot, tvwChild, , "Client Key: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_AUTH_ACCOUNTLOGONPROOF()
  nList.Add nRoot, tvwChild, , "Client Password Proof: " & StH(SIDPacket.GetString(20), True)
End Sub

Private Sub Send_SID_AUTH_ACCOUNTUPGRADE()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_AUTH_ACCOUNTUPGRADEPROOF()
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Old Password Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "New Password Salt: " & StH(SIDPacket.GetString(32), True)
  nList.Add nRoot, tvwChild, , "New Password Verifier: " & StH(SIDPacket.GetString(32), True)
End Sub

Private Sub Send_SID_AUTH_CHECK()
Dim lTmp  As Long
Dim nItem As Node
Dim nItm2 As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "EXE Version: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "EXE Hash: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Spawn: 0x" & BufferHex(SIDPacket.GetDWORD)
  Set nItem = nList.Add(nRoot, tvwChild)
  nItem.Text = "CDKeys (" & lTmp & ")"
  For I = 1 To lTmp
    Set nItm2 = nList.Add(nItem, tvwChild)
    nItm2.Text = "CD Key #" & I
    nList.Add nItm2, tvwChild, , "Key Length: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nItm2, tvwChild, , "Key Product: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nItm2, tvwChild, , "Key Public Value: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nItm2, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nItm2, tvwChild, , "Key Hash: " & StH(SIDPacket.GetString(20), True)
  Next I
  nList.Add nRoot, tvwChild, , "EXE Information: " & StH(SIDPacket.GetNTString, True)
  nList.Add nRoot, tvwChild, , "Owner: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_AUTH_INFO()
  nList.Add nRoot, tvwChild, , "Protocol ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Platform ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Version Byte: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Product Language: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  nList.Add nRoot, tvwChild, , "Local IP: " & HexToIP(BufferHex(SIDPacket.GetDWORD), True)
  nList.Add nRoot, tvwChild, , "Time Zone Bias: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Locale ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Language ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Country Abbreviation: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Country: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CDKEY()
  nList.Add nRoot, tvwChild, , "Spawn: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "CD Key: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Owner: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CDKEY2()
  nList.Add nRoot, tvwChild, , "Spawn: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Length: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Product: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Public Value: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Cliet Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Owner: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CHANGEEMAIL()
  nList.Add nRoot, tvwChild, , "Account Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Old E-Mail Address: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "New E-Mail Address: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CHANGEPASSWORD()
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Old Password: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "New Password: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CHATCOMMAND()
  nList.Add nRoot, tvwChild, , "Text: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CHECKAD()
  nList.Add nRoot, tvwChild, , "Platform ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Last Banner ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Current Time: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_CHECKDATAFILE()
  nList.Add nRoot, tvwChild, , "File Checksum: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "File Name: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CHECKDATAFILE2()
  nList.Add nRoot, tvwChild, , "File Size: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "File Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "File Name: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CLANCREATIONINVITATION()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  nList.Add nRoot, tvwChild, , "Inviter: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Status: " & SIDPacket.GetByte
End Sub

Private Sub Send_SID_CLANDISBAND()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_CLANFINDCANDIDATES()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
End Sub

Private Sub Send_SID_CLANINVITATION()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CLANINVITATIONRESPONSE()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  nList.Add nRoot, tvwChild, , "Inviter: " & SIDPacket.GetNTString
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 4
      nList.Add nRoot, tvwChild, , "Response: Decline (0x" & BufferHex(lTmp, 2) & ")"
    Case 6
      nList.Add nRoot, tvwChild, , "Response: Accept (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Response: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Send_SID_CLANINVITEMULTIPLE()
Dim lTmp  As Long
Dim nItem As Node
Dim I     As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Clan Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  lTmp = SIDPacket.GetByte
  Set nItem = nList.Add(nRoot, tvwChild)
  nItem.Text = "Clan Users (" & lTmp & ")"
  For I = 1 To lTmp
    nList.Add nItem, tvwChild, , "Account #" & I & ": " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Send_SID_CLANMAKECHIEFTAIN()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "New Chieftain: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CLANMEMBERINFORMATION()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CLANMEMBERLIST()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_CLANMOTD()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_CLANRANKCHANGE()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case 1
      nList.Add nRoot, tvwChild, , "New Rank: Peon (0x" & BufferHex(lTmp, 2) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "New Rank: Grunt (0x" & BufferHex(lTmp, 2) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "New Rank: Shaman (0x" & BufferHex(lTmp, 2) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "New Rank: 0x" & BufferHex(lTmp, 2)
  End Select
End Sub

Private Sub Send_SID_CLANREMOVEMEMBER()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CLANSETMOTD()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "MOTD: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CLICKAD()
  nList.Add nRoot, tvwChild, , "Ad ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Request Type: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_CLIENTID()
  nList.Add nRoot, tvwChild, , "Registration Version: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Registration Authority: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Account Number: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Registration Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "LAN Computer Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "LAN User Name: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CLIENTID2()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Server Version: 0x" & BufferHex(lTmp)
  If lTmp = 0 Then
    nList.Add nRoot, tvwChild, , "Registration Authority: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Registration Version: 0x" & BufferHex(SIDPacket.GetDWORD)
  Else
    nList.Add nRoot, tvwChild, , "Registration Version: 0x" & BufferHex(SIDPacket.GetDWORD)
    nList.Add nRoot, tvwChild, , "Registration Authority: 0x" & BufferHex(SIDPacket.GetDWORD)
  End If
  nList.Add nRoot, tvwChild, , "Account Number: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Registration Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "LAN Computer Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "LAN User Name: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CREATEACCOUNT()
  nList.Add nRoot, tvwChild, , "Password Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_CREATEACCOUNT2()
  nList.Add nRoot, tvwChild, , "Password Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_DISPLAYAD()
  nList.Add nRoot, tvwChild, , "Platform ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Ad ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "File Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "URL: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_ENTERCHAT()
  nList.Add nRoot, tvwChild, , "Username: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Statstring: " & ParseStatString(SIDPacket.GetNTString)
End Sub

Private Sub Send_SID_EXTRAWORK()
Dim lTmp As Long
  lTmp = SIDPacket.GetWORD
  Select Case lTmp
    Case 1
      nList.Add nRoot, tvwChild, , "Game Type: Diablo II (0x" & BufferHex(lTmp, 4) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Game Type: Warcraft III (0x" & BufferHex(lTmp, 4) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Game Type: Starcraft (0x" & BufferHex(lTmp, 4) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Game Type: World of Warcraft (0x" & BufferHex(lTmp, 4) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Game Type: 0x" & BufferHex(lTmp, 4)
  End Select
  nList.Add nRoot, tvwChild, , "Length: 0x" & BufferHex(SIDPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Returned Data: " & StH(SIDPacket.GetNTString, True)
End Sub

Private Sub Send_SID_FINDLADDERUSER()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "League: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Sort Method: Highest Rating (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Sort Method: Fastest Climbers (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Sort Method: Most Wins (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Sort Method: Most Games (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Sort Method: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_FRIENDSLIST()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_FRIENDSUPDATE()
  nList.Add nRoot, tvwChild, , "List Index: 0x" & BufferHex(SIDPacket.GetByte, 2)
End Sub

Private Sub Send_SID_GAMEDATAADDRESS()
  nList.Add nRoot, tvwChild, , "Address Family: 0x" & BufferHex(SIDPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Port: " & HexToPort(BufferHex(SIDPacket.GetWORD, 4), True)
  nList.Add nRoot, tvwChild, , "IP: " & HexToIP(BufferHex(SIDPacket.GetDWORD), True)
  nList.Add nRoot, tvwChild, , "sin_zero: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "sin_zero: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_GAMEPLAYERSEARCH()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_GAMERESULT()
Dim I As Long
  nList.Add nRoot, tvwChild, , "Game Type: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Players: 0x" & BufferHex(SIDPacket.GetDWORD)
  For I = 1 To 8
    nList.Add nRoot, tvwChild, , "Result (" & I & "): 0x" & BufferHex(SIDPacket.GetDWORD)
  Next I
  For I = 1 To 8
    nList.Add nRoot, tvwChild, , "Player (" & I & "): " & SIDPacket.GetNTString
  Next I
  nList.Add nRoot, tvwChild, , "Map: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Score: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_GETADVLISTEX()
  nList.Add nRoot, tvwChild, , "Product-Specific 1: 0x" & BufferHex(SIDPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Product-Specific 2: 0x" & BufferHex(SIDPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Product-Specific 3: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Product-Specific 4: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Request Count: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Game Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Password: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Statstring: " & ParseMapStats(SIDPacket.GetNTString)
End Sub

Private Sub Send_SID_GETCHANNELLIST()
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
End Sub

Private Sub Send_SID_GETFILETIME()
  nList.Add nRoot, tvwChild, , "Request ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "File Name: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_GETICONDATA()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_GETLADDERDATA()
Dim lTmp As Long
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "League: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Sort Method: Highest Rating (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Sort Method: Fastest Climbers (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Sort Method: Most Wins (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Sort Method: Most Games (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Sort Method: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Starting Rank: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Listed Ranks: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_JOINCHANNEL()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Flags: NoCreate (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Flags: First (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "Flags: Forced (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Flags: D2 First (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Flags: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Channel: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_LEAVECHAT()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_LEAVEGAME()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_LOCALEINFO()
  nList.Add nRoot, tvwChild, , "System Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Local Time: " & GetFTTime(SIDPacket.GetDWORD, SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Timezone Bias: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "System LCID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "User LCID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "User Lang ID: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Abbreviated Language: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Country: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Abbreviated Country: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Country (English): " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_LOGONREALMEX()
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Realm Password Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Realm Name: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_LOGONRESPONSE()
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Password Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_LOGONRESPONSE2()
  nList.Add nRoot, tvwChild, , "Client Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Server Token: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Password Hash: " & StH(SIDPacket.GetString(20), True)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_NETGAMEPORT()
  nList.Add nRoot, tvwChild, , "Port: " & HexToPort(BufferHex(SIDPacket.GetWORD, 4))
End Sub

Private Sub Send_SID_NEWS_INFO()
  nList.Add nRoot, tvwChild, , "News Timestamp: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_NOTIFYJOIN()
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Product Version: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Game Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Password: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_NULL()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_PING()
  nList.Add nRoot, tvwChild, , "Ping Value: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_PROFILE()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_QUERYADURL()
  nList.Add nRoot, tvwChild, , "Ad ID: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_QUERYREALMS()
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_QUERYREALMS2()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_READUSERDATA()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim I     As Long
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Accounts: 0x" & BufferHex(lTmp)
  lTmp2 = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Keys: 0x" & BufferHex(lTmp2)
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  For I = 1 To lTmp
    nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
  Next I
  For I = 1 To lTmp2
    nList.Add nRoot, tvwChild, , "Key: " & SIDPacket.GetNTString
  Next I
End Sub

Private Sub Send_SID_REGISTRY()
  nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Key Value: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_REPORTVERSION()
  nList.Add nRoot, tvwChild, , "Platform ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Version Byte: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "EXE Version: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "EXE Hash: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "EXE Information: " & StH(SIDPacket.GetNTString, True)
End Sub

Private Sub Send_SID_RESETPASSWORD()
  nList.Add nRoot, tvwChild, , "Account Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "E-Mail Address: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_SETEMAIL()
  nList.Add nRoot, tvwChild, , "E-Mail Address: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_SID_STARTADVEX()
  nList.Add nRoot, tvwChild, , "Password Protected: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Port: " & HexToPort(BufferHex(SIDPacket.GetDWORD, 4), True)
  nList.Add nRoot, tvwChild, , "Game Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Password: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Statstring: " & ParseMapStats(SIDPacket.GetNTString)
  nList.Add nRoot, tvwChild, , "Map Name: " & SIDPacket.GetNTString
End Sub

Private Sub Send_SID_STARTADVEX2()
  nList.Add nRoot, tvwChild, , "Password Protected: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Port: " & HexToPort(BufferHex(SIDPacket.GetDWORD, 4), True)
  nList.Add nRoot, tvwChild, , "Game Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Password: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Unknown: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Statstring: " & ParseMapStats(SIDPacket.GetNTString)
End Sub

Private Sub Send_SID_STARTADVEX3()
Dim lTmp As Long
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 1
      nList.Add nRoot, tvwChild, , "State: Private (0x" & BufferHex(lTmp) & ")"
    Case 2
      nList.Add nRoot, tvwChild, , "State: Full (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "State: Contains Players (0x" & BufferHex(lTmp) & ")"
    Case 8
      nList.Add nRoot, tvwChild, , "State: In Progress (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "State: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Time Since Creation: " & SIDPacket.GetDWORD
  lTmp = SIDPacket.GetWORD
  Select Case lTmp
    Case 2
      nList.Add nRoot, tvwChild, , "Type: Melee (0x" & BufferHex(lTmp, 4) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Type: Free for All (0x" & BufferHex(lTmp, 4) & ")"
    Case 4
      nList.Add nRoot, tvwChild, , "Type: 1 vs 1 (0x" & BufferHex(lTmp, 4) & ")"
    Case 9
      nList.Add nRoot, tvwChild, , "Type: Ladder (0x" & BufferHex(lTmp, 4) & ")"
    Case &HA
      nList.Add nRoot, tvwChild, , "Type: Use Map Settings (0x" & BufferHex(lTmp, 4) & ")"
    Case &HF
      nList.Add nRoot, tvwChild, , "Type: Top vs Bottom (0x" & BufferHex(lTmp, 4) & ")"
    Case &H10
      nList.Add nRoot, tvwChild, , "Type: Iron Man Ladder (0x" & BufferHex(lTmp, 4) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Type: 0x" & BufferHex(lTmp, 4)
  End Select
  nList.Add nRoot, tvwChild, , "Parameter: 0x" & BufferHex(SIDPacket.GetWORD, 4)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
  lTmp = SIDPacket.GetDWORD
  Select Case lTmp
    Case 0
      nList.Add nRoot, tvwChild, , "Ladder: No (0x" & BufferHex(lTmp) & ")"
    Case 1
      nList.Add nRoot, tvwChild, , "Ladder: Yes (0x" & BufferHex(lTmp) & ")"
    Case 3
      nList.Add nRoot, tvwChild, , "Ladder: IronMan (0x" & BufferHex(lTmp) & ")"
    Case Else
      nList.Add nRoot, tvwChild, , "Ladder: 0x" & BufferHex(lTmp)
  End Select
  nList.Add nRoot, tvwChild, , "Game Name: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Password: " & SIDPacket.GetNTString
  nList.Add nRoot, tvwChild, , "Game Statstring: " & ParseMapStats(SIDPacket.GetNTString)
End Sub

Private Sub Send_SID_STARTVERSIONING()
  nList.Add nRoot, tvwChild, , "Platform ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
  nList.Add nRoot, tvwChild, , "Version Byte: 0x" & BufferHex(SIDPacket.GetDWORD)
  nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_STOPADV()
  'nList.Add nRoot, tvwChild, , "[NULL]"
End Sub

Private Sub Send_SID_SWITCHPRODUCT()
  nList.Add nRoot, tvwChild, , "Product ID: " & HtS(BufferHex(SIDPacket.GetDWORD))
End Sub

Private Sub Send_SID_SYSTEMINFO()
  nList.Add nRoot, tvwChild, , "Processors: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Architecture: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Level: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Timing: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "RAM: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Page File: " & SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Free Space: " & SIDPacket.GetDWORD
End Sub

Private Sub Send_SID_UDPPINGRESPONSE()
  nList.Add nRoot, tvwChild, , "UDP Token: 0x" & BufferHex(SIDPacket.GetDWORD)
End Sub

Private Sub Send_SID_WARCRAFTGENERAL()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim nItem As Node
Dim I     As Long
  lTmp = SIDPacket.GetByte
  Select Case lTmp
    Case &H0
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_GAMESEARCH (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetByte, 2)
      lTmp2 = SIDPacket.GetByte
      Select Case lTmp2
        Case 0
          nList.Add nRoot, tvwChild, , "Type: 1 vs 1 (0x" & BufferHex(lTmp2, 2) & ")"
        Case 1
          nList.Add nRoot, tvwChild, , "Type: 2 vs 2 (0x" & BufferHex(lTmp2, 2) & ")"
        Case 2
          nList.Add nRoot, tvwChild, , "Type: 3 vs 3 (0x" & BufferHex(lTmp2, 2) & ")"
        Case 3
          nList.Add nRoot, tvwChild, , "Type: 4 vs 4 (0x" & BufferHex(lTmp2, 2) & ")"
        Case 4
          nList.Add nRoot, tvwChild, , "Type: Free for All (0x" & BufferHex(lTmp2, 2) & ")"
        Case Else
          nList.Add nRoot, tvwChild, , "Type: 0x" & BufferHex(lTmp2, 2)
      End Select
      nList.Add nRoot, tvwChild, , "Enabled Maps: 0x" & BufferHex(SIDPacket.GetWORD, 4)
      nList.Add nRoot, tvwChild, , "Unknown: 0x" & BufferHex(SIDPacket.GetWORD, 4)
      nList.Add nRoot, tvwChild, , "Unknown: " & SIDPacket.GetByte
      nList.Add nRoot, tvwChild, , "TickCount: 0x" & BufferHex(SIDPacket.GetDWORD)
      lTmp2 = SIDPacket.GetDWORD
      Select Case lTmp2
        Case 1
          nList.Add nRoot, tvwChild, , "Race: Human (0x" & BufferHex(lTmp2, 2) & ")"
        Case 2
          nList.Add nRoot, tvwChild, , "Race: Orc (0x" & BufferHex(lTmp2, 2) & ")"
        Case 4
          nList.Add nRoot, tvwChild, , "Race: Night Elf (0x" & BufferHex(lTmp2, 2) & ")"
        Case 8
          nList.Add nRoot, tvwChild, , "Race: Undead (0x" & BufferHex(lTmp2, 2) & ")"
        Case &H20
          nList.Add nRoot, tvwChild, , "Race: Random (0x" & BufferHex(lTmp2, 2) & ")"
        Case Else
          nList.Add nRoot, tvwChild, , "Race: 0x" & BufferHex(lTmp2, 2)
      End Select
    Case &H2
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_MAPLIST (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      lTmp2 = SIDPacket.GetByte
      Set nItem = nList.Add(nRoot, tvwChild)
      nItem.Text = "Requests (" & lTmp2 & ")"
      For I = 1 To lTmp2
        nList.Add nItem, tvwChild, , "Request ID #" & I & ": " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
        nList.Add nItem, tvwChild, , "Checksum: 0x" & BufferHex(SIDPacket.GetDWORD)
      Next I
    Case &H3
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_CANCELSEARCH (0x" & BufferHex(lTmp, 2) & ")"
      'nList.Add nRoot, tvwChild, , "[NULL]"
    Case &H4
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_USERRECORD (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
      nList.Add nRoot, tvwChild, , "Product: " & HtS(BufferHex(SIDPacket.GetDWORD))
    Case &H7
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_TOURNAMENT (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
    Case &H8
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_CLANRECORD (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
      nList.Add nRoot, tvwChild, , "Clan Tag: " & Replace$(HtS(BufferHex(SIDPacket.GetDWORD)), vbNullChar, vbNullString)
      nList.Add nRoot, tvwChild, , "Product: " & HtS(BufferHex(SIDPacket.GetDWORD))
    Case &H9
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_ICONLIST (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Cookie: 0x" & BufferHex(SIDPacket.GetDWORD)
    Case &HA
      nList.Add nRoot, tvwChild, , "Subcommand ID: WID_SETICON (0x" & BufferHex(lTmp, 2) & ")"
      nList.Add nRoot, tvwChild, , "Icon: 0x" & BufferHex(SIDPacket.GetDWORD)
    Case Else
      nList.Add nRoot, tvwChild, , "Subcommand ID: 0x" & BufferHex(lTmp, 2)
      nList.Add nRoot, tvwChild, , "Unknown Data: " & StH(SIDPacket.GetNull, True)
  End Select
End Sub

Private Sub Send_SID_WARDEN()
  nList.Add nRoot, tvwChild, , "Encrypted Data: " & StH(SIDPacket.GetNull, True)
End Sub

Private Sub Send_SID_WRITEUSERDATA()
Dim lTmp  As Long
Dim lTmp2 As Long
Dim I     As Long
  lTmp = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Accounts: 0x" & BufferHex(lTmp)
  lTmp2 = SIDPacket.GetDWORD
  nList.Add nRoot, tvwChild, , "Keys: 0x" & BufferHex(lTmp2)
  For I = 1 To lTmp
    nList.Add nRoot, tvwChild, , "Account: " & SIDPacket.GetNTString
  Next I
  For I = 1 To lTmp2
    nList.Add nRoot, tvwChild, , "Key: " & SIDPacket.GetNTString
  Next I
  For I = 1 To lTmp2
    nList.Add nRoot, tvwChild, , "Value: " & SIDPacket.GetNTString
  Next I
End Sub

Private Function TryBN() As Byte
Dim lngLen        As Long
Dim bytPacketType As Byte
Dim bytPacketID   As Byte
Dim TemPacket     As New clsPacket
  TemPacket.SetData strBuffer
  TryBN = &HFF
  If Len(strBuffer) >= 4 Then
    bytPacketType = TemPacket.GetByte
    bytPacketID = TemPacket.GetByte
    lngLen = TemPacket.GetWORD
    If bytPacketID >= 0 And bytPacketID < &H11 Then
      If Len(strBuffer) < lngLen Or lngLen < 0 Then Exit Function
      BNPacket.SetData TemPacket.GetNull
      strBuffer = Mid$(strBuffer, lngLen + 1)
      TryBN = bytPacketID
    End If
  End If
End Function

Private Function TryBNLS() As Byte
Dim lngLen        As Long
Dim bytPacketID   As Byte
Dim TemPacket     As New clsPacket
  TemPacket.SetData strBuffer
  TryBNLS = &HFF
  If Len(strBuffer) >= 3 Then
    lngLen = TemPacket.GetWORD
    bytPacketID = TemPacket.GetByte
    If bytPacketID > 0 And bytPacketID < &H1B Then
      If Len(strBuffer) < lngLen Or lngLen < 0 Then Exit Function
      BNLSPacket.SetData TemPacket.GetNull
      strBuffer = Mid$(strBuffer, lngLen + 1)
      TryBNLS = bytPacketID
    End If
  End If
End Function

Private Function TryD2GS() As Byte
  TryD2GS = &HFF
End Function

Private Function TryMCP() As Byte
Dim lngLen        As Long
Dim bytPacketID   As Byte
Dim TemPacket     As New clsPacket
  TemPacket.SetData strBuffer
  TryMCP = &HFF
  If Len(strBuffer) >= 3 Then
    lngLen = TemPacket.GetWORD
    bytPacketID = TemPacket.GetByte
    If bytPacketID > 0 And bytPacketID < &H1A Then
      If Len(strBuffer) < lngLen Or lngLen < 0 Then Exit Function
      MCPPacket.SetData TemPacket.GetNull
      strBuffer = Mid$(strBuffer, lngLen + 1)
      TryMCP = bytPacketID
    End If
  End If
End Function

Private Function TrySID() As Byte
Dim lngLen        As Long
Dim bytPacketType As Byte
Dim bytPacketID   As Byte
Dim TemPacket     As New clsPacket
  TemPacket.SetData strBuffer
  TrySID = &HFF
  If Len(strBuffer) >= 4 Then
    bytPacketType = TemPacket.GetByte
    bytPacketID = TemPacket.GetByte
    lngLen = TemPacket.GetWORD
    If bytPacketType = &HFF Then
      If Len(strBuffer) < lngLen Or lngLen < 0 Then Exit Function
      SIDPacket.SetData TemPacket.GetNull
      strBuffer = Mid$(strBuffer, lngLen + 1)
      TrySID = bytPacketID
    End If
  End If
End Function

Private Function TryUDP() As Byte
Dim lngLen        As Long
Dim bytPacketID   As Byte
Dim TemPacket     As New clsPacket
  TemPacket.SetData strBuffer
  TryUDP = &HFF
  If Len(strBuffer) >= 4 Then
    bytPacketID = TemPacket.GetByte
    If TemPacket.GetString(3) = String$(3, 0) Then
      lngLen = 0
      If Len(strBuffer) < lngLen Or lngLen < 0 Then Exit Function
      UDPPacket.SetData TemPacket.GetNull
      strBuffer = Mid$(strBuffer, lngLen + 1)
      TryUDP = bytPacketID
    End If
  End If
End Function

Private Function TryW3GS() As Byte
Dim lngLen        As Long
Dim bytPacketType As Byte
Dim bytPacketID   As Byte
Dim TemPacket     As New clsPacket
  TemPacket.SetData strBuffer
  TryW3GS = &HFF
  If Len(strBuffer) >= 4 Then
    bytPacketType = TemPacket.GetByte
    bytPacketID = TemPacket.GetByte
    lngLen = TemPacket.GetWORD
    If bytPacketType = &HF7 Then
      If Len(strBuffer) < lngLen Or lngLen < 0 Then Exit Function
      W3GSPacket.SetData TemPacket.GetNull
      strBuffer = Mid$(strBuffer, lngLen + 1)
      TryW3GS = bytPacketID
    End If
  End If
End Function

