VERSION 5.00
Begin VB.Form frmSettings 
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "BNalyzer Settings"
   ClientHeight    =   3105
   ClientLeft      =   45
   ClientTop       =   315
   ClientWidth     =   4950
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3105
   ScaleWidth      =   4950
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.Frame fraParse 
      Caption         =   "P&arse Settings"
      Height          =   1035
      Left            =   60
      TabIndex        =   9
      Top             =   1500
      Width           =   4815
      Begin VB.TextBox txtW3GSPort 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   4020
         MaxLength       =   5
         TabIndex        =   21
         ToolTipText     =   "Port to analyze for Warcraft III Game Packets (6112 default)."
         Top             =   660
         Width           =   675
      End
      Begin VB.TextBox txtD2GSPort 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   4020
         MaxLength       =   5
         TabIndex        =   19
         ToolTipText     =   "Port to analyze for Diablo II Game Packets (6112 default)."
         Top             =   240
         Width           =   675
      End
      Begin VB.TextBox txtUDPPort 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2400
         MaxLength       =   5
         TabIndex        =   17
         ToolTipText     =   "Port to analyze for UDP Packets (6112 default)."
         Top             =   660
         Width           =   675
      End
      Begin VB.TextBox txtBNLSPort 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   2400
         MaxLength       =   5
         TabIndex        =   15
         ToolTipText     =   "Port to analyze for BNLS Packets (9367 default)."
         Top             =   240
         Width           =   675
      End
      Begin VB.TextBox txtMCPPort 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   840
         MaxLength       =   5
         TabIndex        =   13
         ToolTipText     =   "Port to analyze for MCP Packets (6112 default)."
         Top             =   660
         Width           =   675
      End
      Begin VB.TextBox txtSIDPort 
         Alignment       =   1  'Right Justify
         Height          =   285
         Left            =   840
         MaxLength       =   5
         TabIndex        =   11
         ToolTipText     =   "Port to analyze for SID Packets (6112 default)."
         Top             =   240
         Width           =   675
      End
      Begin VB.Label lblW3GS 
         Caption         =   "W3&GS Port:"
         Height          =   195
         Left            =   3120
         TabIndex        =   20
         Top             =   660
         Width           =   855
      End
      Begin VB.Label lblD2GS 
         Caption         =   "&D2GS Port:"
         Height          =   195
         Left            =   3120
         TabIndex        =   18
         Top             =   240
         Width           =   855
      End
      Begin VB.Label lblUDP 
         Caption         =   "&UDP Port:"
         Height          =   195
         Left            =   1560
         TabIndex        =   16
         Top             =   660
         Width           =   735
      End
      Begin VB.Label lblBNLS 
         Caption         =   "BN&LS Port:"
         Height          =   195
         Left            =   1560
         TabIndex        =   14
         Top             =   240
         Width           =   795
      End
      Begin VB.Label lblMCP 
         Caption         =   "&MCP Port:"
         Height          =   195
         Left            =   60
         TabIndex        =   12
         Top             =   660
         Width           =   735
      End
      Begin VB.Label lblSID 
         Caption         =   "&SID Port:"
         Height          =   195
         Left            =   60
         TabIndex        =   10
         Top             =   240
         Width           =   735
      End
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   3060
      TabIndex        =   22
      ToolTipText     =   "Save and Close."
      Top             =   2640
      Width           =   855
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   4020
      TabIndex        =   23
      ToolTipText     =   "Close."
      Top             =   2640
      Width           =   855
   End
   Begin VB.Frame fraWinPCap 
      Caption         =   "&WinPCap Settings"
      Height          =   1395
      Left            =   60
      TabIndex        =   0
      Top             =   60
      Width           =   4815
      Begin VB.PictureBox pctPCap 
         BorderStyle     =   0  'None
         Height          =   1095
         Left            =   60
         ScaleHeight     =   1095
         ScaleWidth      =   4695
         TabIndex        =   1
         Top             =   240
         Width           =   4695
         Begin VB.TextBox txtFilter 
            Height          =   285
            Left            =   720
            TabIndex        =   3
            ToolTipText     =   "Optional filter for packets."
            Top             =   60
            Width           =   3075
         End
         Begin VB.HScrollBar hsBuffer 
            Height          =   255
            LargeChange     =   8
            Left            =   720
            Min             =   1
            TabIndex        =   6
            Top             =   420
            Value           =   1
            Width           =   3075
         End
         Begin VB.CommandButton cmdSyntax 
            Caption         =   "S&yntax"
            Height          =   255
            Left            =   3840
            TabIndex        =   4
            ToolTipText     =   "Help with WinPCap filter syntax."
            Top             =   60
            Width           =   735
         End
         Begin VB.CheckBox chkPromiscuous 
            Caption         =   "&Promiscuous Mode"
            Height          =   195
            Left            =   720
            TabIndex        =   8
            ToolTipText     =   "Read packets this computer sees, even if the packet is addressed to another computer."
            Top             =   780
            Width           =   1695
         End
         Begin VB.Label lblFilter 
            Caption         =   "&Filter:"
            Height          =   255
            Left            =   120
            TabIndex        =   2
            Top             =   60
            Width           =   495
         End
         Begin VB.Label lblBuffer 
            Caption         =   "&Buffer:"
            Height          =   255
            Left            =   120
            TabIndex        =   5
            Top             =   420
            Width           =   495
         End
         Begin VB.Label lblBufSpace 
            Alignment       =   1  'Right Justify
            Caption         =   "1 MB"
            Height          =   255
            Left            =   3840
            TabIndex        =   7
            Top             =   420
            Width           =   675
         End
      End
   End
End
Attribute VB_Name = "frmSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Type LARGE_INTEGER
  lowpart                     As Long
  highpart                    As Long
End Type
Private Type MEMORYSTATUS
  dwLength                    As Long
  dwMemoryLoad                As Long
  dwTotalPhys                 As Long
  dwAvailPhys                 As Long
  dwTotalPageFile             As Long
  dwAvailPageFile             As Long
  dwTotalVirtual              As Long
  dwAvailVirtual              As Long
End Type
Private Type MEMORYSTATUSEX
  dwLength                    As Long
  dwMemoryLoad                As Long
  ullTotalPhys                As LARGE_INTEGER
  ullAvailPhys                As LARGE_INTEGER
  ullTotalPageFile            As LARGE_INTEGER
  ullAvailPageFile            As LARGE_INTEGER
  ullTotalVirtual             As LARGE_INTEGER
  ullAvailVirtual             As LARGE_INTEGER
  ullAvailExtendedVirtual     As LARGE_INTEGER
End Type
Private Declare Sub GlobalMemoryStatus Lib "kernel32" (lpBuffer As MEMORYSTATUS)
Private Declare Function GlobalMemoryStatusEx Lib "kernel32.dll" (lpBuffer As MEMORYSTATUSEX) As Long
Private sBuffer As String
Private dBufTmr As Double

Private Function CLargeInt(inVal As LARGE_INTEGER) As Double
Dim dblLo As Double
Dim dblHi As Double
  On Error GoTo Erred
  If inVal.lowpart < 0 Then
    dblLo = 2 ^ 32 + inVal.lowpart
  Else
    dblLo = inVal.lowpart
  End If
  If inVal.highpart < 0 Then
    dblHi = 2 ^ 32 + inVal.highpart
  Else
    dblHi = inVal.highpart
  End If
  CLargeInt = dblLo + dblHi * 2 ^ 32
Exit Function
Erred:
  If ErrorHandler("frmSettings", "Function CLargeInt") Then Resume Next
End Function

Private Sub cmdCancel_Click()
  On Error GoTo Erred
  Unload Me
Exit Sub
Erred:
  If ErrorHandler("frmSettings", "Sub cmdCancel_Click") Then Resume Next
End Sub

Private Sub cmdOK_Click()
  On Error GoTo Erred
  If frmMain.cmdStop.Enabled Then MsgBox "Note: WinPCap settings will not take effect until you restart the logging procedure.", vbInformation
  SaveSetting App.CompanyName, App.ProductName, "Filter", txtFilter.Text
  SaveSetting App.CompanyName, App.ProductName, "Buffer", (hsBuffer.Value * 1024& * 1024)
  SaveSetting App.CompanyName, App.ProductName, "Promiscuous", IIf(chkPromiscuous.Value = 1, "Y", "N")
  SaveSetting App.CompanyName, App.ProductName, "SIDPort", txtSIDPort.Text
  SaveSetting App.CompanyName, App.ProductName, "MCPPort", txtMCPPort.Text
  SaveSetting App.CompanyName, App.ProductName, "BNLSPort", txtBNLSPort.Text
  SaveSetting App.CompanyName, App.ProductName, "UDPPort", txtUDPPort.Text
  SaveSetting App.CompanyName, App.ProductName, "D2GSPort", txtD2GSPort.Text
  SaveSetting App.CompanyName, App.ProductName, "W3GSPort", txtW3GSPort.Text
  Unload Me
Exit Sub
Erred:
  If ErrorHandler("frmSettings", "Sub cmdOK_Click") Then Resume Next
End Sub

Private Sub cmdSyntax_Click()
  On Error GoTo Erred
  ShellExecuteA App.hInstance, vbNullString, "http://www.winpcap.org/docs/docs_40_2/html/group__language.html", vbNullString, vbNullString, vbNormalFocus
Exit Sub
Erred:
  If ErrorHandler("frmSettings", "Sub cmdSyntax_Click") Then Resume Next
End Sub

Private Sub Form_Load()
  On Error GoTo Erred
  If GetMemoryMax > 1073741824 Then
    hsBuffer.Max = 1073741824 / 1024 / 1024
  Else
    hsBuffer.Max = GetMemoryMax / 1024 / 1024
  End If
  txtFilter.Text = GetSetting(App.CompanyName, App.ProductName, "Filter")
  hsBuffer.Value = GetSetting(App.CompanyName, App.ProductName, "Buffer", 67108864) / 1024 / 1024
  chkPromiscuous.Value = IIf(GetSetting(App.CompanyName, App.ProductName, "Promiscuous", "N") = "Y", 1, 0)
  txtSIDPort.Text = GetSetting(App.CompanyName, App.ProductName, "SIDPort", 6112)
  txtMCPPort.Text = GetSetting(App.CompanyName, App.ProductName, "MCPPort", 6112)
  txtBNLSPort.Text = GetSetting(App.CompanyName, App.ProductName, "BNLSPort", 9367)
  txtUDPPort.Text = GetSetting(App.CompanyName, App.ProductName, "UDPPort", 6112)
  txtD2GSPort.Text = GetSetting(App.CompanyName, App.ProductName, "D2GSPort", 6112)
  txtW3GSPort.Text = GetSetting(App.CompanyName, App.ProductName, "W3GSPort", 6112)
Exit Sub
Erred:
  If ErrorHandler("frmSettings", "Sub Form_Load") Then Resume Next
End Sub

Private Function GetMemoryMax() As Double
Dim Mem   As MEMORYSTATUS
Dim MemEX As MEMORYSTATUSEX
Dim dPhys As Double
  On Error GoTo Erred
  GlobalMemoryStatus Mem
  If Mem.dwTotalPhys < 0 Or Mem.dwTotalVirtual < 0 Or Mem.dwTotalPageFile < 0 Then
    MemEX.dwLength = Len(MemEX)
    GlobalMemoryStatusEx MemEX
    dPhys = CLargeInt(MemEX.ullTotalPhys)
  Else
    dPhys = CDbl(Mem.dwTotalPhys)
  End If
  GetMemoryMax = dPhys
Exit Function
Erred:
  If ErrorHandler("frmSettings", "Function GetMemoryMax") Then Resume Next
End Function

Private Sub hsBuffer_Change()
  On Error GoTo Erred
  lblBufSpace.Caption = hsBuffer.Value & " MB"
Exit Sub
Erred:
  If ErrorHandler("frmSettings", "Sub hsBuffer_Change") Then Resume Next
End Sub

Private Sub hsBuffer_GotFocus()
  sBuffer = vbNullString
End Sub

Private Sub hsBuffer_KeyPress(KeyAscii As Integer)
  If Not (KeyAscii >= vbKey0 And KeyAscii <= vbKey9) And Not (KeyAscii = 24 Or KeyAscii = 3) And Not (KeyAscii = vbKeyBack) Then
    KeyAscii = 0
  Else
    If dBufTmr + 1000 < GetTickDouble Then
      sBuffer = Chr$(KeyAscii)
    Else
      sBuffer = sBuffer & Chr$(KeyAscii)
    End If
    If Val(sBuffer) <= hsBuffer.Max And Val(sBuffer) >= hsBuffer.Min Then
      hsBuffer.Value = Val(sBuffer)
      dBufTmr = GetTickDouble
    Else
      sBuffer = vbNullString
    End If
  End If
End Sub

Private Sub txtBNLSPort_Change()
  If LenB(txtBNLSPort.Text) > 0 Then txtBNLSPort.Text = Val(txtBNLSPort.Text)
  If Val(txtBNLSPort.Text) > 65535 Then txtBNLSPort.Text = 65535
End Sub

Private Sub txtBNLSPort_GotFocus()
  txtBNLSPort.SelStart = 0
  txtBNLSPort.SelLength = Len(txtBNLSPort.Text)
End Sub

Private Sub txtBNLSPort_KeyPress(KeyAscii As Integer)
  If Not (KeyAscii >= vbKey0 And KeyAscii <= vbKey9) And Not (KeyAscii = 24 Or KeyAscii = 3) And Not (KeyAscii = vbKeyBack) Then KeyAscii = 0
End Sub

Private Sub txtD2GSPort_Change()
  If LenB(txtD2GSPort.Text) > 0 Then txtD2GSPort.Text = Val(txtD2GSPort.Text)
  If Val(txtD2GSPort.Text) > 65535 Then txtD2GSPort.Text = 65535
End Sub

Private Sub txtD2GSPort_GotFocus()
  txtD2GSPort.SelStart = 0
  txtD2GSPort.SelLength = Len(txtD2GSPort.Text)
End Sub

Private Sub txtD2GSPort_KeyPress(KeyAscii As Integer)
  If Not (KeyAscii >= vbKey0 And KeyAscii <= vbKey9) And Not (KeyAscii = 24 Or KeyAscii = 3) And Not (KeyAscii = vbKeyBack) Then KeyAscii = 0
End Sub

Private Sub txtMCPPort_Change()
  If LenB(txtMCPPort.Text) > 0 Then txtMCPPort.Text = Val(txtMCPPort.Text)
  If Val(txtMCPPort.Text) > 65535 Then txtMCPPort.Text = 65535
End Sub

Private Sub txtMCPPort_GotFocus()
  txtMCPPort.SelStart = 0
  txtMCPPort.SelLength = Len(txtMCPPort)
End Sub

Private Sub txtMCPPort_KeyPress(KeyAscii As Integer)
  If Not (KeyAscii >= vbKey0 And KeyAscii <= vbKey9) And Not (KeyAscii = 24 Or KeyAscii = 3) And Not (KeyAscii = vbKeyBack) Then KeyAscii = 0
End Sub

Private Sub txtSIDPort_Change()
  If LenB(txtSIDPort.Text) > 0 Then txtSIDPort.Text = Val(txtSIDPort.Text)
  If Val(txtSIDPort.Text) > 65535 Then txtSIDPort.Text = 65535
End Sub

Private Sub txtSIDPort_GotFocus()
  txtSIDPort.SelStart = 0
  txtSIDPort.SelLength = Len(txtSIDPort)
End Sub

Private Sub txtSIDPort_KeyPress(KeyAscii As Integer)
  If Not (KeyAscii >= vbKey0 And KeyAscii <= vbKey9) And Not (KeyAscii = 24 Or KeyAscii = 3) And Not (KeyAscii = vbKeyBack) Then KeyAscii = 0
End Sub

Private Sub txtUDPPort_Change()
  If LenB(txtUDPPort.Text) > 0 Then txtUDPPort.Text = Val(txtUDPPort.Text)
  If Val(txtUDPPort.Text) > 65535 Then txtUDPPort.Text = 65535
End Sub

Private Sub txtUDPPort_GotFocus()
  txtUDPPort.SelStart = 0
  txtUDPPort.SelLength = Len(txtUDPPort)
End Sub

Private Sub txtUDPPort_KeyPress(KeyAscii As Integer)
  If Not (KeyAscii >= vbKey0 And KeyAscii <= vbKey9) And Not (KeyAscii = 24 Or KeyAscii = 3) And Not (KeyAscii = vbKeyBack) Then KeyAscii = 0
End Sub

Private Sub txtW3GSPort_Change()
  If LenB(txtW3GSPort.Text) > 0 Then txtW3GSPort.Text = Val(txtW3GSPort.Text)
  If Val(txtW3GSPort.Text) > 65535 Then txtW3GSPort.Text = 65535
End Sub

Private Sub txtW3GSPort_GotFocus()
  txtW3GSPort.SelStart = 0
  txtW3GSPort.SelLength = Len(txtW3GSPort.Text)
End Sub

Private Sub txtW3GSPort_KeyPress(KeyAscii As Integer)
  If Not (KeyAscii >= vbKey0 And KeyAscii <= vbKey9) And Not (KeyAscii = 24 Or KeyAscii = 3) And Not (KeyAscii = vbKeyBack) Then KeyAscii = 0
End Sub
