VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Object = "{248DD890-BB45-11CF-9ABC-0080C7E7B78D}#1.0#0"; "MSWINSCK.OCX"
Object = "{3B7C8863-D78F-101B-B9B5-04021C009402}#1.2#0"; "RICHTX32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmMain 
   Caption         =   "BNalyzer"
   ClientHeight    =   7845
   ClientLeft      =   120
   ClientTop       =   750
   ClientWidth     =   9615
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7845
   ScaleWidth      =   9615
   Begin VB.CheckBox chkParse 
      Caption         =   "Parsed View"
      Height          =   255
      Left            =   2040
      TabIndex        =   3
      ToolTipText     =   "Toggle view styles."
      Top             =   420
      Width           =   1215
   End
   Begin MSComDlg.CommonDialog cdlOSD 
      Left            =   2820
      Top             =   360
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame fraStats 
      Caption         =   "Statistics"
      Height          =   855
      Left            =   3360
      TabIndex        =   6
      Top             =   0
      Width           =   6195
      Begin VB.PictureBox pctStats 
         BorderStyle     =   0  'None
         Height          =   615
         Left            =   60
         ScaleHeight     =   615
         ScaleWidth      =   6075
         TabIndex        =   7
         Top             =   180
         Width           =   6075
         Begin VB.Label lblTime 
            Caption         =   "Time:"
            Height          =   255
            Left            =   4740
            TabIndex        =   28
            Top             =   300
            Width           =   435
         End
         Begin VB.Label lblRunTime 
            Alignment       =   1  'Right Justify
            Caption         =   "0 s"
            Height          =   255
            Left            =   5160
            TabIndex        =   27
            Top             =   300
            Width           =   855
         End
         Begin VB.Label lblBNPack 
            Caption         =   "BotNet:"
            Height          =   255
            Left            =   4740
            TabIndex        =   26
            Top             =   60
            Width           =   555
         End
         Begin VB.Label lblBN 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   5280
            TabIndex        =   25
            Top             =   60
            Width           =   555
         End
         Begin VB.Label lblD2GSPack 
            Caption         =   "D2GS:"
            Height          =   255
            Left            =   3600
            TabIndex        =   24
            Top             =   60
            Width           =   555
         End
         Begin VB.Label lblD2GS 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   4140
            TabIndex        =   23
            Top             =   60
            Width           =   555
         End
         Begin VB.Label lblW3GSPack 
            Caption         =   "W3GS:"
            Height          =   255
            Left            =   3600
            TabIndex        =   22
            Top             =   300
            Width           =   555
         End
         Begin VB.Label lblW3GS 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   4140
            TabIndex        =   21
            Top             =   300
            Width           =   555
         End
         Begin VB.Label lblUDP 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   3000
            TabIndex        =   19
            Top             =   300
            Width           =   555
         End
         Begin VB.Label lblBNLS 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   3000
            TabIndex        =   18
            Top             =   60
            Width           =   555
         End
         Begin VB.Label lblUDPPack 
            Caption         =   "UDP:"
            Height          =   255
            Left            =   2520
            TabIndex        =   17
            Top             =   300
            Width           =   495
         End
         Begin VB.Label lblBNLSPack 
            Caption         =   "BNLS:"
            Height          =   255
            Left            =   2520
            TabIndex        =   16
            Top             =   60
            Width           =   495
         End
         Begin VB.Label lblMCP 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   1920
            TabIndex        =   15
            Top             =   300
            Width           =   555
         End
         Begin VB.Label lblSID 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   1920
            TabIndex        =   14
            Top             =   60
            Width           =   555
         End
         Begin VB.Label lblMCPPack 
            Caption         =   "MCP:"
            Height          =   255
            Left            =   1440
            TabIndex        =   13
            Top             =   300
            Width           =   495
         End
         Begin VB.Label lblSIDPack 
            Caption         =   "SID:"
            Height          =   255
            Left            =   1440
            TabIndex        =   12
            Top             =   60
            Width           =   495
         End
         Begin VB.Label lblRecv 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   840
            TabIndex        =   11
            Top             =   300
            Width           =   555
         End
         Begin VB.Label lblSend 
            Alignment       =   1  'Right Justify
            Caption         =   "0"
            Height          =   255
            Left            =   840
            TabIndex        =   10
            Top             =   60
            Width           =   555
         End
         Begin VB.Label lblRecvPack 
            Caption         =   "Received:"
            Height          =   255
            Left            =   60
            TabIndex        =   9
            Top             =   300
            Width           =   795
         End
         Begin VB.Label lblSendPack 
            Caption         =   "Sent:"
            Height          =   255
            Left            =   60
            TabIndex        =   8
            Top             =   60
            Width           =   795
         End
      End
   End
   Begin MSWinsockLib.Winsock wsTest 
      Left            =   9120
      Top             =   420
      _ExtentX        =   741
      _ExtentY        =   741
      _Version        =   393216
   End
   Begin VB.ComboBox cmbAdapters 
      Height          =   315
      Left            =   60
      Style           =   2  'Dropdown List
      TabIndex        =   0
      ToolTipText     =   "Select an adapter to analyze."
      Top             =   60
      Width           =   3255
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Enabled         =   0   'False
      Height          =   435
      Left            =   1020
      TabIndex        =   2
      ToolTipText     =   "Stop packet analysis."
      Top             =   420
      Width           =   915
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Height          =   435
      Left            =   60
      TabIndex        =   1
      ToolTipText     =   "Begin or continue packet analysis."
      Top             =   420
      Width           =   915
   End
   Begin RichTextLib.RichTextBox rtbPackets 
      Height          =   6915
      Left            =   60
      TabIndex        =   4
      Top             =   900
      Width           =   9495
      _ExtentX        =   16748
      _ExtentY        =   12197
      _Version        =   393217
      ReadOnly        =   -1  'True
      ScrollBars      =   2
      TextRTF         =   $"frmMain.frx":0E42
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Fixedsys"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin ComctlLib.TreeView tvPackets 
      Height          =   6855
      Left            =   60
      TabIndex        =   5
      Top             =   900
      Visible         =   0   'False
      Width           =   9495
      _ExtentX        =   16748
      _ExtentY        =   12091
      _Version        =   327682
      LabelEdit       =   1
      LineStyle       =   1
      Style           =   6
      Appearance      =   1
   End
   Begin RichTextLib.RichTextBox rtbFmt 
      Height          =   315
      Left            =   120
      TabIndex        =   20
      TabStop         =   0   'False
      Top             =   960
      Width           =   195
      _ExtentX        =   344
      _ExtentY        =   556
      _Version        =   393217
      ReadOnly        =   -1  'True
      TextRTF         =   $"frmMain.frx":0EBF
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Fixedsys"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuNew 
         Caption         =   "&New Analysis"
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuOpen 
         Caption         =   "&Open..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuSpace1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSave 
         Caption         =   "&Save"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuSaveAs 
         Caption         =   "Save &As..."
      End
      Begin VB.Menu mnuSpace2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
         Shortcut        =   ^Q
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "&View"
      Begin VB.Menu mnuStart 
         Caption         =   "St&art"
         Shortcut        =   {F5}
      End
      Begin VB.Menu mnuStop 
         Caption         =   "S&top"
         Enabled         =   0   'False
         Shortcut        =   {F6}
      End
      Begin VB.Menu mnuSpace3 
         Caption         =   "-"
      End
      Begin VB.Menu mnuParse 
         Caption         =   "&Parsed View"
      End
      Begin VB.Menu mnuSpace4 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSettings 
         Caption         =   "&Settings..."
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuDocs 
         Caption         =   "&Documentation..."
         Shortcut        =   {F1}
      End
      Begin VB.Menu mnuSpace5 
         Caption         =   "-"
      End
      Begin VB.Menu mnuAbout 
         Caption         =   "&About..."
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'TO DO: IP Storage System to keep track of protocols!

Option Explicit
Private Declare Function GetScrollInfo Lib "user32.dll" (ByVal hwnd As Long, ByVal n As Long, ByRef lpScrollInfo As SCROLLINFO) As Long
Private Declare Function InitCommonControlsEx Lib "comctl32.dll" (iccex As tagInitCommonControlsEx) As Boolean
Private Type SCROLLINFO
  cbSize          As Long
  fMask           As Long
  nMin            As Long
  nMax            As Long
  nPage           As Long
  nPos            As Long
  nTrackPos       As Long
End Type
Private Type POINTAPI
  x               As Long
  y               As Long
End Type
Private Type MINMAXINFO
  ptReserved      As POINTAPI
  ptMaxSize       As POINTAPI
  ptMaxPosition   As POINTAPI
  ptMinTrackSize  As POINTAPI
  ptMaxTrackSize  As POINTAPI
End Type
Private Type tagInitCommonControlsEx
   lngSize        As Long
   lngICC         As Long
End Type
Implements ISubclass
Private m_emr     As EMsgResponse
Private SendCount As Long
Private RecvCount As Long
Private LocalIP   As String
Private Sniffing  As Boolean
Private sFileName As String
Private dStartMS  As Double

Private Sub AddPacketData(ByVal sData As String)
Dim bScroll As Boolean
Dim TheRTB  As RichTextBox
  On Error GoTo Erred
  bScroll = DetectScrollLoc(rtbPackets.hwnd)
  If bScroll Then
    Set TheRTB = rtbPackets
  Else
    Set TheRTB = rtbFmt
    TheRTB.TextRTF = rtbPackets.TextRTF
  End If
  TheRTB.SelStart = Len(TheRTB.Text)
  TheRTB.SelLength = 0
  TheRTB.SelText = vbNewLine & sData
  If bScroll Then
    rtbPackets.SelStart = Len(rtbPackets.Text)
    rtbPackets.SelLength = 0
  Else
    rtbPackets.TextRTF = rtbFmt.TextRTF
    rtbFmt.TextRTF = vbNullString
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub AddPacketData") Then Resume Next
End Sub

Private Sub Analyze()
Dim sPacket     As String
Dim bBuff()     As Byte
Dim pHd         As PacketHeader
Dim rVal        As Byte
  On Error GoTo Erred
  Do While Sniffing
    ReDim bBuff(32767) As Byte
    rVal = vpCapture(bBuff(), pHd)
    If rVal > 0 Then
      sPacket = String$(pHd.caplen, 0)
      RtlMoveMemory ByVal sPacket, bBuff(0), pHd.caplen
      AnalyzePacket sPacket
    End If
    Erase bBuff()
    lblRunTime.Caption = ConvertTime(GetTickDouble - dStartMS)
    DoEvents
  Loop
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub Analyze") Then Resume Next
End Sub

Private Sub AnalyzePacket(ByVal sPacket As String)
Dim cPacket     As New clsPacket
Dim sData       As String
Dim cTCPIP      As New clsTCPIP
Static sCumul   As String
Static lAckID   As Long
  On Error GoTo Erred
  cPacket.SetData sPacket
  cPacket.SwapEndian
  cTCPIP.Decode cPacket
  sData = cPacket.GetNull
  If LenB(sData) > 0 Then
    If cTCPIP.EthHeader.iType = &H800 Then
      If cTCPIP.IPHeader.bProto = 6 Then
        sData = Left$(sData, cTCPIP.IPHeader.iLength - 40)
        If cTCPIP.TCPHeader.bFlags And TCPFLAGS.PSH Then
          If lAckID = cTCPIP.TCPHeader.lAckNum And lAckID <> 0 And LenB(sCumul) > 0 Then
            sData = sCumul & sData
            sCumul = vbNullString
            lAckID = 0
          End If
          If CheckPorts(cTCPIP.TCPHeader.iSrcPort, cTCPIP.TCPHeader.iDestPort, "SID") Or _
             CheckPorts(cTCPIP.TCPHeader.iSrcPort, cTCPIP.TCPHeader.iDestPort, "MCP") Or _
             CheckPorts(cTCPIP.TCPHeader.iSrcPort, cTCPIP.TCPHeader.iDestPort, "BNLS") Or _
             CheckPorts(cTCPIP.TCPHeader.iSrcPort, cTCPIP.TCPHeader.iDestPort, "UDP") Then
            DisplayData (cTCPIP.IPHeader.sSrcIP = LocalIP), _
                        cTCPIP.IPHeader.sDestIP, cTCPIP.TCPHeader.iDestPort, _
                        cTCPIP.IPHeader.sSrcIP, cTCPIP.TCPHeader.iSrcPort, _
                        sData
          End If
        ElseIf cTCPIP.TCPHeader.bFlags And TCPFLAGS.ACK Then
          If lAckID = 0 Then
            lAckID = cTCPIP.TCPHeader.lAckNum
            sCumul = vbNullString
          Else
            If lAckID = cTCPIP.TCPHeader.lAckNum Then
              sCumul = sCumul & sData
            Else
              lAckID = cTCPIP.TCPHeader.lAckNum
              sCumul = vbNullString
            End If
          End If
        End If
      End If
    End If
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub AnalyzePacket") Then Resume Next
End Sub

Private Function BufferStr(ByVal sVal As String, ByVal Places As Long)
  On Error GoTo Erred
  If Places > Len(sVal) Then
    BufferStr = sVal & String$(Places - Len(sVal), " ")
  Else
    BufferStr = sVal
  End If
Exit Function
Erred:
  If ErrorHandler("modBNCSParser", "Function BufferStr") Then Resume Next
End Function

Private Sub chkParse_Click()
  On Error GoTo Erred
  mnuParse.Checked = chkParse.Value = 1
  rtbPackets.Visible = chkParse.Value = 0
  tvPackets.Visible = chkParse.Value = 1
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub chkParse_Click") Then Resume Next
End Sub

Private Sub cmbAdapters_Click()
  On Error GoTo Erred
  vpSetCurrentAdapter cmbAdapters.ListIndex
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub cmbAdapters_Click") Then Resume Next
End Sub

Private Sub cmdStart_Click()
Dim Ret As Long
Static b As Boolean
  On Error GoTo Erred
  Sniffing = True
  cmdStart.Enabled = False
  mnuStart.Enabled = False
  cmdStop.Enabled = True
  mnuStop.Enabled = True
  If Not b Then
    vpSetParam PRM_DUMPTYPE, 100
    vpSetParam PRM_OPENMODE, 1001
    b = True
  End If
  vpSetParam PRM_KERNELBUFFSIZE, Val(GetSetting(App.CompanyName, App.ProductName, "Buffer", 67108864) / 1024 / 1024)
  vpSetParam PRM_MODE, IIf(GetSetting(App.CompanyName, App.ProductName, "Promiscuous", "N") = "Y", 1, 0)
  If LenB(GetSetting(App.CompanyName, App.ProductName, "Filter")) > 0 Then vpSetParam PRM_SETFILTER, GetSetting(App.CompanyName, App.ProductName, "Filter")
  Ret = vpBegin(20)
  If Ret < 0 Then
    MsgBox "Error: " & vpGetErrorDescription
    Sniffing = False
    cmdStart.Enabled = True
    mnuStart.Enabled = True
    cmdStop.Enabled = False
    mnuStop.Enabled = False
  Else
    dStartMS = GetTickDouble
    Analyze
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub cmdStart_Click") Then Resume Next
End Sub

Private Sub cmdStop_Click()
  On Error GoTo Erred
  Sniffing = False
  vpEnd
  cmdStart.Enabled = True
  mnuStart.Enabled = True
  cmdStop.Enabled = False
  mnuStop.Enabled = False
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub cmdStop_Click") Then Resume Next
End Sub

Public Function DetectScrollLoc(ByVal rtb As Long) As Boolean
Dim sInfo As SCROLLINFO
  sInfo.cbSize = Len(sInfo)
  sInfo.fMask = &H1 Or &H2 Or &H4
  GetScrollInfo rtb, 1, sInfo
  DetectScrollLoc = sInfo.nPos >= (sInfo.nMax - sInfo.nPage) - 5
End Function

Private Sub DisplayData(ByVal OutPacket As Boolean, ByVal DestIP As String, ByVal DestPort As Long, ByVal SourceIP As String, ByVal SourcePort As Long, ByVal sData As String)
Dim Chunk As String
Dim I     As Long
Dim sDisp As String
  On Error GoTo Erred
  If LenB(sData) > 0 Then
    If OutPacket Then
      sDisp = "SEND " & SourceIP & ":" & SourcePort & " -> " & DestIP & ":" & DestPort & "  " & Len(sData)
      SendCount = SendCount + 1
    Else
      sDisp = "RECV " & DestIP & ":" & DestPort & " <- " & SourceIP & ":" & SourcePort & "  " & Len(sData)
      RecvCount = RecvCount + 1
    End If
    For I = 1 To Len(sData) Step 16
      Chunk = Mid$(sData, I, 16)
      sDisp = sDisp & vbNewLine & BufferHex(I - 1, 4) & "  " & BufferStr(StH(Left$(Chunk, 8), True), 23) & "  " & BufferStr(StH(Mid$(Chunk, 9), True), 23) & "    " & SafeStr(Chunk)
    Next I
    sDisp = sDisp & vbNewLine
    AddPacketData sDisp
    
    ParsePacket sData, OutPacket, DestIP, DestPort, SourceIP, SourcePort
    UpdateDisplay
  Else
    Debug.Print "Len: " & LenB(sData)
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub DisplayData") Then Resume Next
End Sub

Private Sub Form_Initialize()
Dim iccex As tagInitCommonControlsEx
  On Error GoTo Erred
  With iccex
    .lngSize = LenB(iccex)
    .lngICC = &H200
  End With
  On Error Resume Next
  InitCommonControlsEx iccex
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub Form_Initialize") Then Resume Next
End Sub

Private Sub Form_Load()
Dim lAdpt As Long
Dim I     As Long
Dim adIfo As AdINFO
  On Error GoTo Erred
  AttachMessage Me, Me.hwnd, &H24
  lAdpt = VBPcapInit
  If lAdpt < 1 Then
    MsgBox "Could not detect any adapters!", vbCritical
    End
  End If
  For I = 0 To lAdpt - 1
    vpGetAdapterInfo I, adIfo
    cmbAdapters.AddItem TrimNull(adIfo.Description)
  Next I
  LocalIP = wsTest.LocalIP
  cmbAdapters.ListIndex = 0
  rtbPackets.Visible = True
  Me.Move GetSetting(App.CompanyName, App.ProductName, "Left", Screen.Width / 2 - 5000), GetSetting(App.CompanyName, App.ProductName, "Top", Screen.Height / 2 - 5000), GetSetting(App.CompanyName, App.ProductName, "Width", 9840), GetSetting(App.CompanyName, App.ProductName, "Height", 8000)
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub Form_Load") Then Resume Next
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
  On Error GoTo Erred
  If Me.WindowState = vbNormal Then
    SaveSetting App.CompanyName, App.ProductName, "Left", Me.Left
    SaveSetting App.CompanyName, App.ProductName, "Top", Me.Top
    SaveSetting App.CompanyName, App.ProductName, "Width", Me.Width
    SaveSetting App.CompanyName, App.ProductName, "Height", Me.Height
  End If
  DetachMessage Me, Me.hwnd, &H24
  Sniffing = False
  DoEvents
  VBPcapTerminate
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub Form_QueryUnload") Then Resume Next
End Sub

Private Sub Form_Resize()
  On Error GoTo Erred
  If Not Me.WindowState = vbMinimized Then
    rtbPackets.Move 60, 900, Me.ScaleWidth - 120, Me.ScaleHeight - 960
    tvPackets.Move 60, 900, Me.ScaleWidth - 120, Me.ScaleHeight - 960
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub Form_Resize") Then Resume Next
End Sub

Private Property Let ISubclass_MsgResponse(ByVal RHS As SSubTimer6.EMsgResponse)
  On Error GoTo Erred
  m_emr = RHS
Exit Property
Erred:
  If ErrorHandler("frmMain", "Property ISubclass_MsgResponse") Then Resume Next
End Property

Private Property Get ISubclass_MsgResponse() As SSubTimer6.EMsgResponse
  On Error GoTo Erred
  m_emr = emrConsume
  ISubclass_MsgResponse = m_emr
Exit Property
Erred:
  If ErrorHandler("frmMain", "Property ISubclass_MsgResponse") Then Resume Next
End Property

Private Function ISubclass_WindowProc(ByVal hwnd As Long, ByVal iMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Dim mmiT As MINMAXINFO
  On Error GoTo Erred
  If iMsg = &H24 Then
    RtlMoveMemory mmiT, ByVal lParam, LenB(mmiT)
    mmiT.ptMinTrackSize.x = 656
    mmiT.ptMinTrackSize.y = (150 + ((Me.Height - Me.ScaleHeight) / Screen.TwipsPerPixelY))
    RtlMoveMemory ByVal lParam, mmiT, LenB(mmiT)
  End If
Exit Function
Erred:
  If ErrorHandler("frmMain", "Function ISubclass_WindowProc") Then Resume Next
End Function

Private Sub mnuAbout_Click()
  frmAbout.Show , Me
End Sub

Private Sub mnuDocs_Click()
  On Error GoTo Erred
  ShellExecuteA App.hInstance, vbNullString, "http://bnetdocs.com", vbNullString, vbNullString, vbNormalFocus
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuDocs_Click") Then Resume Next
End Sub

Private Sub mnuExit_Click()
  On Error GoTo Erred
  If cmdStop.Enabled Then
    If MsgBox("Are you sure you want to stop the current analysis without saving?", vbYesNo, "Close BNalyzer?") = vbNo Then Exit Sub
    cmdStop_Click
  End If
  Unload Me
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuExit_Click") Then Resume Next
End Sub

Private Sub mnuNew_Click()
  On Error GoTo Erred
  If cmdStop.Enabled Then
    If MsgBox("Are you sure you want to stop the current analysis without saving?", vbYesNo, "New Analysis?") = vbNo Then Exit Sub
    cmdStop_Click
  End If
  SendCount = 0
  RecvCount = 0
  SIDCount = 0
  MCPCount = 0
  BNLSCount = 0
  UDPCount = 0
  UpdateDisplay
  strBuffer = vbNullString
  sFileName = vbNullString
  rtbPackets.Text = vbNullString
  tvPackets.Nodes.Clear
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuNew_Click") Then Resume Next
End Sub

Private Sub mnuOpen_Click()
Dim nFile As Integer
Dim sTemp As String
Dim aTm() As String
Dim bSend As Boolean
Dim sSnIP As String
Dim lSnPt As Long
Dim sRcIP As String
Dim lRcPt As Long
Dim sPakt As String
  On Error GoTo Erred
  If cmdStop.Enabled Then
    If MsgBox("Are you sure you want to stop the current analysis without saving?", vbYesNo, "Open Analysis?") = vbNo Then Exit Sub
    cmdStop_Click
  End If
  cdlOSD.Filter = "Text File (*.txt)|*.txt|All Files (*.*)|*.*"
  cdlOSD.Flags = FileOpenConstants.cdlOFNHideReadOnly Or FileOpenConstants.cdlOFNFileMustExist
  cdlOSD.ShowOpen
  If LenB(cdlOSD.FileName) > 0 And LenB(cdlOSD.FileTitle) > 0 Then
    SendCount = 0
    RecvCount = 0
    SIDCount = 0
    MCPCount = 0
    BNLSCount = 0
    UDPCount = 0
    UpdateDisplay
    strBuffer = vbNullString
    sFileName = vbNullString
    rtbPackets.Text = vbNullString
    tvPackets.Nodes.Clear
    nFile = FreeFile
    sFileName = cdlOSD.FileName
    Open sFileName For Input As #nFile
    Do Until EOF(nFile)
      Line Input #nFile, sTemp
      If LenB(sTemp) > 0 Then
        aTm = Split(sTemp, " ")
        bSend = aTm(0) = "SEND"
        If bSend Then
          sSnIP = Split(aTm(1), ":")(0)
          lSnPt = CLng(Split(aTm(1), ":")(1))
          sRcIP = Split(aTm(3), ":")(0)
          lRcPt = CLng(Split(aTm(3), ":")(1))
        Else
          sRcIP = Split(aTm(1), ":")(0)
          lRcPt = CLng(Split(aTm(1), ":")(1))
          sSnIP = Split(aTm(3), ":")(0)
          lSnPt = CLng(Split(aTm(3), ":")(1))
        End If
        sTemp = " "
        sPakt = vbNullString
        Do While LenB(sTemp)
          Line Input #nFile, sTemp
          If Len(sTemp) > 55 Then
            sPakt = sPakt & HtS(Replace$(Mid$(sTemp, 7, 48), " ", vbNullString))
          End If
        Loop
        DisplayData bSend, sSnIP, lSnPt, sRcIP, lRcPt, sPakt
      End If
    Loop
    Close #nFile
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuOpen_Click") Then Resume Next
End Sub

Private Sub mnuParse_Click()
  On Error GoTo Erred
  mnuParse.Checked = Not mnuParse.Checked
  chkParse.Value = IIf(mnuParse.Checked, 1, 0)
  rtbPackets.Visible = chkParse.Value = 0
  tvPackets.Visible = chkParse.Value = 1
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuParse_Click") Then Resume Next
End Sub

Private Sub mnuSave_Click()
Dim nFile As Integer
  On Error GoTo Erred
  If LenB(sFileName) > 0 Then
    nFile = FreeFile
    Open sFileName For Output As #nFile
    Print #nFile, rtbPackets.Text
    Close #nFile
  Else
    mnuSaveAs_Click
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuSave_Click") Then Resume Next
End Sub

Private Sub mnuSaveAs_Click()
  On Error GoTo Erred
  cdlOSD.Filter = "Text File (*.txt)|*.txt"
  cdlOSD.Flags = FileOpenConstants.cdlOFNHideReadOnly Or FileOpenConstants.cdlOFNOverwritePrompt
  cdlOSD.ShowSave
  If LenB(cdlOSD.FileName) > 0 Then
    sFileName = cdlOSD.FileName
    mnuSave_Click
  End If
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuSaveAs_Click") Then Resume Next
End Sub

Private Sub mnuSettings_Click()
  On Error GoTo Erred
  frmSettings.Show , Me
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuSettings_Click") Then Resume Next
End Sub

Private Sub mnuStart_Click()
  On Error GoTo Erred
  cmdStart_Click
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuStart_Click") Then Resume Next
End Sub

Private Sub mnuStop_Click()
  On Error GoTo Erred
  cmdStop_Click
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub mnuStop_Click") Then Resume Next
End Sub

Public Function SafeStr(ByVal sVal As String)
Dim I As Long
  On Error GoTo Erred
  For I = 0 To &H1F
    sVal = Replace$(sVal, Chr$(I), ".")
  Next I
  SafeStr = sVal
Exit Function
Erred:
  If ErrorHandler("modBNCSParser", "Function SafeStr") Then Resume Next
End Function

Private Sub UpdateDisplay()
  On Error GoTo Erred
  lblSend.Caption = SendCount
  lblRecv.Caption = RecvCount
  lblSID.Caption = SIDCount
  lblMCP.Caption = MCPCount
  lblBNLS.Caption = BNLSCount
  lblUDP.Caption = UDPCount
Exit Sub
Erred:
  If ErrorHandler("frmMain", "Sub UpdateDisplay") Then Resume Next
End Sub
