VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsTCPIP"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder6" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
Option Explicit
Private ethData As New clsEthHeader
Private ipData  As New clsIPHeader
Private tcpData As New clsTCPHeader

Public Property Get EthHeader() As clsEthHeader
  Set EthHeader = ethData
End Property

Public Property Get IPHeader() As clsIPHeader
  Set IPHeader = ipData
End Property

Public Property Get TCPHeader() As clsTCPHeader
  Set TCPHeader = tcpData
End Property

Public Sub Decode(ByRef cPacket As clsPacket)
Dim lOptions As Long
Dim lPadding As Long
  On Error GoTo Erred
  ethData.sDestMAC = Replace$(StH(cPacket.GetString(6), True), " ", ":")
  ethData.sSrcMAC = Replace$(StH(cPacket.GetString(6), True), " ", ":")
  ethData.iType = cPacket.GetWORD
  Select Case ethData.iType
    Case Is <= &H5DC
      ethData.sType = "[Ethernet IEEE 802.3]"
      ethData.bLLCDSAP = cPacket.GetByte
      ethData.bLLCSNAP = cPacket.GetByte
      ethData.bLLCCTRL = cPacket.GetByte
      If ethData.bLLCDSAP = ethData.bLLCSNAP Then
        Select Case ethData.bLLCDSAP
          Case &HF0
            ethData.sType = ethData.sType & " [NETBIOS LLC Encapsulation]"
          Case &HFF
            ethData.sType = ethData.sType & " [IPX RAW 802.3 Encapsulation]"
        End Select
      End If
    Case &H800
      ethData.sType = "[IPv4]"
    Case &H806
      ethData.sType = "[Arp]"
    Case &H8035
      ethData.sType = "[Rarp]"
    Case &H8137
      ethData.sType = "[Novell Netware IPX]"
    Case &H86DD
      ethData.sType = "[IPv6]"
    Case &H8037
      ethData.sType = "[IPX]"
    Case &H809B
      ethData.sType = "[Ethertalk]"
    Case &H814C
      ethData.sType = "[SNMP over Ethernet]"
    Case Else
      ethData.sType = "Unknown (0x" & BufferHex(ethData.iType, 4) & ")"
  End Select
  If ethData.iType = &H800 Then
    ipData.bVer = ((cPacket.PeekByte And &HF0) / 16)
    ipData.bIHL = (cPacket.GetByte And &HF)
    ipData.bTOS = cPacket.GetByte
    ipData.iLength = cPacket.GetWORD
    ipData.iID = cPacket.GetWORD
    ipData.bFlags = ((cPacket.PeekByte And &HE0) / 32)
    ipData.iFrag = (cPacket.GetWORD And &H1FFF)
    ipData.bTTL = cPacket.GetByte
    ipData.bProto = cPacket.GetByte
    ipData.iCSum = cPacket.GetWORD
    ipData.sSrcIP = cPacket.GetByte & "." & cPacket.GetByte & "." & cPacket.GetByte & "." & cPacket.GetByte
    ipData.sDestIP = cPacket.GetByte & "." & cPacket.GetByte & "." & cPacket.GetByte & "." & cPacket.GetByte
    If ipData.bProto = 6 Then
      tcpData.iSrcPort = cPacket.GetWORD
      tcpData.iDestPort = cPacket.GetWORD
      tcpData.lSeqNum = cPacket.GetDWORD
      tcpData.lAckNum = cPacket.GetDWORD
      tcpData.bHLEN = (cPacket.GetByte And &HF0) / 16
      tcpData.bFlags = cPacket.GetByte
      tcpData.iWindow = cPacket.GetWORD
      tcpData.iCSum = cPacket.GetWORD
      tcpData.iUgntPtr = cPacket.GetWORD
      If tcpData.bHLEN * 4 > 20 Then
        lOptions = (tcpData.bHLEN * 4) - 20
        tcpData.sOptions = cPacket.GetString(lOptions)
        If lOptions Mod 4 > 0 Then
          lPadding = 4 - (lOptions Mod 4)
          Debug.Print "Padding of " & lPadding & " bytes"
          Debug.Print StH(cPacket.GetString(lPadding), True)
          'cPacket.Skip lPadding
        End If
      End If
    Else
      'MsgBox "Not TCP: " & ipData.bProto
    End If
  Else
    'MsgBox "Not IP: " & BufferHex(ethData.iType, 4)
  End If
Exit Sub
Erred:
  If ErrorHandler("clsTCPIP", "Sub Decode") Then Resume Next
End Sub
