VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsPacket"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit
Private Inbound     As String
Private Outbound    As String
Private lngPosition As Long
Private bEndianSwap As Boolean

Public Sub SwapEndian()
  bEndianSwap = Not bEndianSwap
End Sub

Public Sub ClearOutbound()
  Outbound = vbNullString
End Sub

Public Function CreateDWORD(ByVal value As Long) As String
Dim Result As String * 4
  RtlMoveMemory ByVal Result, value, 4
  If bEndianSwap Then Result = StrReverse$(Result)
  CreateDWORD = Result
End Function

Public Function CreateWORD(ByVal value As Integer) As String
Dim Result As String * 2
  RtlMoveMemory ByVal Result, value, 2
  If bEndianSwap Then Result = StrReverse$(Result)
  CreateWORD = Result
End Function

Public Function GetByte() As Byte
  If Len(Inbound) >= lngPosition Then
    GetByte = Asc(Mid$(Inbound, lngPosition, 1))
    lngPosition = lngPosition + 1
  End If
End Function

Public Function PeekByte() As Byte
  If Len(Inbound) >= lngPosition Then
    PeekByte = Asc(Mid$(Inbound, lngPosition, 1))
  End If
End Function

Public Function GetData() As String
  GetData = Inbound
End Function

Public Function GetDWORD() As Long
Dim sIn  As String
Dim rVal As Long
  If Len(Inbound) - lngPosition + 1 >= 4 Then
    sIn = Mid$(Inbound, lngPosition, 4)
    If bEndianSwap Then sIn = StrReverse$(sIn)
    RtlMoveMemory rVal, ByVal sIn, 4
    lngPosition = lngPosition + 4
    GetDWORD = rVal
  End If
End Function

Public Function GetNTString() As String
Dim rVal As String
  If InStr(Inbound, vbNullChar) > 0 Then
    If Len(Inbound) > 0 Then
      If Len(Mid$(Inbound, lngPosition)) > 0 Then
        rVal = TrimNull(Mid$(Inbound, lngPosition))
        lngPosition = lngPosition + Len(rVal) + 1
        GetNTString = rVal
      End If
    End If
  End If
End Function

Public Function GetNull() As String
  GetNull = Mid$(Inbound, lngPosition)
End Function

Public Function GetOutbound() As String
  GetOutbound = Outbound
End Function

Public Function GetString(ByVal lngLength As Long) As String
Dim rVal As String
  If Len(Inbound) > 0 Then
    rVal = Mid$(Inbound, lngPosition, lngLength)
    lngPosition = lngPosition + Len(rVal)
    GetString = rVal
  End If
End Function

Public Function GetWORD() As Long
Dim sIn  As String
Dim rVal As Long
  If Len(Inbound) - lngPosition + 1 >= 2 Then
    sIn = Mid$(Inbound, lngPosition, 2)
    If bEndianSwap Then sIn = StrReverse$(sIn)
    RtlMoveMemory rVal, ByVal sIn, 2
    lngPosition = lngPosition + 2
    GetWORD = rVal
  End If
End Function

Public Sub InsertByte(ByVal data As Byte)
  Outbound = Outbound & Chr$(data)
End Sub

Public Sub InsertDWORD(ByVal data As Long)
  Outbound = Outbound & CreateDWORD(data)
End Sub

Public Sub InsertNTString(ByVal data As String)
  Outbound = Outbound & data & vbNullChar
End Sub

Public Sub InsertString(ByVal data As String)
  Outbound = Outbound & data
End Sub

Public Sub InsertWORD(ByVal data As Integer)
  Outbound = Outbound & CreateWORD(data)
End Sub

Public Sub SetData(ByVal strValue As String)
  Inbound = strValue
  lngPosition = 1
End Sub

Public Sub Skip(ByVal intBytes As Integer)
  lngPosition = lngPosition + intBytes
End Sub

Public Sub SkipNTString()
Dim rVal As String
  If InStr(Inbound, vbNullChar) > 0 Then
    If Len(Inbound) > 0 Then
      If Len(Mid$(Inbound, lngPosition)) > 0 Then
        rVal = TrimNull(Mid$(Inbound, lngPosition))
        lngPosition = lngPosition + Len(rVal) + 1
      End If
    End If
  End If
End Sub
